
/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */
#include "cells.h"
#include "name_table.h"
#include "string_table.h"
#include "var_ren_table.h"

               /* the table used to store pointers to the name table */
NAME     *variable_name_table[VAR_NAME_TABLE_SIZE]; 

/*---------------------------------------------------------------------------
var_in_vnt(i, name)         

    i    = the first hash value of variable name to variable name table 
    name = variable name

note:
    care of open addressing is taken

description:
    If variable name is in variable name table 
        return a position (hash value) of variable name 
    else 
        return -1  
----------------------------------------------------------------------------*/
global int    
var_in_vnt(unsigned int i, char *name)
{
      natural incr;
      natural j;

      incr = 1;

      for (j = i;  variable_name_table[j] != NULL;
	   j = (j + incr)%VAR_NAME_TABLE_SIZE, incr += 2)
      {
           if (strcmp(name, String4(variable_name_table[j])) == 0)
	   {
	       return(j);
           }
	   if (incr%VAR_NAME_TABLE_SIZE == 0)
	       fatal("Out of space in variable name table %d",
		      VAR_NAME_TABLE_SIZE); 
      }
      return(-1);
}

/*----------------------------------------------------------------------------
add_var_in_vnt(i, ptr_to_name_table) 

    i = the first hash value of variable name to variable name table 

    It is assumed that name is not in variable name table   
 
    Add variable name in variable name table on hash value 
    (open addressing is used)

----------------------------------------------------------------------------*/
global void   
add_var_in_vnt(unsigned int i, NAME *ptr_to_name_table)
{
      natural j;
      natural incr;

      incr = 1;
      j = i;      

      for (j = i; variable_name_table[j] != NULL;
           j = (j + incr)%VAR_NAME_TABLE_SIZE, incr += 2)

	   if (incr%VAR_NAME_TABLE_SIZE == 0)
	       fatal("Out of space in variable name hash table %d", 
                      VAR_NAME_TABLE_SIZE); 

      variable_name_table[j] = ptr_to_name_table; 
}

/*----------------------------------------------------------------------------
hash_var_name_table(s, table_size) 

    Return the first hash value to variable name table for the string s.
                                   
----------------------------------------------------------------------------*/
global natural
hash_var_name_table(char *s, unsigned int table_size)
{
reg     natural n;
 
	n = 0;
	while (*s)  { 
		n *= 167;
		n ^= *s++;
        }
	return (n%table_size);
}
