/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	UNIFY_H
#define	UNIFY_H

#include "defs.h"
#include "x_registers.h"

#define	ALL_CHECKS	0
#define	DIRECT		1

/*
 * The occurs check properties must be kept in this order.
 */
#define STATIC_OCCURS	2
#define	DIRECT_OCCURS	1
#define	NONE		0

#define	DistinctObjectVar(d)	((d)[0])
#define	NextDistinction(d)	((cell *)((d)[1]))

extern	boolean	unify(VALUE *t1, VALUE *t2);
extern	boolean	unify_object_variable(VALUE *t1, VALUE *t2);
extern	boolean	unify_constant(cell constant, VALUE *t2);
extern	boolean	distinct_from(cell objvar1, cell objvar2);
extern	int	perform_occurs_check_sub(int type, VALUE *variable, cell sub);
extern	void	generate_distinction_information(cell objvar, cell sub);

#endif	/* UNIFY_H */
