/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef TERMIN_H
#define TERMIN_H
/* Interface to QuAM data structures */
#define make_constant(cellpo,tok) \
              ((* (cellpo)) = Atom(add_name_string_offset((tok)->buff, ATOM_W)))
#define mknil(cellpo)           ((* (cellpo)) = Atom(NIL))
#define mkint(cellpo,n)         ((* (cellpo)) = Integer(n))
#define symb_ref                (REFERENCE)
#define intvl(x)                (IntOf(x))
#define InstantiateTail(tail,head,val)      (*(tail) = Apply(), \
                                        Functor(*(tail)) = Apply(), \
                                        Functor(Functor(*(tail))) = \
                                                Atom(CONS),\
                                        (head) = &Head(val,*(tail)), \
                                        (tail) = &Tail(*(tail)))
typedef cell     *cellpo;

#endif	/* TERMIN_H */
