/* the table for renames used in portraycl */

#include <string.h>
#include "primitives.h"
#include "defs.h"
#include "errors.h"
#define TABLE_BLOCKSIZE 5
#define STRINGS_BLOCKSIZE 100 
#define LIST_BLOCKSIZE 20 
#define Var(r)               ((r)->var)
#define NameOff(r)           ((r)->name)
#define NameString(r)        (strings + NameOff(r))
typedef struct {
	cell	*var;
	unsigned name;
} Rename;
#define ListDef(r)           ((r)->list_defined)
#define LastNameOff(r)       ((r)->last_name)
#define Size(r)              ((r)->size)
#define Number(r)            ((r)->number)
#define List(r)              ((r)->list)
#define NumberObVar(r)       ((r)->number_obvar)
#define SizeObVar(r)         ((r)->obvar_size)
#define ListObVar(r)         ((r)->obvar_list)
#define NextFreeOff(r)       ((r)->next_free_offset)
#define LastNameString(r)    (strings + LastNameOff(r))
typedef struct {
        unsigned list_defined;
        unsigned last_name;
	unsigned size;
	unsigned number;
	Rename 	*list;
	unsigned obvar_size;
	unsigned number_obvar;
	cell **obvar_list; 
	int next_free_offset;
} ren_list_rec;

#define NOCHAIN	(-1)	/* marker for no next free chain */

/* global table pointers */
static ren_list_rec	*renames, 	/* the bottom of the hash table */
			*table_top,	/* the top of the table */
			*next_free;	/* the next free position */

static char	*strings;
static unsigned	table_size=0;
static unsigned strings_size=0;
static unsigned strings_pos=0;
 
/*  init_renames()  - allocates space for a table which is used to keep 
		    pointers to renamed lists of meta variable and 
		    object variable  
		    - allocates space for string table (A...Z,AA...AZ,...)
		    - we have two separate lists, one for meta variable
		    and one for object variable, but from higher level
		    we assume there is only one list for both
		     
*/
void
init_renames(void)
{
	if(!(renames = 
	        (ren_list_rec *)calloc(	table_size=TABLE_BLOCKSIZE,
					sizeof(ren_list_rec)
				      )
	    ))
	        fatal("unable to allocate space for variable renames");
	table_top = renames + table_size;
	next_free = renames;
	NextFreeOff(next_free) = NOCHAIN;
	if(!(strings = (char *)malloc(strings_size=STRINGS_BLOCKSIZE)))
		fatal("unable to allocate space for string table");
	strings_pos=0;
}

/* start_rename_list()    - returns offset to the instant next free position
                	  in the table where pointers to new lists will be	
                          put and set next_free pointer next free of that 
			  position 

*/
global unsigned  
start_rename_list(void)
{
        unsigned return_value;
         
        if (NextFreeOff(next_free) == NOCHAIN) {
	   if(next_free >= table_top - 1) {
	       unsigned size = table_size;
               if (!(renames = (ren_list_rec *)realloc( renames,
                    (table_size += TABLE_BLOCKSIZE) * sizeof(ren_list_rec)))) 
		     fatal("unable to reallocate space for variable renames");
               next_free = renames + size;
               table_top = renames + table_size;   
	       return_value = size - 1;
	    }
	    else
	       return_value = next_free++ - renames;
            NextFreeOff(next_free)= NOCHAIN;
        }          
	else {  
	   return_value = next_free - renames;
	   next_free = renames + NextFreeOff(next_free);
        }
	{ /* zero new entry */
	ren_list_rec *new_list = renames + return_value;
	ListDef(new_list) = 0;
	List(new_list) = (Rename *)0;
	ListObVar(new_list) = (cell **)0;
	LastNameOff(new_list) = 0;
	Size(new_list) = 0;
	Number(new_list) = 0;
	NumberObVar(new_list) = 0;
	SizeObVar(new_list) = 0;
	}
	return(return_value);
		
}
/* finish_rename_list(list_offset) - frees pointers to lists and set         
				   next_free pointer  to that position
				   (shown by list_offset )
*/
global void  
finish_rename_list(unsigned int list_offset)
{
        ren_list_rec   *rec = renames + list_offset;
        
	free(List(rec));
	free(ListObVar(rec));
	ListDef(rec) = 0;
	NextFreeOff(rec) = next_free - renames;
	next_free = rec;
}

/*is_renamed(variable, list_offset)   - returns corresponding string for a 
                                      meta variable, and  adds a pair
				      (meta variable, renamed name) in
				      a list if it is necessary

*/
global char *
is_renamed(cell *variable, unsigned int list_offset)
{
        static char *next_string(char *s);
	ren_list_rec 	*rec = (renames + list_offset);

        if(!List(rec))
	{
              if (!(List(rec) = (Rename *) calloc(Size(rec) = LIST_BLOCKSIZE,
                                                            sizeof(Rename))))
		     fatal("unable to allocate space for variable renames");
              Var(List(rec)) = variable;
              if (!(*strings)) 
                  LastNameOff(rec) = (unsigned)
				     (next_string("") - strings);
              else
                  LastNameOff(rec) = 0;
              NameOff(List(rec)) = LastNameOff(rec);
	      Number(rec) = 1;
	      ListDef(rec) = 1;
	      return(strings + NameOff(List(rec)));
        } 

        else { 
              Rename *cursor = List(rec);
	      if (ListDef(rec) == 0)  
		 error("ERROR - input list has not been defined");
	      ListDef(rec) = 1;
              while (((cursor - List(rec)) < Size(rec)) &&
	             ((cursor - List(rec)) < Number(rec)))
                   if (Var(cursor) == variable)
                       return(NameOff(cursor) + strings);
                   else 
		       cursor++;
              if (cursor >= List(rec) + Size(rec)) {
	           unsigned size = Size(rec);
                   if (!(List(rec) = (Rename *) realloc(List(rec),
                                  (Size(rec) += LIST_BLOCKSIZE) *
					       sizeof(Rename))))
                       fatal("unable to reallocate space for a list"); 
                   cursor = List(rec) + size; 
               } 
	       Var(cursor) = variable;
	       (Number(rec))++;
               if ((NameOff(cursor) 
		    = 
		    LastNameOff(rec) 
		    + 
		    strlen(strings + LastNameOff(rec)) 
		    + 
		    1
		   ) >= strings_pos
		  )
                     NameOff(cursor) 
		     = 
		     (unsigned)
		     (next_string(LastNameString(rec)) 
		      - 
		      strings
		     );
               return((LastNameOff(rec) = NameOff(cursor)) 
		      + strings
		     );

	}
}

/*is_ob_renamed(obvariabe, list_offset) returns corresponding number for a
                                        object variable and adds object   
					variable in a list if it is necessary

*/

global unsigned
is_ob_renamed(cell *obvariable, unsigned int list_offset)
{
	ren_list_rec 	*rec = (renames + list_offset);
        if(!ListObVar(rec))
	{
	  if (!(ListObVar(rec) 
		= 
		(cell **) 
		calloc(SizeObVar(rec) = LIST_BLOCKSIZE, 
		       sizeof(cell *))
		))
		  fatal("unable to allocate space for object variable renames");
              *ListObVar(rec) = obvariable;
	      NumberObVar(rec) = 1;
	      ListDef(rec) = 1;
              return(1);
        } 
	else 
	{
	      cell **cursor = ListObVar(rec);
	      if (ListDef(rec) == 0)  
		 error("ERROR - input list has not been defined");
	      ListDef(rec) = 1;
              while(((cursor - ListObVar(rec)) < NumberObVar(rec)) &&
                    ((cursor - ListObVar(rec)) < SizeObVar(rec)))
		    if(*cursor == obvariable)
		       return((unsigned)(cursor - ListObVar(rec) + 1));
		    else
		       cursor++;
              if (cursor - ListObVar(rec) >= SizeObVar(rec)) {
		   unsigned size = SizeObVar(rec); 
		   if (!(ListObVar(rec) = (cell **)  realloc(
                       ListObVar(rec),(SizeObVar(rec) += LIST_BLOCKSIZE) * 
	               sizeof(cell *))))	
                       fatal("unable to reallocate space ");
		   cursor = ListObVar(rec) + size; 
              }
	      *cursor = obvariable;
	      (NumberObVar(rec))++;
	      return((unsigned)(cursor - ListObVar(rec) + 1 ));
         }
}


static unsigned
put_string(char *s)
{
        unsigned strings_pos_b = strings_pos;
	if ((strings_pos += (strlen(s) + 1)) >= strings_size)
           if (!(strings = realloc(strings,
		             	  strings_size += STRINGS_BLOCKSIZE)))
               fatal("unable to reallocate space for variable renames");
	strcpy(strings + strings_pos_b, s);
	return(strings_pos_b);
}

/******************************************************************************/
/* next_string(s) adds the next string to the strings table and returns that  
	string.
	The order is informally as follows
	 A ... Z AA AB ... AZ BA ... ZZ AAA AAB ...
*/
 
static char * 
next_string(char *s)
             	/* string to be incremented */
{
	char *tmp;
	char *ret_str;
local	boolean inc_string(char *s);

	tmp = strdup(s);
	if(inc_string(tmp))
		ret_str= (strings + put_string(tmp));
	else
	{
		unsigned tmp_pos;
		tmp_pos = put_string("A");
		strings_pos--;
		put_string(tmp);
		ret_str = (strings + tmp_pos);
	}
	free(tmp);
	return(ret_str);
}

/*----------------------------------------------------------------------------
inc_string(s)  

    if s has been `incremented' successfully without overflow
        return TRUE 
    else (s has been `overflowed' )
        return FALSE
----------------------------------------------------------------------------*/
local boolean
inc_string(char *s)
{
	if(!(*s)) return(FALSE);
	if(inc_string(s + 1)) return(TRUE);
	if(*s == 'Z') 
		{*s = 'A'; return(FALSE);}
	{(*s)++; return(TRUE);}
}
