#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include "queue.h"

/*
typedef struct Queue {
        int *queue;
        int queuesize;
        int *head;
        int *next;
        int length;
} *queue;
*/

typedef int *intptr;

#define The_Q(q) ((q)->queue)
#define Qsize(q) ((q)->queuesize)
#define Qhead(q) ((q)->head)
#define Qnext(q) ((q)->next)
#define Qlength(q) ((q)->length)
#define Qempty(q) (Qlength(q) == 0)
#define Qfull(q) (Qlength(q) == Qsize(q))
#define Qavailable(q) (Qsize(q) - Qlength(q))

#define Inc(q, el) {if(++el >= (The_Q(q) + Qsize(q))) el = The_Q(q);}

#define Dec(q, el) {if(--el < The_Q(q)) el += Qsize(q);}


queue
new_q(int size)
{
    queue q;
    q = (queue)malloc(sizeof(queue_rec));
    Qsize(q) = size;
    The_Q(q) = (int *) malloc((unsigned)size*sizeof(int));
    Qhead(q) = The_Q(q);
    Qnext(q) = The_Q(q);
    Qlength(q) = 0;
    return(q);
}

int 
q_empty(queue q)
{
    return(Qempty(q));
}

int
join_q(queue q, int entry)
{
    if(!Qfull(q)) {
	*Qnext(q) = entry; 
	Inc(q, Qnext(q));
	Qlength(q) += 1;
	return(1);
    } else return(0);
}

int 
/* mjoin_q(queue q, int n, int e1, int e2, int e3, int e4, int e5, int e6, int e7, int e8, int e9, int e10) */
mjoin_q(queue q, int n, ...)
{
    int i;
    va_list ap;

    if(n > Qavailable(q)) return(0);
    /*
    if(n > 0) {
	join_q(q, e1);
	mjoin_q(q, n - 1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }
    */
    va_start(ap, n);
    for (i = n; i > 0; i--)
    {
	join_q(q, va_arg(ap, int));
    }
    va_end(ap);
    return(1);
}

int
serve_q(queue q, int *ip)
{
    if(Qempty(q)) return(0);
    *ip = *Qhead(q);
    Inc(q, Qhead(q));
    Qlength(q) -= 1;
    return(1);
}

int
/* mserve_q(queue q, int n, int *ip1, int *ip2, int *ip3, int *ip4, int *ip5, int *ip6, int *ip7, int *ip8, int *ip9, int *ip10) */
mserve_q(queue q, int n, ...)
{
    int i;
    va_list ap;

    if(n > Qlength(q)) return(0);
    /*
    if(n > 0) {
	serve_q(q, ip1);
	mserve_q(q, n - 1, ip2, ip3, ip4, ip5, ip6, ip7, ip8, ip9, ip10);
    }
    */
    va_start(ap, n);
    for (i = n; i > 0; i--)
    {
	serve_q(q, va_arg(ap, intptr));
    }
    va_end(ap);
    return(1);
}

int
chat_q(queue q, int *ip)
{
    if(Qempty(q)) return(0);
    *ip = *Qhead(q);
    return(1);
}


int 
mchat_q(queue q, int n, int *ip1, int *ip2, int *ip3, int *ip4, int *ip5, int *ip6, int *ip7, int *ip8, int *ip9, int *ip10)
{
    static void mchat_commit(queue q, int n, int *head, ...);
    int *dummy = Qhead(q);
    if(n > Qlength(q)) return(0);
    mchat_commit(q, n, dummy, ip1, ip2, ip3, ip4, ip5, ip6, ip7, ip8, ip9, ip10);
    return(1);
}

static void
/* mchat_commit(queue q, int n, int *head, int *ip1, int *ip2, int *ip3, int *ip4, int *ip5, int *ip6, int *ip7, int *ip8, int *ip9, int *ip10) */
mchat_commit(queue q, int n, int *head, ...)
{
    int i, *ip;
    va_list ap;

    /*
    if(n > 0){
	*ip1 = *head;
	Inc(q, head);
	mchat_commit(q, n - 1, head, 
		     ip2, ip3, ip4, ip5, ip6, ip7, ip8, ip9, ip10);
    }
    */
    va_start(ap, head);
    for (i = n; i > 0; i--)
    {
	ip = va_arg(ap, intptr);
	*ip = *head;
	Inc(q, head);
    }
    va_end(ap);
}


void
write_q(queue q)
{
	int i, *dummy = Qhead(q);
	fprintf(stderr, "(");
	for(i = 0; i < Qlength(q); i++){
	    fprintf(stderr, "%d ", *dummy);
	    Inc(q, dummy);
	}
	fprintf(stderr, ")\n");
}
