/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef PERSISTENT_H
#define PERSISTENT_H

#include "cells.h"
#include "errors.h"
#include "primitives.h"

#define	PNAME	struct	_PNAME

PNAME
{
	cell	name;
	cell	var;
	PNAME	*next;
};

#define	LSIZE	100
#define	LENTRY	struct	_LENTRY

LENTRY
{
	cell	heap;
	cell	ps;
};

#define DEFAULT_PVAR_SIZE	10
#define DEFAULT_PSTACK_SIZE	32
#define DEFAULT_PTRAIL_SIZE	11
#define	COMMIT_TAG		0x40000000

#define	Committed(t)		(((t)[1] & COMMIT_TAG) || \
				 ((t)[1] & ALL_DISTINCT))
#define	Commit(t)		((t)[1] = (t)[1] | COMMIT_TAG)
#define Uncommit(t)		((t)[1] = (t)[1] & (~COMMIT_TAG))
#define P(x)                            (pvar + 2 * x)
#define MaxPersistentVariables     	(((top_of_pvar - pvar) / 2) - 1)

#define PersistentConstant(c)		(PStackCheck(1),	\
					 *top_of_pstack++ = (c),	\
					 Reference(top_of_pstack-1))
#define	PersistentSubstitutionOperator()	((cell)(SUBSTITUTION_OPERATOR| \
							PersistentNewPair()))
#define NewPersistentVariable()		(PVarCheck(),	\
					 *top_of_pvar++ = NULL_VARIABLE,  \
					 *top_of_pvar++ = NULL,		\
					 Reference(top_of_pvar-2))
#define NewPersistentObjectVariable()  (PVarCheck(),	\
					 *top_of_pvar++ = NULL_OBJECT_VARIABLE, \
					 *top_of_pvar++ = NULL,	\
					 ObjectReference(top_of_pvar-2))
#define NewPersistentLocalObjectVariable()  (PVarCheck(),	\
					 *top_of_pvar++ = NULL_OBJECT_VARIABLE, \
					 *top_of_pvar++ = ALL_DISTINCT,	\
					 ObjectReference(top_of_pvar-2))
#define PersistentAllocate(n)		(PStackCheck(n),	\
					 top_of_pstack += (n),	\
					 (top_of_pstack - (n)))
#define NewPersistentSubstitution(t,n,p)  (PStackCheck(2),	\
					   *top_of_pstack++ = (t),  \
				 	   *top_of_pstack++ = (n),  \
					   NewProperty(top_of_pstack-2, p))
#define PersistentNewPair()		(PStackCheck(2),		\
					 *top_of_pstack++ = NULL_VARIABLE, \
					 *top_of_pstack++ = NULL_VARIABLE, \
					 (cell)(top_of_pstack-2))

#define PVarCheck()	(top_of_pvar > pstack ?	\
				fatal("Out of space in persistent variables %d K", \
						pvar_size) :	\
				(void)TRUE)
#define PStackCheck(n)	((top_of_pstack+(n)) > end_of_pstack ?	\
				fatal("Out of space in persistent stack %d K", \
						pstack_size) :	\
				(void)TRUE)

#define InPersistentStack(c)		(pvar <= Location(c) && 	\
					 Location(c) <= end_of_pstack)
#define	CommitStage(p)			((p) == ptrail ? 0 : *((p) - 1))
#define	PersistentTrail(t)	if (top_of_ptrail+1 > end_of_ptrail) \
				    fatal("Out of space in persistent trail %d K", \
						ptrail_size);	\
				else		\
				    *top_of_ptrail++ = (cell)(t)
#define	NewPersistentMetaVariable2(n)	(new_persistent_meta_var(n))
#define	NewPersistentObjectVariable2(n)	(new_persistent_object_var(n))

extern  cell    *pvar;
extern  cell    *top_of_pvar;
extern  natural pvar_size;


extern  cell    *pstack;
extern  cell    *top_of_pstack;
extern  cell    *end_of_pstack;
extern  natural pstack_size;

extern  cell    *ptrail;
extern  cell    *top_of_ptrail;
extern  cell    *end_of_ptrail;
extern  natural ptrail_size;

extern  void	initialise_persistent_area(void);
extern  void	initialise_persistent_trail(void);
extern	cell	commit_copy(cell *term);
extern	cell	commit_not_free(cell *term);
extern  boolean esc_new_persistent_meta_var(void);
extern  cell 	new_persistent_meta_var(cell name);
extern  boolean esc_new_persistent_object_var(void);
extern  cell	new_persistent_object_var(cell name);
extern	boolean	esc_persistent_meta_var(void);
extern	boolean	esc_persistent_object_var(void);
extern	boolean	esc_unpersistent_meta_var(void);
extern	boolean	esc_unpersistent_object_var(void);
extern	boolean	is_persistent_var(void);
extern	boolean	is_persistent_object_var(void);
extern	boolean	esc_persistent_name(void);
extern	cell	get_persistent_name(cell var);
extern	cell	get_persistent_name2(cell var);
extern	void	initialise_commit(void);

#endif /* PERSISTENT_H */
