/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef OPS_H
#define OPS_H

#include "defs.h"
#include "termio.h"

/* operatorpo field accessing macros */
#define	Op(p)		((p)->op)
#define	Lnk(p)		((p)->lnk)
#define	Hsh(p)		((p)->hsh)
#define	Prefixp(p)	((p)->prefixp)
#define	Preform(p)	((p)->preform)
#define	Infleft(p)	((p)->infleft)
#define	Infixp(p)	((p)->infixp)
#define	Infright(p)	((p)->infright)
#define	Postleft(p)	((p)->postleft)
#define	Postfixp(p)	((p)->postfixp)
#define	Quantp(p)	((p)->quantp)

void init_ops(void);

operatorpo oplook(char *name);

operatorpo is_op(token *tok);

unsigned quantifier(char *q);

boolean hash_op(char *o, int prep, int prefm, int infl, int infp, int infr, int postl, int postp, int quantp);

int get_prec(operatorpo op, int arity);

int get_assoc(operatorpo op, int arity);

/* unary prefix */
#define FX 0
#define FY 1

/* unary postfix */
#define XF 2
#define YF 3

/* binary postfix */
#define XFX 4
#define XFY 5
#define YFX 6
#define YFY 7

/* quantifier */
#define QUANT 8

global boolean esc_op_(void);
global boolean esc_first_op(int Ref);
global boolean esc_some_op(void);
global boolean esc_next_op(void);
global boolean esc_last_op(void);

#endif /* OPS_H */
