/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <sys/types.h>
#include <stdio.h>

#include "code_area.h"
#include "data_area.h"
#include "database.h"
#include "delayed_problems.h"
#include "errors.h"
#include "executable.h"
#include "execute.h"
#include "io.h"
#include "main.h"
#include "sig.h"
#include "object_vars.h"
#include "ops.h"
#include "options.h"
#include "persistent.h"
#include "renames.h"
#include "simplify.h"
#ifdef X11
#include "events.h"
#include "xwidgets.h"
#endif	/* X11 */

#ifdef EBUG
#include "spy.h"
#endif /* EBUG */

#include "string_map.h"
#include "string_table.h"
#include "trail.h"
#include "x_registers.h"

global	char	**argv_save;
global	code	*pc;
global	char	*init_sbrk;

/*----------------------------------------------------------------------------
    read the parameters from the command line
    load the executable file
    initialise the stacks
    execute the executable file
----------------------------------------------------------------------------*/

extern void init_flags (void);

global 	void
main(int argc, char **argv)
{
extern	caddr_t sbrk(int);
	char	*executable;


	init_sbrk = (char *)sbrk(0);

#ifdef	X11
	initialize_Xargs(&argc, argv);
#endif	/* X11 */

	OPTIONS ("-i N -s N -h N -t N -l N -x N [ arg ... ]")
		NUMBER  ('i', code_area_size)
		NUMBER  ('s', string_table_size)
		NUMBER  ('h', heap_size)
		NUMBER  ('t', trail_size)
		NUMBER  ('l', stack_size)
		NUMBER	('d', delayed_stack_size)
		NUMBER  ('x', num_x_registers)
		STRING	('Q', executable)
	ENDOPTS
	argv_save = argv;

	if (argc < 1)
		usage();

	load_executable(executable);
	initialise_data_area();
	initialise_trail();
	initialise_scratch_pad();
#ifdef	X11
	initialise_event_queue();
#endif	/* X11 */
	init_flags();
	init_object_vars();
	init_ops();
	initialise_persistent_area();
	initialise_persistent_trail();
	init_renames();
	initialise_x_registers();
	initialise_database_table();
	initialise_streams();
	initialise_string_map();
#ifdef	EBUG
	initialise_spied_predicates();
#endif /* EBUG */
	init_signals();
	execute();
	exit(0);
}
