#ifndef	ICP_H
#define	ICP_H
/*
    icp.h - main header file for IC-Prolog ][ emulator
    Written by Frank McCabe and Damian Chu
    Imperial College, 1989
	Nov. 1990	modified at Department of Computer Science
			University of Queensland
 */

#include <stdio.h>
#include <stdlib.h>
/* #include <signal.h>  delete during porting to Solaris */
#include <setjmp.h>
#include <string.h>
/* #include <math.h> */
#include "cells.h"
/* #include "opcodes.h"*/		/* pick up the list of opcodes */


#define EMPTY		1
#define READ		"r"
#define READBIN		"r"
#define WRITE		"w"
#define WRITEBIN	"w"
#define APPEND		"a"
#define APPENDBIN	"a"
#define BINDIR		"binary/"
#define SRCDIR		"source/"
#define SIZE_TYPE	int
#define FLOAT		double
/* #define CLOCKS_PER_SEC	1E6  delete during porting to Solaris */

/*

#ifndef __sys_stdtypes_h
typedef unsigned	size_t;
typedef long		clock_t;
#endif __sys_stdtypes_h

delete during porting to Solaris */

#define MAXFILENAME	80	/* max. length of a filename */



/* define our own integer for portability */
typedef	long		fourBytes;
typedef unsigned long	ufourBytes;
typedef	short		twoBytes;
typedef	unsigned short	utwoBytes;
typedef	char		oneByte;

typedef twoBytes	rwmode;
#define read_mode	0
#define write_mode	1

typedef oneByte         tags;



/* structure of a constant symbol */
#define	CHARTYPE	char


typedef CHARTYPE	*strpo;	/* define a pointer to a print name */
typedef struct symbol {
    tags tag;			/* this is a tag of type 'guard_ref' */
    oneByte cellLen;		/* only valid for symbols in the heap */
				/* length in cells if < 256 cells */
    union {
	struct {
	    utwoBytes lngth;	/* length of print name */
	    twoBytes hsh;	/* hash code of print name */
	} hc;
	fourBytes hshcde;	/* combination for fast test */
    } hhc;
    CHARTYPE prntname[EMPTY];	/* print name itself */
} *symbpo;

#define symbtag(addr)		(((symbpo)(addr))->tag)
#define symblen(addr)		(((symbpo)(addr))->cellLen)
#define symblngth(addr)		(((symbpo)(addr))->hhc.hc.lngth)
#define symbhash(addr)		(((symbpo)(addr))->hhc.hc.hsh)
#define symbhashval(addr)	(((symbpo)(addr))->hhc.hshcde)
#define symbname(addr)		(((symbpo)(addr))->prntname)

/* header size is 6 bytes.  (1 byte each for tag and cellLen, 2 for length and hash) */
#define symbSize(len,unit)	(((len) * sizeof(CHARTYPE) + 5) / (unit) + 1)
#define symMaxLen(cells,unit)	(((cells) * (unit) - 6) / sizeof(CHARTYPE))





/* structure of hash table entries */

typedef struct index {
    union {
	struct {
	    twoBytes size;
	    twoBytes sym;
	} functkey;
	fourBytes intkey;
    } key;
    short offset;
    short link;
} *indexpo;

/* macros for accessing index entries */
#define indexarity(addr)	(((indexpo)(addr))->key.functkey.size)
#define indexname(addr)		(((indexpo)(addr))->key.functkey.sym)
#define indexkey(addr)		(((indexpo)(addr))->key.intkey)
#define indexoffset(addr)	(((indexpo)(addr))->offset)
#define indexlink(addr)		(((indexpo)(addr))->link)



typedef twoBytes	opcode, *codepo;


typedef short io_type;
#define stream_t	0
#define memory_t	1

/* declarations for common memory allocation functions */
#define alloc(Number,Size)      calloc((size_t)(Number),(size_t)(Size))


/* general purpose macros */
#define max(a,b)		((a)<(b)?(b):(a))
#define min(a,b)		((a)<(b)?(a):(b))


/* ASCII values */
#define ASCIIMINUS	45
#define ASCIIZERO	48

extern cell *read_count_ptr;
extern CHARTYPE	new_charin(void);
extern boolean	new_charback(char c);
#define inc_read_count (*read_count_ptr = Integer(IntOf(*read_count_ptr)+1))
#define dec_read_count (*read_count_ptr = Integer(IntOf(*read_count_ptr)-1))
/* entry points for character level input output */
#define charin		((CHARTYPE) (new_charin()))
#define	charback(c)	((boolean) (new_charback(c)))

#endif	/* ICP_H */
