/*--------------------------------------------------------------------
  get_unify_delays.c   -   get unify delay problems 

 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.

  Revision History:
  =================

  Version  DD/MM/YY   Author   Description
  -------  --------   ------   ----------------------------------------
   1.0     01/03/93     SZ      get unify delays problems

--------------------------------------------------------------------*/
#include	"bind.h"	
#include	"cells.h"	
#include	"data_area.h"	
#include	"delayed_problems.h"
#include	"execute.h"
#include	"substitution.h"
#include	"x_registers.h"

global	cell	local_ob_var;

/*------------------------------------------------------------------------------
 For the given term build the new term - [x/v] * term, where x is new
 object variable and v is local object variable free in the term.
------------------------------------------------------------------------------*/

int free_local (VALUE *term);
extern cell apply (cell fn, cell argument);
extern int unify (VALUE *t1, VALUE *t2);
int free_local_sub (cell sub);

local	cell
build_term(VALUE *term)
{
	cell	*table;
	cell	sub, obvar, t;

	/* Create substitution - [obvar/local_ob_var]      */
	table = Allocate(3);
	sub = NewSubstitution((cell)table, EMPTY_SUB, INVERTIBLE);
	Size(sub) = (cell)1;
	obvar = NewObjectVariable();
	Domain(sub, 1) = local_ob_var; 
	Range(sub, 1) = obvar;
	freeness(obvar, term);
	/* Add the new substitution to the left 
	   of the substitution of the term */
	term->sub = add_substitution(term->sub, sub);
}

/*------------------------------------------------------------------------------
 Create a list of unify delay problems.
------------------------------------------------------------------------------*/
local cell
get_unify_delays(void)
{
	VALUE	term, left, right;
	cell	next, t, dvar;
	delayed	*d, *start_top_delayed_stack;
	cell	DelayList;
	boolean fixed_local;
	
	DelayList = Atom(NIL);
	
	start_top_delayed_stack = top_delayed_stack;
	/* Pass the delayed stack. */ 
	for (d = delayed_stack; d < start_top_delayed_stack; d++)
	{
		/* Only unsolved unification delayed problems are assumed */
		if ((d->tag & TYPEMASK) == UNIFY &&
			(d->tag & SOLVEDMASK) == UNSOLVED)
		{
			/* 
			   Create a term of the form: t1 = t2,
			   where t1 and t2 are term and variable 
			   from the unification delayed problem.
			*/
			t = Apply();
			Argument(t)= d->term;
			Functor(t) = Apply();
			Functor(Functor(t)) = Atom(add_name_string_offset(
						"=", ATOM_W));
			Argument(Functor(t)) = d->var;
			term.term = t;  
			term.sub = EMPTY_SUB;  
			/* Find free local object variable in the term. */
			fixed_local = FALSE;
			while (free_local(&term))
			{
				build_term(&term);
				fixed_local = TRUE;
			}
			if (fixed_local)
			{
				set((cell *)&(d->tag), (d->tag & ~SOLVEDMASK)|SOLVED);
				left.sub = term.sub;
				left.term = d->var;
				right.sub = term.sub;
				right.term = d->term;
				dvar = IsSubstitution(d->var) ?
						Term(d->var) : d->var;
				delay(UNIFY, Location(dvar),
					make_substitution(&left),
					make_substitution(&right));
			}
			next = make_substitution(&term);
			/* Add new term in the delayed list. */
			DelayList = Cons(next, DelayList); 
		}

	}
	return(DelayList);
}

/*------------------------------------------------------------------------------
 Get a list of unify delay problems.
------------------------------------------------------------------------------*/
global boolean
esc_get_unify_delays(void)
{
	VALUE	value;

	value.sub = EMPTY_SUB; 
	value.term = get_unify_delays();
	return(unify(&value, XV(0)));
}

/*------------------------------------------------------------------------------
 Create a list of unify delay problems.
------------------------------------------------------------------------------*/
global boolean
esc_get_first_unify_delay(void)
{
	VALUE	term, left, right;
	cell	next, t, dvar;
	delayed	*d;
	boolean	fixed_local = FALSE;
	
	/* Pass the delayed stack. */ 
	for (d = top_delayed_stack - 1; d >= delayed_stack; d--)
	{
		/* Only unsolved unification delayed problems are assumed */
		if ((d->tag & TYPEMASK) == UNIFY &&
			(d->tag & SOLVEDMASK) == UNSOLVED)
		{
			/* 
			   Create a term of the form: t1 = t2,
			   where t1 and t2 are term and variable 
			   from the unification delayed problem.
			*/
			t = Apply();
			Argument(t)= d->term;
			Functor(t) = Apply();
			Functor(Functor(t)) = Atom(add_name_string_offset(
						"=", ATOM_W));
			Argument(Functor(t)) = d->var;
			term.term = t;  
			term.sub = EMPTY_SUB;  
			/* Find free local object variable in the term. */
			while (free_local(&term))
			{
				build_term(&term);
				fixed_local = TRUE;
			}
			next = make_substitution(&term);
			if (fixed_local)
			{
				set((cell *)&(d->tag), (d->tag & ~SOLVEDMASK)|SOLVED);
				left.sub = term.sub;
				left.term = d->var;
				right.sub = term.sub;
				right.term = d->term;
				dvar = IsSubstitution(d->var) ?
						Term(d->var) : d->var;
				delay(UNIFY, Location(dvar),
					make_substitution(&left),
					make_substitution(&right));
			}
			return(unify(&term, XV(0)));
		}

	}
	return(FALSE);
}

/*------------------------------------------------------------------------------
  Find free local object variable in the term.
------------------------------------------------------------------------------*/
local   boolean
free_local(VALUE *term)
{
static  cell    unique = Atom(DOLLAR);
        VALUE  t1, t2;

        dereference(term);
        switch (Tag(term->term))
        {
        when CONSTANT:
                return(FALSE);

        when APPLY:
		t1.sub = t2.sub = term->sub;
		t1.term = Reference(&Functor(term->term));
		t2.term = Reference(&Argument(term->term));
		return(free_local(&t1) || free_local(&t2));

        when PAIR:
		t1.sub = t2.sub = term->sub;
		t1.term = Reference(&Left(term->term));
		t2.term = Reference(&Right(term->term));
		return(free_local(&t1) || free_local(&t2));

        when QUANTIFIER:
                t1.sub = RenameSub(BoundVar(term->term), unique, term->sub);
                t1.term = Reference(&Body(term->term));
                return(free_local(&t1));

        when REFERENCE:
                return(free_local_sub(term->sub));

        when OBJECT_REFERENCE:
                if (IsLocalObjectVariable(term->term))
		{
			local_ob_var = term->term;
                        return(TRUE);
		}
                else
		{
                        return(free_local_sub(term->sub));
		}

        otherwise:
                return(TRUE);
        }
}

/*------------------------------------------------------------------------------
  Find free local object variable in the substitution.
------------------------------------------------------------------------------*/
boolean 
free_local_sub(cell sub)
{
        int     i, j;
        VALUE   t;
	VALUE	term;

        for (; sub != EMPTY_SUB; sub = NextSub(sub))
        {
                for (i = Size(sub), j = 1; j <= i; j++)
                {
			term.sub = NextSub(sub);
			term.term = Range(sub, j);
                        if (free_local(&term))
			{
                        	return(TRUE);
			}
                }
        }
        return(FALSE);
}

