/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	ESCAPE_H
#define	ESCAPE_H

#include "defs.h"

typedef struct
{
	boolean		(*pred)();
	natural		arity;
	char		*name;
} built_in;

extern built_in	escape_predicate_table[];
#ifdef	X11
extern built_in	escape_x_pred_table[];
#endif	/* X11 */
#ifdef	EBUG
extern built_in	escape_debug_pred_table[];
#endif	/* EBUG */

/*
 * Standard Escape Predicates:	  1 - 200
 * X Escape Predicates:		201 - 240
 * Debug Escape Predicates:	241 - 255
 */
#define	StartXPred	201
#define	StartDebugPred	241

#define	EscapePredicate(n)	(escape_predicate(n))
#define	EscapePredicateName(n)	(escape_name(n))
#define	EscapePredicateArity(n)	(escape_arity(n))

extern	boolean	escape_predicate(unsigned int n);
extern	char *	escape_name(unsigned int n);
extern	natural	escape_arity(unsigned int n);

#endif	/* ESCAPE_H */
