/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <stdio.h>
#include <stdarg.h>
#include "defs.h"
#include "errors.h"

global void
error(char *fmt, ...)
{
#ifdef X11
	/* this is wrong under ANSI C version */
	werror(fmt, x1, x2, x3, x4, x5, x6, x7, x8, x9);
#else
	va_list ap;

	va_start(ap, fmt);
	vfprintf(stderr, fmt, ap);
	va_end(ap);
	fprintf(stderr, "\n");
#endif /* X11 */
}

global  void
verror(char *fmt, va_list ap)
{
#ifdef X11
	/* unknown under ANSI C version */
#else
	vfprintf(stderr, fmt, ap);
#endif /* X11 */
}

global int
errorc(char c)
{
#ifdef X11
	return(werrorc(c));
#else
	return(fputc(c, stderr));
#endif /* X11 */
}
