/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	DELAY_H
#define	DELAY_H

#include "defs.h"
#include "primitives.h"
#include "x_registers.h"

typedef	struct
{
	int	tag;
	cell	var;
	cell	term;
} delayed;

#define	DEFAULT_DELAYED_STACK_SIZE	1

#define TYPEMASK        0x00000001
#define UNIFY           0x00000000
#define NOT_FREE        0x00000001

#define	SOLVEDMASK	0x00000020
#define	UNSOLVED	0x00000000
#define	SOLVED		0x00000020

#define Delay(d)	((delayed *)((d)[0]))
#define DelayedVar(d)	(Delay(d)->var)
#define DelayedTerm(d)	(Delay(d)->term)
#define DelayedType(d)	(Delay(d)->tag&TYPEMASK)
#define DelayedSolved(d)	(Delay(d)->tag&SOLVEDMASK)
#define	NextField(d)		((d)[1])
#define	Next(d)		((cell *)(NextField(d)))
#define Solved(d)	set((cell *)&(Delay(d)->tag),\
			    (Delay(d)->tag&~SOLVEDMASK)|SOLVED)

extern	natural	delayed_stack_size;
extern	delayed	*delayed_stack;
extern	delayed	*top_delayed_stack;
extern	delayed	*end_delayed_stack;
extern	cell	*delayed_problems_pointer;
extern	void	delay(int type, cell *variable, cell left, cell right);
extern	boolean	do_delayed_problem(cell *d);
extern	void	append_delayed_problems(cell *dest, cell *problems);
extern	boolean	freeness(cell objectvar, VALUE *term);
extern	boolean	not_free_in(cell objvar, VALUE *term);
extern  boolean esc_first_delayed_problem(void);
extern  boolean esc_get_delayed_problem(void);
extern  boolean esc_next_delayed_problem(void);
extern	boolean esc_check_delayed_problem(void);
extern	boolean test_delayed_problem(int type);
extern	boolean	try_delay_problems(void);
extern	boolean	retry_delay_problems(void);
extern	boolean	retry_delay(void);
extern	boolean	retry_nfi_delay(void);

#endif	/* DELAY_H */
