/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef DEBUG_H
#define DEBUG_H

#ifdef EBUG_INST
#define	DebugOp(x)		fprintf(stderr, #x " ")
#define	DebugConstant(x)	IsAtom(x) ? DebugString(x) : \
					    DebugNumber(IntOf(x))
#define DebugString(x)		fprintf(stderr, "%s ", String(x))
#define DebugString2(x)		fprintf(stderr, "%s ", x)
#define	DebugNumber(x)		fprintf(stderr, "%d ", x)
#define	Debugln			fprintf(stderr, "\n");
#endif /* EBUG_INST */
#define	DebugOp(x)		fprintf(stderr, #x " ")
#define	Debugln			fprintf(stderr, "\n");

#ifdef EBUG
#define	BlockSize(block)	*((int *)((char *)block - 4))

extern	void	spy(char *type, char *predicate_name, unsigned int arity);
extern	void	writeln_termv(VALUE *term);
extern	void	write_termv(VALUE *term);
extern	void	writeln_term(cell *term);
extern	void	write_term(cell *term);
extern	void	writeln_termv_deb(VALUE *term);
extern	void	write_termv_deb(VALUE *term);
extern	void	writeln_term_deb(cell *term);
extern	void	write_term_deb(cell *term);
extern	void	write_sub(cell sub);
extern	void	write_delay(cell variable);
extern	void	write_delayed_stack(void);
extern	void	write_distinctness_info(cell objectvar);
extern	void	dump_positions(void);

extern  void	crash();
extern  void	nop_crash();
#endif /* EBUG */

#endif /* DEBUG_H */
