/*--------------------------------------------------------------------
  copy_term.h   -     copy the term to the heap

 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.

  Revision History:
  =================

  Version  DD/MM/YY   Author   Description
  -------  --------   ------   ----------------------------------------
   1.0     20/08/92     SZ      copy  a term onto the heap

--------------------------------------------------------------------*/

#include "cells.h"
#include "data_area.h"
#include "x_registers.h"

/*
 * Copy term onto the heap.
 */


extern int unify (VALUE *t1, VALUE *t2);
extern int determine_property (cell sub);

cell
copy_to_h(cell term)
{
        cell        t;
local   cell        copy_sub(cell sub);

        variable_dereference(&term);
        switch (Tag(term))
        {
        case CONSTANT or OBJECT_REFERENCE:
                t = term;
                break;
        case APPLY:
                t = Apply();
                Functor(t) = copy_to_h(Reference(&Functor(term)));
                Argument(t) = copy_to_h(Reference(&Argument(term)));
                break;
        case QUANTIFIER:
                t = Quantifier();
                BoundVar(t) = BoundVar(term);
                Body(t) = copy_to_h(Reference(&Body(term)));
                break;
        case REFERENCE:
                t = term;
                break;
        case SUBSTITUTION_OPERATOR:
                t = SubstitutionOperator();
                Substitution(t) = copy_sub(Substitution(term));
                Term(t) = copy_to_h(Reference(&Term(term)));
                break;
        default:
                t = term;
        }
        return(t);
}

/*
 * Escape predicate. 
 * Copy term onto the heap. 
 */

boolean
esc_copy_to_heap(void)
{
	VALUE	copied_term, c;
        boolean   b;

        
        c.sub = EMPTY_SUB; 
	c.term = copy_to_h((cell)(SUBSTITUTION_OPERATOR|(int)XV(0)));
	b = unify(XV(1), &c);
	return(b);
}

/*
 * Copy substitution onto the heap. 
 */ 

local   cell
copy_sub(cell sub)
{
        cell    s, next, *table;
        int     i, j, p;

        if (sub  == EMPTY_SUB)
        {
                return(EMPTY_SUB);
        }
        else
        {
                next = copy_sub(NextSub(sub));
                table = Allocate(2 * Size(sub) + 1);

                s = NewSubstitution((cell)table, next, OTHERS);
                Size(s) = Size(sub);
                for(i = 1, j = Size(sub); i <= j; i++)
                {
                        Domain(s, i) = Domain(sub, i);
                        Range(s, i) = copy_to_h(Range(sub, i));
                }
                p = determine_property(s);
                s = NewProperty(s, (Property(sub) == INVERTIBLE
                                    ? INVERTIBLE
                                    : (Property(next) > p 
                                       ? Property(next)
                                       : p)));
        }
        return(s);
}
