/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "cells.h"
#include "bind.h"
#include "build_term.h"
#include "data_area.h"
#include "dereference.h"
#include "examine_term.h"
#include "execute.h"
#include "name_table.h"
#include "ops.h"
#include "substitution.h"
#include "system.h"
#include "unify.h"
#include "x_registers.h"

global	boolean
quantify(void)
{
	VALUE	val;
	VALUE	quant;
	VALUE	objvar;
	VALUE	body;

	if (IsReference(Xdref(2)) && IsApply(Xdref(0)) &&
	    IsQuantifier(DerefTerm(val, Reference(&Argument(X(0))))))
	{	/* quantify(q x t, Q, X, T) */
		quant.sub = EMPTY_SUB;
		quant.term = Reference(&Functor(X(0)));
		objvar.sub = EMPTY_SUB;
		objvar.term = Reference(&BoundVar(val.term));
		body.sub = EMPTY_SUB;
		body.term = Reference(&Body(val.term));
		return(unify(&quant, XV(1)) &&
		       unify(&objvar, XV(2)) &&
		       unify(&body, XV(3)));
	}
	else if (quantifier(String(Xdref(1))) && IsObjectReference(Xdref(2)))
	{	/* quantify(Quant, Q, x, T) */
		quant.sub = EMPTY_SUB;
		quant.term = build_quantify(X(1), X(2), 
					    make_substitution(XV(3)));
		return(unify(XV(0), &quant));
	}
	else
		return(FALSE);
}

global	cell
build_quantify(cell q, cell objvar, cell term)
{
	cell	quant;

	quant = Apply();
	Assign(Functor(quant), q);
	Argument(quant) = Quantifier();
	BoundVar(Argument(quant)) = objvar;
	Assign(Body(Argument(quant)), term);
	return(quant);
}

global	boolean
esc_substitute(void)
{
	VALUE	list;
	VALUE	term;
local	cell	substitution_to_list(cell sub);
local	boolean	list_to_substitution(cell *dest, cell list);

	if (IsList(Xdref(1)) || IsNIL(X(1)))
	{	/* $substitute(S, s, t) */
		term.term = X(2);
		return(list_to_substitution(&term.sub, X(1)) &&
		       unify(XV(0), &term));
	}
	else if (IsReference(X(1)))
	{	/* $substitute(s*t, S, T) */
		dereference(XV(0));
		list.sub = EMPTY_SUB;
		list.term = substitution_to_list(XS(0));
		term.sub = EMPTY_SUB;
		term.term = X(0);
		return(unify(XV(1), &list) && unify(XV(2), &term));
	}
	else
		return(FALSE);
}

global	cell
build_substitute(cell sub, cell term)
{
local	boolean	list_to_sub(cell *dest, cell list, cell tail);
	VALUE	subterm;

	subterm.sub = EMPTY_SUB;
	subterm.term = term;
	return(list_to_sub(&(subterm.sub), sub, subterm.sub) ?
		make_substitution(&subterm) : NULL);
}

local	boolean
list_to_substitution(cell *dest, cell list)
{
local	boolean	list_to_sub(cell *dest, cell list, cell tail);
	cell	end = EMPTY_SUB;
	VALUE	val;
	VALUE	val_h;

	for (DereferenceTerm(val, list); !IsNIL(val.term);
	     DereferenceTerm(val, Tail(val.term)))
		if (!IsList(val.term) ||
		    !list_to_sub(&end, Head(val_h, val.term), end))
			return(FALSE);
	*dest = end;
	return(TRUE);
}

local	boolean
list_to_sub(cell *dest, cell list, cell tail)
{
	cell	div = Atom(add_name_string_offset("/", ATOM_W));
	VALUE	val;
	VALUE	head;
	VALUE	domain;
	VALUE	range;
	VALUE	val_h;
	cell	*table;
	int	i, j;
	int	property;
	natural	n;

	DereferenceTerm(val, list);
	if (!length(&val, &n))
		return(FALSE);
	else
	{
		table = Allocate(2 * n + 1);
		*dest = NewSubstitution((cell)table, tail, OTHERS);
		Size(*dest) = (cell)n;
		for (i = n; i > 0; i--)
		{
			if (!IsList(val.term))
				return(FALSE);
			else
			{
				DereferenceTerm(head,
						Reference(&Head(val_h,
								val.term))); 
				if (IsApply(head.term) && 
				    fetch_functor(head.term) == div &&
				    IsObjectReference(DerefTerm(domain,
					Reference(&Argument(head.term)))))
				{
					for (j = n; j > i; j--)
						if (Domain(*dest, j) ==
						    domain.term)
							return(FALSE);
					Domain(*dest, i) = domain.term;
					Range(*dest, i) =
					    Reference(&Argument(
						DerefTerm(range,
						    Reference(
							&Functor(head.term)))));
				}
				else
					return(FALSE);
			}
			DereferenceTerm(val, Tail(val.term));
		}
		property = determine_property(*dest);
		*dest = NewProperty(*dest, (Property(tail) > property ?
						Property(tail) : property));
		return(TRUE);
	}
}

local	cell
substitution_to_list(cell sub)
{
local	cell	sub_to_list(cell sub);
	cell	list = Atom(NIL);

	for (; sub != EMPTY_SUB; sub = NextSub(sub))
		list = Cons(sub_to_list(sub), list);
	return(list);
}

local	cell
sub_to_list(cell sub)
{
	cell	div = Atom(add_name_string_offset("/", ATOM_W));
	int	i, n;
	cell	list = Atom(NIL);

	for (i = 1, n = Size(sub); i <= n; i++)
		list = Cons(apply(apply(div, Reference(&Range(sub, i))), Domain(sub, i)),
			    list);
	return(list);
}

global	boolean
esc_new_dynamic_object_var(void)
{
	VALUE	val;

	val.sub = EMPTY_SUB;
	val.term = NewObjectVariable();
	return(unify(XV(0), &val));
}

global	boolean
esc_new_local(void)
{
	VALUE	val;

	val.sub = EMPTY_SUB;
	val.term = NewLocalObjectVariable();
	return(unify(XV(0), &val));
}


static cell
append_inner(cell T1, cell T2)
{
        VALUE val_h;
	if(IsNIL(T1))
		return(T2);
	else
		return(Cons(Head(val_h, T1), append_inner(Tail(T1), T2)));
}

global boolean
esc_append(void)
{
	VALUE newlist;
	newlist.sub = EMPTY_SUB;
	if((IsList(Xdref(0)) || IsNIL(X(0))) 
	   && 
	   (IsList(Xdref(1)) || IsNIL(X(1)))) {
		newlist.term = append_inner(X(0), X(1));
		return(unify(&newlist, XV(2)));
	}
	else
		return(FALSE);
}
