/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#ifndef	BIND_H
#define	BIND_H

#include "cells.h"
#include "data_area.h"

#define Bind(v,t)			bind_term(Location(v), (t))
#define BindVariable(v1,v2)		bind_variable(Location(v1),	\
						      Location(v2))
#define BindObjectVariable(v1,v2)	bind_object_variable(Location(v1), \
							     Location(v2))
#define SetDistinct(v1,v2)		(InHeapStack(Location(v1)) ? 	\
						set(&Distinction(v1),	\
						    NewDistinction(v2,	\
							Distinction(v1))) : \
						set(&Distinction(v2),	\
						    NewDistinction(v1,	\
							Distinction(v2))))

extern	void	set(cell *var, cell term);
extern	void	bind_term(cell *var, cell term);
extern	void	bind_variable(cell *x, cell *y);
extern	void	bind_object_variable(cell *x, cell *y);

#endif	/* BIND_H */
