/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "arithmetic.h"
#include "cells.h"
#include "unify.h"
#include "x_registers.h"
/* #include <math.h> */


int power (int m, int n);

global	boolean esc_times(void)		ArithIntOp2(*)
global	boolean esc_divide(void)	ArithIntOp2(/)
global	boolean esc_plus(void)		ArithIntOp2(+)
global	boolean esc_minus(void)		ArithIntOp2(-)
global	boolean esc_mod(void)		ArithIntOp2(%)
global	boolean esc_power(void)		ArithIntFn2(power)
global	boolean esc_bitwise_and(void)	ArithIntOp2(&)
global	boolean esc_bitwise_or(void)	ArithIntOp2(|)
global	boolean esc_bitwise_xor(void)	ArithIntOp2(^)
global	boolean esc_shift_left(void)	ArithIntOp2(<<)
global	boolean esc_shift_right(void)	ArithIntOp2(>>)
global	boolean esc_minus1(void)	ArithIntOp1(-)
global	boolean esc_complement(void)	ArithIntOp1(~)
global	boolean esc_not(void)		ArithIntOp1(!)
global	boolean esc_lt(void)		ArithIntOp2(<)
global	boolean esc_leq(void)		ArithIntOp2(<=)
global	boolean esc_gt(void)		ArithIntOp2(>)
global	boolean esc_geq(void)		ArithIntOp2(>=)
global	boolean esc_less_than(void)	ArithIntPred1(<)


/* power(m, n) implements m^n. (index powers) */
global int
power(int m, int n)
{
	int	tmp;

	tmp = 1;
	while (n-- > 0)
		tmp *= m;
	return(tmp);
}

