/*----------------------------------------------------------------------------
once(Goal) :-
    Obtain the first solution.
----------------------------------------------------------------------------*/
once(Goal) :-
	call(Goal),
	!.

append([], L, L).
append([X|L1], L2, [X|L3]) :-
	append(L1, L2, L3).

writeln(X) :-
	write(X),
	nl.

writeln(Stream, X) :-
	current_output(O),
	set_output(Stream),
	writeln(X),
	set_output(O).

member(X, [X|_]).
member(X, [_|L]) :-
	member(X, L).

merge([], List2, List2).
merge([Head1|Tail1], [], [Head1|Tail1]).
merge([Head1|Tail1], [Head2|Tail2], Merged) :-
        compare(C, Head1, Head2),
        (C = (<)
        ->      Merged = [Head1|Merged1],
                merge(Tail1, [Head2|Tail2], Merged1)
        ; (C = (=)
        ->      Merged = [Head1|Merged1],
                merge(Tail1, Tail2, Merged1)
        ;       Merged = [Head2|Merged1],
                merge([Head1|Tail1], Tail2, Merged1)
        )).

isList([]).
isList([_|L]) :-
	isList(L).

reverse(A, B) :-
        '$rev2'(A, [], B).                

'$rev2'([], A, A).
'$rev2'([A|B], C, D) :-
        '$rev2'(B, [A|C], D).
