/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * registers - Declarations for the X and Y QuAM registers.
 */

/*----------------------------------------------------------------------------
x_register(N, X) :-
    X is the internal compiler representation of the QuAM X register N.
    i.e. rX(N)
----------------------------------------------------------------------------*/
x_register(N, rX(N)).

/*----------------------------------------------------------------------------
x_register(X) :-
    This procedure will succeed if X is the internal representation of
    a QuAM X register.
----------------------------------------------------------------------------*/
x_register(rX(_N)).

/*----------------------------------------------------------------------------
allocate_x_registers(Args) :-
    Allocates register numbers from 0 to the variables in the list Args.
----------------------------------------------------------------------------*/
allocate_x_registers(Args) :-
    allocate_x_registers(Args, 0).


/*----------------------------------------------------------------------------
allocate_x_registers(Args, N) :-
    Allocates register numbers from N to the variables in the list Args.
----------------------------------------------------------------------------*/
allocate_x_registers([], _N).
allocate_x_registers([X|Args], N) :-
    x_register(N, X),
    M is N + 1,
    allocate_x_registers(Args, M).

/*----------------------------------------------------------------------------
y_register(N, Y) :-
    Y is the internal compiler representation of the QuAM Y register N.
    i.e. rY(N)
----------------------------------------------------------------------------*/
y_register(N, rY(N)).

/*----------------------------------------------------------------------------
y_register(Y) :-
    This procedure will succeed if Y is the internal representation of
    a QuAM Y register.
----------------------------------------------------------------------------*/
y_register(rY(_N)).
