/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * qc1 - Main module for the Qu-Prolog compiler.
 */
:- dynamic coption/1, filename_prefix/1.

main(_) :-
	unix(argv(Args)),
	qc1(Args).

/*----------------------------------------------------------------------------
qc1(CommandLine) :-
    CommandLine is the unix commandline fed to this entry routine for the 
    Qu-Prolog compiler.

    Process the parameters and then compile the incoming file(std input).
    The "-debug" command-line option is for maintenance personel to turn
    on the generation of comments in the ".qs" file.  Because of the
    nature of the comments, it may not be possible to assemble the ".qs" file.
----------------------------------------------------------------------------*/
qc1(['debug'|Args]) :-
    assert(coption(debug)),
    qu_compile(Args).
qc1(Parms) :-
    assert(coption(nodebug)),
    qu_compile(Parms).

/*----------------------------------------------------------------------------
qu_compile(NewParms) :-
    Compile the file in filename e.g. foo.ql and write to foo.qs
    if there are any parameters at this stage (after parameter processing)
    then abort.
----------------------------------------------------------------------------*/
qu_compile([FileName]) :-
    save_prefix(FileName), !,
    once(
    (
	filename_prefix(Prefix),
	write(user_error, 'compiling('),
	name(PrefixName, Prefix),
	write(user_error, PrefixName),
	writeln(user_error, '.ql)'),
	read_procedures,
	% statistics(Stats),
	% writeln(Stats),
	unix(exit(0))
    ;
	write(user_error, 'Error : compile failed for '),
	writeln(user_error, FileName),
	unix(exit(1))
    )).
qu_compile([FileName]) :-
    !,
    write(user_error, 'Error : '),
    write(user_error, FileName),
    writeln(user_error, ' must have a .ql extension'),
    unix(exit(1)).
/*
qu_compile([_Args]) :-
    write(user_error, 'Error : '),
    write(user_error, CallName),
    writeln(user_error, ' filename.ql'),
    unix(exit(1)).
*/

/*----------------------------------------------------------------------------
save_prefix(FileName) :-
    Asserts the fact "filename_prefix(Prefix)"
----------------------------------------------------------------------------*/
save_prefix(FileName) :-
    abolish(filename_prefix, 1),
    name(FileName, FileNameString),
    append(Prefix, ".ql", FileNameString),
    assert(filename_prefix(Prefix)).

input_filename(FileName) :-
    filename_prefix(Prefix),
    append(Prefix, ".ql", FileNameString),
    name(FileName, FileNameString).
output_filename(FileName) :-
    filename_prefix(Prefix),
    append(Prefix, ".qs", FileNameString),
    name(FileName, FileNameString).
