/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * permalloc - Allocate Y registers to a predicate's permanent varaibles.
 */

/*----------------------------------------------------------------------------
permalloc(PermanentVars, EnvSize) :-
    PermanentVars is the list of permanent variables in the clause, ordered 
    from the last occurence of the variable in the clause. Allocate the 
    variables with their register names rY(i).
    EnvSize is the number of temporary variables in the environment.
----------------------------------------------------------------------------*/
permalloc(PermanentVars, EnvSize) :-
    permalloc2(PermanentVars, 0),
    length(PermanentVars, EnvSize).


/*----------------------------------------------------------------------------
permalloc2(PermanentVars, N) :-
    Allocate the variables in PermanentVars with rY(i), i = 0 ... N-1
----------------------------------------------------------------------------*/
permalloc2([], _N).
permalloc2([Y|PermanentVars], N) :-
    y_register(N, Y),
    M is N + 1,
    permalloc2(PermanentVars, M).
