/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * objvar - Object variable declarations for the Qu-Prolog compiler.
 */

:- dynamic '$object_var_prefix'/1.
% :- op(700, xfx, distinct_from).
:- op(600, xfy, not_free_in).
 
/*
 * Declare X to be object variable prefix.
 */
object_var([]) :- !. 
object_var([X|L]) :-  
    !, 
    object_var(X), 
    object_var(L).
object_var(X) :-
    atom(X),
    !,
    (\+ '$object_var_prefix'(X) ->
	 assert('$object_var_prefix'(X))
    ;
	true
    ).
object_var(X) :-
    write(user_error, X),
    writeln(user_error, ' is not atom for object_var/1').

'$object_var_prefix_declared'(X):-
    '$object_var_prefix'(X), !.
'$object_var_prefix_declared'(X):-
    name(X, XL),
    '$object_var_prefix'(Objvar),
    name(Objvar, ObjvarL),
    append(ObjvarL, [0'_|_], XL).

/*
distinct_from(X, Y) :-
    is_object_var(X),
    is_object_var(Y),
    not_free_in(X, Y).
 */
