/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 *
 * misc - Miscellaneous library routines for the Qu-Prolog compiler.
 */

/*----------------------------------------------------------------------------
rhs_list(Rhs, List) :-
    True, if Rhs is a valid rhs.

    List is the list representation of the rhs Rhs.
----------------------------------------------------------------------------*/
rhs_list(End, [End]) :-
    var(End), !.
rhs_list((Head, Tail), [Head, Neck|Tail2]) :-
    !,
    rhs_list(Tail, [Neck|Tail2]).
rhs_list(End, [End]).

/*----------------------------------------------------------------------------
replace(A, B) :-
    True, if the clause A exists in the database.
    Replace clause A with clause B in the database.

    Fail on redo.
----------------------------------------------------------------------------*/
replace(A, B) :-
    retract(A), !,
    assert(B).

/*----------------------------------------------------------------------------
incr(F) :-
    Increment the counter, F. 
	e.g. F = frame_number 
	     frame_number(3) --> frame_number(4)
    on backtrack undo the increment 
	     frame_number(4) --> frame_number(3)
----------------------------------------------------------------------------*/
incr(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C + 1,
    Y =.. [F, D],
    assert(Y).
incr(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C - 1,
    Y =.. [F, D],
    assert(Y),
    fail.

/*----------------------------------------------------------------------------
decr(F) :-
    decrement the counter, F. 
	e.g. F = frame_number 
	     frame_number(4) --> frame_number(3)
    on backtrack undo the decrement 
	     frame_number(3) --> frame_number(4)
----------------------------------------------------------------------------*/
decr(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C - 1,
    Y =.. [F, D],
    assert(Y).
decr(F) :-
    X =.. [F, C],
    once(retract(X)),
    D is C + 1,
    Y =.. [F, D],
    assert(Y),
    fail.

/*----------------------------------------------------------------------------
member2(X, Xs) :-
    true if X is an element of the list, Xs.
    note: difference from member/2, is ==/2 instead of =/2.
----------------------------------------------------------------------------*/
member2(X, [Y|_Xs]) :-
    X == Y, !.
member2(X, [_Y|Xs]) :-
    member2(X, Xs).
