/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "io.h"
#include "put_code.h"

#define	QUERY_CODE_AREA_BLOCK_SIZE 1024

put_thing	query_code;


extern void fatal (char *, ...);

void
init_query_code(void)
{
	query_code = make_new_put_thing(QUERY_CODE_AREA_BLOCK_SIZE);
	}

void
write_query_code(void)
{
	int size = (int)query_code->position - (int) query_code->base;

	/* write_size of query code area */
	write_integer(size);

	/* write code */
	if(size)
	if(!write_block(query_code->base, size))
		fatal("Can't write query code area (size %d)", size);
	}
