%a 40000
%e 2000
%p 7000
%n 700
%o 100000
%k 100
%{
/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <ctype.h>
#include "labels.h"
#include "put_code.h"
#include "procedures.h"
#include "hash_table.h"
#include "query_code.h"
#include "string_table.h"
#include "opcodes.h"
#include "args.h"
#include "built_in.h"

#define	SWITCH_ON_CONSTANT_ENTRY_SIZE (CONSTANT_SIZE + OFFSET_SIZE)
#define	SWITCH_ON_STRUCTURE_ENTRY_SIZE (CONSTANT_SIZE + NUMBER_SIZE + OFFSET_SIZE)
#define	SWITCH_ON_QUANTIFIER_ENTRY_SIZE (CONSTANT_SIZE + NUMBER_SIZE + OFFSET_SIZE)


void getln()
        {
        int i=0;
        while( ((linebuf[i] = input()) != EOF) && (linebuf[i] != '\n') )
		if((++i + 1) >= linebuf_dim) expand_linebuf();
        in_string = linebuf;
	linebuf[++i] = (char)0;
	}

int is_num(char *s)
	{
	/* if pointer is NULL or s has zero length return false */
	if(!s || !*s) return 0;

	/* if s has length > 1 */
	if(*(s+1))	return(isdigit(*s) && is_num(++s));
	/* else s is of length 1 */
	else		return(isdigit(*s));
	}

/* main lex procedures ********************************************/
void
yyinit()
	{
	init_procedures();
	init_query_code();
	init_string_table();
	init_label_table();
	init_put();
	init_get();
	}

unsigned pc_of_size = 0;
unsigned start_pc = 0;

void
yyparse()
	{
	yylex();
	}

/* once an instruction has been put, 
   pc is the offset into the current put of the next instruction */
/* pc is incremented automatically by put_instruction */
/* current_put->position is incremented by every put and is the address of
   the next write 
*/

%}

%%

[ \t\n\r\f]+	{}

"%"		{ 
		/* comment */
#ifdef EBUG
		fprintf(stderr, "comment (matched)");
#endif /* EBUG */
		getln();
		}

"/*"	{
	/* comment */
	char c1,c2;
	int closed = 0;

	/* skip until close comment delimiter */
	closed = ((c1 = input()) == EOF);
	while(!closed && ((c2 = input()) != EOF))
		if(!(closed = (c1 == '*' && c2 == '/')))
			c1 = c2;
	}

"'"	{
	    /* new procedure */
	    char	f[MAX_STRING_LENGTH];
	    int	arity;

	    unput('\''); /* put quote back */

	    /* get f, arity */
	    getln();
	    string_arg(f);
	    int_arg(&arity);

	    if(!strcmp("$query", f) && (arity == 0))
		{
		/* query code */
#ifdef EBUG
		fprintf(stderr, "$query/0 (matched)");
#endif /* EBUG */
		/* setup for write to query code area */
		current_put = query_code;
		lookup_string_table("$query");
		pc = (unsigned) (current_put->position - current_put->base);
		}
	    else	
		{
#ifdef EBUG
		fprintf(stderr, "new proc (matched)");
#endif /* EBUG */
		/* setup for write to code area */
		current_put = procedures;

		/* add to string table */
		/* put offset */
		put_offset(lookup_string_table(f));
		/* put number (arity) */
		put_number(arity);
		/* put address in pc_of_size for patching at end */
		pc_of_size = (unsigned)
			      (current_put->position - current_put->base);
		put_constant(0); /* to place hold for size */

		/* initialize pc for this procedure */
		pc = (unsigned)(current_put->position - current_put->base);
		start_pc = pc;
		}
	}

"put_constant" {
	char value[MAX_STRING_LENGTH];
	int reg_i, i;
	int read_atom;

	getln(); read_atom = some_arg(value, &i); int_arg(&reg_i);

	put_instruction(PUT_CONSTANT);
	if(read_atom > 0)
		put_constant_atom(lookup_string_table(value));
	else
		put_constant_integer(i);
	put_register(reg_i);
	}

"put_nil" {
	int reg;
	getln(); int_arg(&reg); 

	put_instruction(PUT_NIL);
	put_register(reg);
	}

"put_cons" {
	int reg;
	getln(); int_arg(&reg); 

	put_instruction(PUT_CONS);
	put_register(reg);
	}

"put_apply" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_APPLY);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"put_pair" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"put_quantifier" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_QUANTIFIER);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"put_x_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_y_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_x_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_x_object_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_y_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_y_object_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_unsafe_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_UNSAFE_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_x_object_variable" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_X_OBJECT_VARIABLE);
	put_register(reg_i);
	}

"put_y_object_variable" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_Y_OBJECT_VARIABLE);
	put_register(reg_i);
	}

"put_substitution_operator" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( PUT_SUBSTITUTION_OPERATOR);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_empty_substitution" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_EMPTY_SUBSTITUTION);
	put_register(reg_i);
	}

"put_substitution" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_SUBSTITUTION);
	put_register(reg_i);
	put_register(reg_j);
	}

"put_parallel_substitution" {
	int num_n; int reg_i;
	getln(); int_arg(&num_n); int_arg(&reg_i); 

	put_instruction(PUT_PARALLEL_SUBSTITUTION);
	put_number(num_n);
	put_register(reg_i);
	}

"put_parallel_substitution_pair" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( PUT_PARALLEL_SUBSTITUTION_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	}

"set_object_property" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(SET_OBJECT_PROPERTY);
	put_register(reg_i);
	}

"determine_property" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(DETERMINE_PROPERTY);
	put_register(reg_i);
	}

"get_constant" {
	char value[MAX_STRING_LENGTH];
	int reg_i, i;
	int read_atom;

	getln(); read_atom = some_arg(value, &i); int_arg(&reg_i);
	put_instruction( GET_CONSTANT);
	if(read_atom > 0)
		put_constant_atom(lookup_string_table(value));
	else
		put_constant_integer(i);
	put_register(reg_i);
	}

"get_nil" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(GET_NIL);
	put_register(reg_i);
	}

"get_cons" {
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(GET_CONS);
	put_register(reg_i);
	}

"get_apply" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(GET_APPLY);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"get_pair" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction( GET_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"get_quantifier" {
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(GET_QUANTIFIER);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}

"get_x_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( GET_X_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_y_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_x_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_y_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_x_object_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_OBJECT_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_y_object_variable" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_OBJECT_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_x_object_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"get_y_object_value" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}

"call_predicate" {
	char predicate[MAX_STRING_LENGTH];
	int	arity, n;

	getln(); string_arg(predicate); int_arg(&arity); int_arg(&n); 

	put_instruction(CALL_PREDICATE);

	put_predatom(lookup_string_table(predicate));
	put_number(arity);
	put_number(n);
	}

"call_address" {
	int pred_addr, n;
	getln(); int_arg(&pred_addr); int_arg(&n); 

	put_instruction(CALL_ADDRESS);
	put_address(pred_addr);
	put_number(n);
	}

"execute_predicate" {
	char predicate[MAX_STRING_LENGTH];
	int	arity;

	getln(); string_arg(predicate); int_arg(&arity); 

	put_instruction(EXECUTE_PREDICATE);
	put_predatom(lookup_string_table(predicate));
	put_number(arity);
	}

"execute_address" {
	int pred_addr;
	getln(); int_arg(&pred_addr); 

	put_instruction(EXECUTE_ADDRESS);
	put_address(pred_addr);
	}

"proceed" {
	getln();
	put_instruction(PROCEED);
	}

"goto" {
	getln();
	put_instruction(GOTO);
	}

"escape" {
	char predicate[MAX_STRING_LENGTH];
	int arity;
	getln(); string_arg(predicate); int_arg(&arity); 

	put_instruction(ESCAPE);
	put_number(built_in_index(predicate, arity));
	}

"fail" {
	getln();
	put_instruction(FAIL);
	}

"cut" {
	getln();
	put_instruction(CUT);
	}

"do_delayed_problems" {
	getln();
	put_instruction(DO_DELAYED_PROBLEMS);
	}

"not_free_in" {
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(NOT_FREE_IN);
	put_register(reg_i);
	put_register(reg_j);
	}

"allocate" {
	int n;
	getln(); int_arg(&n); 

	put_instruction(ALLOCATE);
	put_number(n);
	}

"deallocate" {
	getln();
	put_instruction(DEALLOCATE);
	}

"try_me_else" {
	int n;
	char lab[MAX_STRING_LENGTH];
	getln(); int_arg(&n); label_arg(lab); 

	put_instruction(TRY_ME_ELSE);
	put_number(n);
	put_label_offset(lab, pc, pc - OFFSET_SIZE);
	}

"retry_me_else" {
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(RETRY_ME_ELSE);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}

"trust_me_else_fail" {
	getln();
	put_instruction(TRUST_ME_ELSE_FAIL);
	}

"try" {
	int n;
	char lab[MAX_STRING_LENGTH];
	getln(); int_arg(&n); label_arg(lab); 

	put_instruction(TRY);
	put_number(n);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}

"retry" {
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(RETRY);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}

"trust" {
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(TRUST);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}

"switch_on_term" {
	char	s[MAX_STRING_LENGTH];
	/*
	char *variable_label, 
	     *constant_label, 
	     *apply_label, 
	     *pair_label, 
	     *quantifier_label, 
	     *object_variable_label;
	*/
	put_instruction(SWITCH_ON_TERM);
	getln();
	label_arg(s);
	put_label_offset(s, pc, pc -(6*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(5*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(4*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(3*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(2*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(OFFSET_SIZE));
	}

"switch_on_constant" {
	int entry_size = SWITCH_ON_CONSTANT_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_CONSTANT);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_constant_hash_table(size);
	}

"switch_on_structure" {
	int entry_size = SWITCH_ON_STRUCTURE_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_STRUCTURE);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_structure_hash_table(size);
	}

"switch_on_quantifier" {
	int entry_size = SWITCH_ON_QUANTIFIER_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_QUANTIFIER);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_quantifier_hash_table(size);
	}

"commit" {
	getln();
	put_instruction(COMMIT);
	}

"back_to" {
	getln();
	put_instruction(BACK_TO);
	}

"commit_stage" {
	getln();
	put_instruction(COMMIT_STAGE);
	}

"end("[^\n]* 	{
		    /* end of procedure */
		    /*  there is no danger of losing the position due to
			code area reallocation since we are just overwriting
			previously written space 
		    */
			if(current_put == procedures)
			    {
			    char	*currenttmp;

			    /* write size of last procedure */
			    currenttmp = current_put->position;
			    current_put->position = current_put->base 
						    + 
						    pc_of_size;
			    put_constant((int)pc - (int)start_pc);
			    current_put->position = currenttmp;
			    }
			reset_label_table();
		}

[$a-zA-Z_0-9]*[ ]*: 	{
			/* label */
			char	lab[MAX_STRING_LENGTH];
			/* get label (lab) (char *) */
			sscanf(yytext, " %[^: ]", lab);
			resolve_label(lab, pc);
			}

.			{
			/* unrecognised input */
			unput(yytext[0]);
			getln();
			warning("Syntax Error ... \"%s\"\n", in_string);
			}
