# include "stdio.h"
# define U(x) x
# define NLSTATE yyprevious=YYNEWLINE
# define BEGIN yybgin = yysvec + 1 +
# define INITIAL 0
# define YYLERR yysvec
# define YYSTATE (yyestate-yysvec-1)
# define YYOPTIM 1
# define YYLMAX BUFSIZ
# define output(c) putc(c,yyout)
# define input() (((yytchar=yysptr>yysbuf?U(*--yysptr):getc(yyin))==10?(yylineno++,yytchar):yytchar)==EOF?0:yytchar)
# define unput(c) {yytchar= (c);if(yytchar=='\n')yylineno--;*yysptr++=yytchar;}
# define yymore() (yymorfg=1)
# define ECHO fprintf(yyout, "%s",yytext)
# define REJECT { nstr = yyreject(); goto yyfussy;}
int yyleng; extern char yytext[];
int yymorfg;
extern char *yysptr, yysbuf[];
int yytchar;
FILE *yyin = {stdin}, *yyout = {stdout};
extern int yylineno;
struct yysvf { 
	struct yywork *yystoff;
	struct yysvf *yyother;
	int *yystops;};
struct yysvf *yyestate;
extern struct yysvf yysvec[], *yybgin;
/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include <ctype.h>
#include "labels.h"
#include "put_code.h"
#include "procedures.h"
#include "hash_table.h"
#include "query_code.h"
#include "string_table.h"
#include "opcodes.h"
#include "args.h"
#include "built_in.h"

#define	SWITCH_ON_CONSTANT_ENTRY_SIZE (CONSTANT_SIZE + OFFSET_SIZE)
#define	SWITCH_ON_STRUCTURE_ENTRY_SIZE (CONSTANT_SIZE + NUMBER_SIZE + OFFSET_SIZE)
#define	SWITCH_ON_QUANTIFIER_ENTRY_SIZE (CONSTANT_SIZE + NUMBER_SIZE + OFFSET_SIZE)


void getln()
        {
        int i=0;
        while( ((linebuf[i] = input()) != EOF) && (linebuf[i] != '\n') )
		if((++i + 1) >= linebuf_dim) expand_linebuf();
        in_string = linebuf;
	linebuf[++i] = (char)0;
	}

int is_num(char *s)
	{
	/* if pointer is NULL or s has zero length return false */
	if(!s || !*s) return 0;

	/* if s has length > 1 */
	if(*(s+1))	return(isdigit(*s) && is_num(++s));
	/* else s is of length 1 */
	else		return(isdigit(*s));
	}

/* main lex procedures ********************************************/
void
yyinit()
	{
	init_procedures();
	init_query_code();
	init_string_table();
	init_label_table();
	init_put();
	init_get();
	}

unsigned pc_of_size = 0;
unsigned start_pc = 0;

void
yyparse()
	{
	yylex();
	}

/* once an instruction has been put, 
   pc is the offset into the current put of the next instruction */
/* pc is incremented automatically by put_instruction */
/* current_put->position is incremented by every put and is the address of
   the next write 
*/

# define YYNEWLINE 10
yylex(){
int nstr; extern int yyprevious;
while((nstr = yylook()) >= 0)
yyfussy: switch(nstr){
case 0:
if(yywrap()) return(0); break;
case 1:
{}
break;
case 2:
	{ 
		/* comment */
#ifdef EBUG
		fprintf(stderr, "comment (matched)");
#endif /* EBUG */
		getln();
		}
break;
case 3:
{
	/* comment */
	char c1,c2;
	int closed = 0;

	/* skip until close comment delimiter */
	closed = ((c1 = input()) == EOF);
	while(!closed && ((c2 = input()) != EOF))
		if(!(closed = (c1 == '*' && c2 == '/')))
			c1 = c2;
	}
break;
case 4:
{
	    /* new procedure */
	    char	f[MAX_STRING_LENGTH];
	    int	arity;

	    unput('\''); /* put quote back */

	    /* get f, arity */
	    getln();
	    string_arg(f);
	    int_arg(&arity);

	    if(!strcmp("$query", f) && (arity == 0))
		{
		/* query code */
#ifdef EBUG
		fprintf(stderr, "$query/0 (matched)");
#endif /* EBUG */
		/* setup for write to query code area */
		current_put = query_code;
		lookup_string_table("$query");
		pc = (unsigned) (current_put->position - current_put->base);
		}
	    else	
		{
#ifdef EBUG
		fprintf(stderr, "new proc (matched)");
#endif /* EBUG */
		/* setup for write to code area */
		current_put = procedures;

		/* add to string table */
		/* put offset */
		put_offset(lookup_string_table(f));
		/* put number (arity) */
		put_number(arity);
		/* put address in pc_of_size for patching at end */
		pc_of_size = (unsigned)
			      (current_put->position - current_put->base);
		put_constant(0); /* to place hold for size */

		/* initialize pc for this procedure */
		pc = (unsigned)(current_put->position - current_put->base);
		start_pc = pc;
		}
	}
break;
case 5:
{
	char value[MAX_STRING_LENGTH];
	int reg_i, i;
	int read_atom;

	getln(); read_atom = some_arg(value, &i); int_arg(&reg_i);

	put_instruction(PUT_CONSTANT);
	if(read_atom > 0)
		put_constant_atom(lookup_string_table(value));
	else
		put_constant_integer(i);
	put_register(reg_i);
	}
break;
case 6:
{
	int reg;
	getln(); int_arg(&reg); 

	put_instruction(PUT_NIL);
	put_register(reg);
	}
break;
case 7:
{
	int reg;
	getln(); int_arg(&reg); 

	put_instruction(PUT_CONS);
	put_register(reg);
	}
break;
case 8:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_APPLY);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 9:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 10:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(PUT_QUANTIFIER);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 11:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 12:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 13:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 14:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_X_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 15:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 16:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_Y_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 17:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_UNSAFE_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 18:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_X_OBJECT_VARIABLE);
	put_register(reg_i);
	}
break;
case 19:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_Y_OBJECT_VARIABLE);
	put_register(reg_i);
	}
break;
case 20:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( PUT_SUBSTITUTION_OPERATOR);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 21:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(PUT_EMPTY_SUBSTITUTION);
	put_register(reg_i);
	}
break;
case 22:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(PUT_SUBSTITUTION);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 23:
{
	int num_n; int reg_i;
	getln(); int_arg(&num_n); int_arg(&reg_i); 

	put_instruction(PUT_PARALLEL_SUBSTITUTION);
	put_number(num_n);
	put_register(reg_i);
	}
break;
case 24:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( PUT_PARALLEL_SUBSTITUTION_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 25:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(SET_OBJECT_PROPERTY);
	put_register(reg_i);
	}
break;
case 26:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(DETERMINE_PROPERTY);
	put_register(reg_i);
	}
break;
case 27:
{
	char value[MAX_STRING_LENGTH];
	int reg_i, i;
	int read_atom;

	getln(); read_atom = some_arg(value, &i); int_arg(&reg_i);
	put_instruction( GET_CONSTANT);
	if(read_atom > 0)
		put_constant_atom(lookup_string_table(value));
	else
		put_constant_integer(i);
	put_register(reg_i);
	}
break;
case 28:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(GET_NIL);
	put_register(reg_i);
	}
break;
case 29:
{
	int reg_i;
	getln(); int_arg(&reg_i); 

	put_instruction(GET_CONS);
	put_register(reg_i);
	}
break;
case 30:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(GET_APPLY);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 31:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction( GET_PAIR);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 32:
{
	int reg_i, reg_j, reg_k;
	getln(); int_arg(&reg_i); int_arg(&reg_j); int_arg(&reg_k); 

	put_instruction(GET_QUANTIFIER);
	put_register(reg_i);
	put_register(reg_j);
	put_register(reg_k);
	}
break;
case 33:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction( GET_X_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 34:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 35:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 36:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 37:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_OBJECT_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 38:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_OBJECT_VARIABLE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 39:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_X_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 40:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(GET_Y_OBJECT_VALUE);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 41:
{
	char predicate[MAX_STRING_LENGTH];
	int	arity, n;

	getln(); string_arg(predicate); int_arg(&arity); int_arg(&n); 

	put_instruction(CALL_PREDICATE);

	put_predatom(lookup_string_table(predicate));
	put_number(arity);
	put_number(n);
	}
break;
case 42:
{
	int pred_addr, n;
	getln(); int_arg(&pred_addr); int_arg(&n); 

	put_instruction(CALL_ADDRESS);
	put_address(pred_addr);
	put_number(n);
	}
break;
case 43:
{
	char predicate[MAX_STRING_LENGTH];
	int	arity;

	getln(); string_arg(predicate); int_arg(&arity); 

	put_instruction(EXECUTE_PREDICATE);
	put_predatom(lookup_string_table(predicate));
	put_number(arity);
	}
break;
case 44:
{
	int pred_addr;
	getln(); int_arg(&pred_addr); 

	put_instruction(EXECUTE_ADDRESS);
	put_address(pred_addr);
	}
break;
case 45:
{
	getln();
	put_instruction(PROCEED);
	}
break;
case 46:
{
	getln();
	put_instruction(GOTO);
	}
break;
case 47:
{
	char predicate[MAX_STRING_LENGTH];
	int arity;
	getln(); string_arg(predicate); int_arg(&arity); 

	put_instruction(ESCAPE);
	put_number(built_in_index(predicate, arity));
	}
break;
case 48:
{
	getln();
	put_instruction(FAIL);
	}
break;
case 49:
{
	getln();
	put_instruction(CUT);
	}
break;
case 50:
{
	getln();
	put_instruction(DO_DELAYED_PROBLEMS);
	}
break;
case 51:
{
	int reg_i, reg_j;
	getln(); int_arg(&reg_i); int_arg(&reg_j); 

	put_instruction(NOT_FREE_IN);
	put_register(reg_i);
	put_register(reg_j);
	}
break;
case 52:
{
	int n;
	getln(); int_arg(&n); 

	put_instruction(ALLOCATE);
	put_number(n);
	}
break;
case 53:
{
	getln();
	put_instruction(DEALLOCATE);
	}
break;
case 54:
{
	int n;
	char lab[MAX_STRING_LENGTH];
	getln(); int_arg(&n); label_arg(lab); 

	put_instruction(TRY_ME_ELSE);
	put_number(n);
	put_label_offset(lab, pc, pc - OFFSET_SIZE);
	}
break;
case 55:
{
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(RETRY_ME_ELSE);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}
break;
case 56:
{
	getln();
	put_instruction(TRUST_ME_ELSE_FAIL);
	}
break;
case 57:
{
	int n;
	char lab[MAX_STRING_LENGTH];
	getln(); int_arg(&n); label_arg(lab); 

	put_instruction(TRY);
	put_number(n);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}
break;
case 58:
{
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(RETRY);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}
break;
case 59:
{
	char lab[MAX_STRING_LENGTH];
	getln(); label_arg(lab); 

	put_instruction(TRUST);
	put_label_offset(lab, pc, pc -OFFSET_SIZE);
	}
break;
case 60:
{
	char	s[MAX_STRING_LENGTH];
	/*
	char *variable_label, 
	     *constant_label, 
	     *apply_label, 
	     *pair_label, 
	     *quantifier_label, 
	     *object_variable_label;
	*/
	put_instruction(SWITCH_ON_TERM);
	getln();
	label_arg(s);
	put_label_offset(s, pc, pc -(6*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(5*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(4*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(3*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(2*OFFSET_SIZE));
	label_arg(s);
	put_label_offset(s, pc, pc -(OFFSET_SIZE));
	}
break;
case 61:
{
	int entry_size = SWITCH_ON_CONSTANT_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_CONSTANT);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_constant_hash_table(size);
	}
break;
case 62:
{
	int entry_size = SWITCH_ON_STRUCTURE_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_STRUCTURE);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_structure_hash_table(size);
	}
break;
case 63:
{
	int entry_size = SWITCH_ON_QUANTIFIER_ENTRY_SIZE;
	int n;
	int size;

	getln(); int_arg(&n); 
	put_instruction(SWITCH_ON_QUANTIFIER);
	put_number(n);
	size = (int)(1 << n)*entry_size;

	make_and_put_quantifier_hash_table(size);
	}
break;
case 64:
{
	getln();
	put_instruction(COMMIT);
	}
break;
case 65:
{
	getln();
	put_instruction(BACK_TO);
	}
break;
case 66:
{
	getln();
	put_instruction(COMMIT_STAGE);
	}
break;
case 67:
	{
		    /* end of procedure */
		    /*  there is no danger of losing the position due to
			code area reallocation since we are just overwriting
			previously written space 
		    */
			if(current_put == procedures)
			    {
			    char	*currenttmp;

			    /* write size of last procedure */
			    currenttmp = current_put->position;
			    current_put->position = current_put->base 
						    + 
						    pc_of_size;
			    put_constant((int)pc - (int)start_pc);
			    current_put->position = currenttmp;
			    }
			reset_label_table();
		}
break;
case 68:
	{
			/* label */
			char	lab[MAX_STRING_LENGTH];
			/* get label (lab) (char *) */
			sscanf(yytext, " %[^: ]", lab);
			resolve_label(lab, pc);
			}
break;
case 69:
		{
			/* unrecognised input */
			unput(yytext[0]);
			getln();
			warning("Syntax Error ... \"%s\"\n", in_string);
			}
break;
case -1:
break;
default:
fprintf(yyout,"bad switch yylook %d",nstr);
} return(0); }
/* end of yylex */
int yyvstop[] = {
0,

69,
0,

1,
69,
0,

1,
0,

1,
69,
0,

69,
0,

2,
69,
0,

4,
69,
0,

69,
0,

68,
69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

69,
0,

1,
0,

68,
0,

3,
0,

49,
0,

57,
0,

67,
0,

48,
0,

46,
0,

58,
0,

59,
0,

64,
0,

47,
0,

65,
0,

28,
0,

45,
0,

6,
0,

52,
0,

29,
0,

31,
0,

7,
0,

9,
0,

30,
0,

8,
0,

53,
0,

35,
0,

36,
0,

51,
0,

13,
0,

15,
0,

54,
0,

42,
0,

66,
0,

27,
0,

5,
0,

55,
0,

41,
0,

32,
0,

33,
0,

34,
0,

10,
0,

11,
0,

12,
0,

60,
0,

44,
0,

22,
0,

17,
0,

43,
0,

26,
0,

39,
0,

40,
0,

14,
0,

16,
0,

61,
0,

56,
0,

50,
0,

25,
0,

62,
0,

63,
0,

37,
0,

38,
0,

18,
0,

19,
0,

21,
0,

23,
0,

20,
0,

24,
0,
0};
# define YYTYPE int
struct yywork { YYTYPE verify, advance; } yycrank[] = {
0,0,	0,0,	1,3,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,4,	1,5,	
4,5,	4,5,	78,78,	4,5,	
4,5,	0,0,	0,0,	0,0,	
0,0,	0,0,	78,78,	78,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	1,6,	0,0,	4,5,	
6,24,	1,7,	1,8,	24,24,	
1,9,	26,26,	0,0,	10,28,	
0,0,	78,78,	0,0,	0,0,	
1,10,	78,78,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	2,8,	1,11,	
2,9,	0,0,	6,25,	0,0,	
0,0,	24,25,	0,0,	26,25,	
2,10,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	2,11,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	1,12,	1,13,	
1,14,	1,15,	1,16,	1,17,	
1,18,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	1,19,	
20,27,	1,20,	0,0,	1,21,	
1,22,	1,23,	2,12,	2,13,	
2,14,	2,15,	2,16,	2,17,	
2,18,	0,0,	20,27,	0,0,	
0,0,	20,43,	0,0,	2,19,	
20,44,	2,20,	0,0,	2,21,	
2,22,	2,23,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,26,	7,0,	7,0,	
7,0,	7,27,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	0,0,	0,0,	0,0,	
15,27,	0,0,	0,0,	16,27,	
15,34,	0,0,	0,0,	7,25,	
7,0,	7,0,	7,0,	7,0,	
7,0,	7,0,	15,35,	18,27,	
16,36,	16,27,	0,0,	18,40,	
15,27,	16,37,	0,0,	16,27,	
22,27,	0,0,	16,38,	0,0,	
22,46,	18,41,	0,0,	0,0,	
0,0,	34,54,	48,27,	18,27,	
94,127,	0,0,	22,27,	0,0,	
7,0,	7,0,	7,0,	7,0,	
22,27,	7,0,	22,47,	34,27,	
48,27,	140,27,	94,27,	94,128,	
34,55,	34,27,	48,69,	0,0,	
94,27,	0,0,	48,70,	0,0,	
0,0,	0,0,	0,0,	140,173,	
0,0,	0,0,	0,0,	0,0,	
0,0,	140,27,	140,174,	0,0,	
7,0,	7,0,	7,0,	7,0,	
7,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
0,0,	12,0,	12,0,	12,0,	
141,27,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
0,0,	0,0,	141,175,	0,0,	
82,101,	0,0,	82,102,	0,0,	
141,27,	141,176,	12,25,	12,0,	
12,0,	12,0,	12,0,	12,0,	
12,0,	82,103,	82,27,	82,104,	
82,105,	204,237,	0,0,	0,0,	
82,27,	0,0,	0,0,	82,106,	
82,107,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	204,27,	
204,238,	0,0,	86,110,	0,0,	
86,111,	204,27,	86,112,	12,0,	
12,0,	12,0,	12,0,	0,0,	
12,0,	148,27,	152,27,	86,113,	
86,27,	86,114,	86,115,	0,0,	
86,116,	148,183,	86,117,	0,0,	
12,29,	86,118,	86,119,	148,27,	
152,188,	0,0,	148,184,	0,0,	
0,0,	148,27,	152,27,	152,189,	
0,0,	0,0,	0,0,	12,0,	
12,0,	12,0,	12,0,	12,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	0,0,	
13,0,	13,0,	13,0,	153,27,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	0,0,	
0,0,	153,190,	0,0,	0,0,	
0,0,	210,27,	212,27,	153,27,	
153,191,	13,25,	13,0,	13,0,	
13,0,	13,0,	13,0,	13,0,	
210,243,	212,246,	223,27,	210,27,	
212,27,	0,0,	210,244,	212,247,	
0,0,	210,27,	212,27,	0,0,	
0,0,	223,257,	0,0,	0,0,	
223,27,	0,0,	0,0,	223,258,	
0,0,	0,0,	223,27,	0,0,	
225,27,	422,27,	13,0,	13,0,	
13,0,	13,0,	14,26,	13,0,	
13,30,	0,0,	14,27,	225,260,	
422,438,	0,0,	225,27,	422,27,	
0,0,	225,261,	422,439,	0,0,	
225,27,	422,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,25,	0,0,	13,0,	13,0,	
13,0,	13,0,	13,0,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	0,0,	0,0,	0,0,	
0,0,	14,27,	0,0,	14,31,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,27,	
14,27,	14,32,	14,27,	14,27,	
14,27,	14,27,	14,27,	14,33,	
14,27,	14,27,	14,27,	14,27,	
14,27,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
0,0,	17,0,	17,0,	17,0,	
0,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
0,0,	0,0,	0,0,	298,27,	
0,0,	298,331,	0,0,	0,0,	
0,0,	0,0,	17,25,	17,0,	
17,0,	17,0,	17,0,	17,0,	
17,0,	298,27,	423,27,	298,332,	
428,27,	298,333,	298,334,	298,27,	
0,0,	0,0,	0,0,	0,0,	
0,0,	423,440,	0,0,	428,446,	
423,27,	0,0,	428,27,	423,441,	
429,27,	428,447,	423,27,	0,0,	
428,27,	0,0,	0,0,	17,0,	
17,0,	17,0,	17,0,	429,448,	
17,0,	17,39,	429,27,	0,0,	
0,0,	429,449,	0,0,	0,0,	
429,27,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	17,0,	
17,0,	17,0,	17,0,	17,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	0,0,	
19,0,	19,0,	19,0,	0,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	19,25,	19,0,	19,0,	
19,0,	19,0,	19,0,	19,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,0,	19,0,	
19,0,	19,0,	0,0,	19,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,42,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	19,0,	19,0,	
19,0,	19,0,	19,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	0,0,	21,0,	
21,0,	21,0,	0,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
21,25,	21,0,	21,0,	21,0,	
21,0,	21,0,	21,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	21,0,	21,0,	21,0,	
21,0,	0,0,	21,0,	0,0,	
0,0,	0,0,	0,0,	21,45,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	21,0,	21,0,	21,0,	
21,0,	21,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	0,0,	23,0,	23,0,	
23,0,	0,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	23,25,	
23,0,	23,0,	23,0,	23,0,	
23,0,	23,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
23,0,	23,0,	23,0,	23,0,	
0,0,	23,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	23,48,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
23,0,	23,0,	23,0,	23,0,	
23,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
0,0,	27,0,	27,0,	27,0,	
0,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	27,25,	27,0,	
27,0,	27,0,	27,0,	27,0,	
27,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,0,	
27,0,	27,0,	27,0,	0,0,	
27,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	27,0,	
27,0,	27,0,	27,0,	27,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	0,0,	
29,0,	29,0,	29,0,	0,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	29,25,	29,0,	29,0,	
29,0,	29,0,	29,0,	29,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	29,0,	29,0,	
29,0,	29,0,	0,0,	29,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	29,49,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	29,0,	29,0,	
29,0,	29,0,	29,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	0,0,	30,0,	
30,0,	30,0,	0,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
30,25,	30,0,	30,0,	30,0,	
30,0,	30,0,	30,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	30,0,	30,0,	30,0,	
30,0,	0,0,	30,0,	0,0,	
0,0,	30,50,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	30,0,	30,0,	30,0,	
30,0,	30,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	0,0,	31,0,	31,0,	
31,0,	0,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	31,25,	
31,0,	31,0,	31,0,	31,0,	
31,0,	31,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
31,0,	31,0,	31,0,	31,0,	
0,0,	31,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	31,51,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
31,0,	31,0,	31,0,	31,0,	
31,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
0,0,	32,0,	32,0,	32,0,	
0,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	32,25,	32,0,	
32,0,	32,0,	32,0,	32,0,	
32,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,0,	
32,0,	32,0,	32,0,	0,0,	
32,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	32,52,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	32,0,	
32,0,	32,0,	32,0,	32,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	0,0,	
33,0,	33,0,	33,0,	0,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	33,25,	33,0,	33,0,	
33,0,	33,0,	33,0,	33,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	33,0,	33,0,	
33,0,	33,0,	0,0,	33,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	33,53,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	33,0,	33,0,	
33,0,	33,0,	33,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	0,0,	35,0,	
35,0,	35,0,	0,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
35,25,	35,0,	35,0,	35,0,	
35,0,	35,0,	35,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	35,0,	35,0,	35,0,	
35,0,	35,56,	35,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	35,0,	35,0,	35,0,	
35,0,	35,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	0,0,	36,0,	36,0,	
36,0,	0,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	36,25,	
36,0,	36,0,	36,0,	36,0,	
36,0,	36,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,0,	36,0,	36,0,	36,0,	
0,0,	36,0,	0,0,	0,0,	
0,0,	36,57,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
36,0,	36,0,	36,0,	36,0,	
36,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
0,0,	37,0,	37,0,	37,0,	
0,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	37,25,	37,0,	
37,0,	37,0,	37,0,	37,0,	
37,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	37,0,	
37,0,	37,0,	37,0,	0,0,	
37,0,	0,0,	0,0,	37,58,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	37,0,	
37,0,	37,0,	37,0,	37,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	0,0,	
38,0,	38,0,	38,0,	0,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	38,25,	38,0,	38,0,	
38,0,	38,0,	38,0,	38,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	38,0,	38,0,	
38,0,	38,0,	0,0,	38,0,	
0,0,	0,0,	0,0,	0,0,	
38,59,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	38,0,	38,0,	
38,0,	38,0,	38,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	0,0,	39,0,	
39,0,	39,0,	0,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
39,25,	39,0,	39,0,	39,0,	
39,0,	39,0,	39,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	39,0,	39,0,	39,0,	
39,0,	0,0,	39,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	39,60,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	39,0,	39,0,	39,0,	
39,0,	39,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	0,0,	40,0,	40,0,	
40,0,	0,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	40,25,	
40,0,	40,0,	40,0,	40,0,	
40,0,	40,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
40,0,	40,0,	40,0,	40,0,	
0,0,	40,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	40,61,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
40,0,	40,0,	40,0,	40,0,	
40,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
0,0,	41,0,	41,0,	41,0,	
0,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	41,25,	41,0,	
41,0,	41,0,	41,0,	41,0,	
41,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	41,0,	
41,0,	41,0,	41,0,	0,0,	
41,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
41,62,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	41,0,	
41,0,	41,0,	41,0,	41,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	0,0,	
42,0,	42,0,	42,0,	0,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	42,25,	42,0,	42,0,	
42,0,	42,0,	42,0,	42,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	42,0,	42,0,	
42,0,	42,0,	0,0,	42,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	42,63,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	42,0,	42,0,	
42,0,	42,0,	42,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	0,0,	43,0,	
43,0,	43,0,	0,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
43,25,	43,0,	43,0,	43,0,	
43,0,	43,0,	43,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	43,0,	43,0,	43,0,	
43,0,	0,0,	43,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	43,64,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	43,0,	43,0,	43,0,	
43,0,	43,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	0,0,	44,0,	44,0,	
44,0,	0,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	44,25,	
44,0,	44,0,	44,0,	44,0,	
44,0,	44,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
44,0,	44,0,	44,0,	44,0,	
0,0,	44,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	44,65,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
44,0,	44,0,	44,0,	44,0,	
44,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
0,0,	45,0,	45,0,	45,0,	
0,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	45,25,	45,0,	
45,0,	45,0,	45,0,	45,0,	
45,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,0,	
45,0,	45,0,	45,0,	0,0,	
45,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
45,66,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	45,0,	
45,0,	45,0,	45,0,	45,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	0,0,	
46,0,	46,0,	46,0,	0,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	46,25,	46,0,	46,0,	
46,0,	46,0,	46,0,	46,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	46,0,	46,0,	
46,0,	46,0,	0,0,	46,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	46,67,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	46,0,	46,0,	
46,0,	46,0,	46,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	0,0,	47,0,	
47,0,	47,0,	0,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
47,25,	47,0,	47,0,	47,0,	
47,0,	47,0,	47,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	47,0,	47,0,	47,0,	
47,0,	0,0,	47,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	47,68,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	47,0,	47,0,	47,0,	
47,0,	47,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	0,0,	49,0,	49,0,	
49,0,	0,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	49,25,	
49,0,	49,0,	49,0,	49,0,	
49,0,	49,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
49,0,	49,0,	49,0,	49,0,	
0,0,	49,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
49,71,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
49,0,	49,0,	49,0,	49,0,	
49,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
0,0,	50,0,	50,0,	50,0,	
0,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	50,25,	50,0,	
50,0,	50,0,	50,0,	50,0,	
50,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	50,0,	
50,0,	50,0,	50,0,	0,0,	
50,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	50,72,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	50,0,	
50,0,	50,0,	50,0,	50,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	0,0,	
51,0,	51,0,	51,0,	0,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	51,25,	51,0,	51,0,	
51,0,	51,0,	51,0,	51,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	51,0,	51,0,	
51,0,	51,0,	0,0,	51,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	51,73,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	51,0,	51,0,	
51,0,	51,0,	51,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	0,0,	52,0,	
52,0,	52,0,	0,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
52,25,	52,0,	52,0,	52,0,	
52,0,	52,0,	52,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	52,0,	52,0,	52,0,	
52,0,	0,0,	52,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	52,74,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	52,0,	52,0,	52,0,	
52,0,	52,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	0,0,	53,0,	53,0,	
53,0,	0,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	53,25,	
53,0,	53,0,	53,0,	53,0,	
53,0,	53,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
53,0,	53,0,	53,0,	53,0,	
0,0,	53,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
53,0,	53,0,	53,0,	53,0,	
53,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
0,0,	54,0,	54,0,	54,0,	
0,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	54,25,	54,0,	
54,0,	54,0,	54,0,	54,0,	
54,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	54,0,	
54,0,	54,0,	54,0,	0,0,	
54,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
54,75,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	54,0,	
54,0,	54,0,	54,0,	54,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	0,0,	
55,0,	55,0,	55,0,	0,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	55,25,	55,0,	55,0,	
55,0,	55,0,	55,0,	55,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,0,	55,0,	
55,0,	55,0,	0,0,	55,0,	
0,0,	0,0,	0,0,	0,0,	
55,76,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	55,0,	55,0,	
55,0,	55,0,	55,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	0,0,	56,0,	
56,0,	56,0,	0,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
56,25,	56,0,	56,0,	56,0,	
56,0,	56,0,	56,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	56,0,	56,0,	56,0,	
56,0,	0,0,	56,0,	0,0,	
0,0,	0,0,	56,77,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	56,0,	56,0,	56,0,	
56,0,	56,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	0,0,	57,0,	57,0,	
57,0,	0,0,	57,0,	57,0,	
57,0,	57,78,	57,0,	57,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	57,25,	
57,0,	57,0,	57,0,	57,0,	
57,0,	57,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,0,	57,0,	57,0,	57,0,	
0,0,	57,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
57,0,	57,0,	57,0,	57,0,	
57,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
0,0,	58,0,	58,0,	58,0,	
0,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	58,25,	58,0,	
58,0,	58,0,	58,0,	58,0,	
58,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	58,0,	
58,0,	58,0,	58,0,	0,0,	
58,0,	58,79,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	58,0,	
58,0,	58,0,	58,0,	58,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	0,0,	
59,0,	59,0,	59,0,	0,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	59,25,	59,0,	59,0,	
59,0,	59,0,	59,0,	59,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	59,0,	59,0,	
59,0,	59,0,	0,0,	59,0,	
0,0,	0,0,	59,80,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	59,0,	59,0,	
59,0,	59,0,	59,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	0,0,	60,0,	
60,0,	60,0,	0,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
60,25,	60,0,	60,0,	60,0,	
60,0,	60,0,	60,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	60,0,	60,0,	60,0,	
60,0,	0,0,	60,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	60,81,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	60,0,	60,0,	60,0,	
60,0,	60,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	0,0,	61,0,	61,0,	
61,0,	0,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	61,25,	
61,0,	61,0,	61,0,	61,0,	
61,0,	61,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
61,0,	61,0,	61,0,	61,0,	
61,82,	61,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
61,0,	61,0,	61,0,	61,0,	
61,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
0,0,	62,0,	62,0,	62,0,	
0,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	62,25,	62,0,	
62,0,	62,0,	62,0,	62,0,	
62,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	62,0,	
62,0,	62,0,	62,0,	0,0,	
62,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	62,83,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	62,0,	
62,0,	62,0,	62,0,	62,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	0,0,	
63,0,	63,0,	63,0,	0,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	63,25,	63,0,	63,0,	
63,0,	63,0,	63,0,	63,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	63,0,	63,0,	
63,0,	63,0,	63,84,	63,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	63,0,	63,0,	
63,0,	63,0,	63,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	0,0,	64,0,	
64,0,	64,0,	0,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
64,25,	64,0,	64,0,	64,0,	
64,0,	64,0,	64,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,0,	64,0,	64,0,	
64,0,	0,0,	64,0,	0,0,	
0,0,	64,85,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	64,0,	64,0,	64,0,	
64,0,	64,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	0,0,	65,0,	65,0,	
65,0,	0,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	65,25,	
65,0,	65,0,	65,0,	65,0,	
65,0,	65,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	65,0,	65,0,	65,0,	
65,86,	65,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
65,0,	65,0,	65,0,	65,0,	
65,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
0,0,	66,0,	66,0,	66,0,	
0,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	66,25,	66,0,	
66,0,	66,0,	66,0,	66,0,	
66,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	66,0,	
66,0,	66,0,	66,0,	0,0,	
66,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	66,87,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	66,0,	
66,0,	66,0,	66,0,	66,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	0,0,	
67,0,	67,0,	67,0,	0,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	67,25,	67,0,	67,0,	
67,0,	67,0,	67,0,	67,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	67,0,	67,0,	
67,0,	67,0,	67,88,	67,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	67,0,	67,0,	
67,0,	67,0,	67,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	0,0,	68,0,	
68,0,	68,0,	0,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
68,25,	68,0,	68,0,	68,0,	
68,0,	68,0,	68,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	68,0,	68,0,	68,0,	
68,0,	0,0,	68,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	68,89,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	68,0,	68,0,	68,0,	
68,0,	68,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	0,0,	69,0,	69,0,	
69,0,	0,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	69,25,	
69,0,	69,0,	69,0,	69,0,	
69,0,	69,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
69,0,	69,0,	69,0,	69,0,	
0,0,	69,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
69,90,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
69,0,	69,0,	69,0,	69,0,	
69,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
0,0,	70,0,	70,0,	70,0,	
0,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	70,25,	70,0,	
70,0,	70,0,	70,0,	70,0,	
70,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	70,0,	
70,0,	70,0,	70,0,	70,91,	
70,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	70,0,	
70,0,	70,0,	70,0,	70,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	0,0,	
71,0,	71,0,	71,0,	0,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	71,25,	71,0,	71,0,	
71,0,	71,0,	71,0,	71,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,0,	71,0,	
71,0,	71,0,	0,0,	71,0,	
0,0,	0,0,	71,92,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	71,0,	71,0,	
71,0,	71,0,	71,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	0,0,	72,0,	
72,0,	72,0,	0,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
72,25,	72,0,	72,0,	72,0,	
72,0,	72,0,	72,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	72,0,	72,0,	72,0,	
72,0,	72,93,	72,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	72,0,	72,0,	72,0,	
72,0,	72,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	0,0,	73,0,	73,0,	
73,0,	0,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	73,25,	
73,0,	73,0,	73,0,	73,0,	
73,0,	73,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
73,0,	73,0,	73,0,	73,0,	
73,94,	73,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
73,0,	73,0,	73,0,	73,0,	
73,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
0,0,	74,0,	74,0,	74,0,	
0,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	74,25,	74,0,	
74,0,	74,0,	74,0,	74,0,	
74,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	74,0,	
74,0,	74,0,	74,0,	0,0,	
74,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	74,95,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	74,0,	
74,0,	74,0,	74,0,	74,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	0,0,	
75,0,	75,0,	75,0,	0,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	75,25,	75,0,	75,0,	
75,0,	75,0,	75,0,	75,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	75,0,	75,0,	
75,0,	75,0,	0,0,	75,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	75,96,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	75,0,	75,0,	
75,0,	75,0,	75,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	0,0,	76,0,	
76,0,	76,0,	0,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
76,25,	76,0,	76,0,	76,0,	
76,0,	76,0,	76,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	76,0,	76,0,	76,0,	
76,0,	0,0,	76,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
76,97,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	76,0,	76,0,	76,0,	
76,0,	76,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	0,0,	77,0,	77,0,	
77,0,	0,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	77,25,	
77,0,	77,0,	77,0,	77,0,	
77,0,	77,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
77,0,	77,0,	77,0,	77,0,	
0,0,	77,0,	0,0,	0,0,	
0,0,	0,0,	77,98,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
77,0,	77,0,	77,0,	77,0,	
77,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
0,0,	79,0,	79,0,	79,0,	
0,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	79,25,	79,0,	
79,0,	79,0,	79,0,	79,0,	
79,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	79,0,	
79,0,	79,0,	79,0,	0,0,	
79,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
79,99,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	79,0,	
79,0,	79,0,	79,0,	79,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	0,0,	
80,0,	80,0,	80,0,	0,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	80,25,	80,0,	80,0,	
80,0,	80,0,	80,0,	80,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	80,0,	80,0,	
80,0,	80,0,	0,0,	80,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
80,100,	0,0,	0,0,	0,0,	
0,0,	0,0,	80,0,	80,0,	
80,0,	80,0,	80,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	0,0,	81,0,	
81,0,	81,0,	0,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
81,25,	81,0,	81,0,	81,0,	
81,0,	81,0,	81,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	81,0,	81,0,	81,0,	
81,0,	0,0,	81,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	81,0,	81,0,	81,0,	
81,0,	81,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	0,0,	83,0,	83,0,	
83,0,	0,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	83,25,	
83,0,	83,0,	83,0,	83,0,	
83,0,	83,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
83,0,	83,0,	83,0,	83,0,	
0,0,	83,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
83,0,	83,0,	83,0,	83,0,	
83,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
0,0,	84,0,	84,0,	84,0,	
0,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	84,25,	84,0,	
84,0,	84,0,	84,0,	84,0,	
84,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	84,0,	
84,0,	84,0,	84,0,	0,0,	
84,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	84,108,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	84,0,	
84,0,	84,0,	84,0,	84,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	0,0,	
85,0,	85,0,	85,0,	0,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	85,25,	85,0,	85,0,	
85,0,	85,0,	85,0,	85,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	85,0,	85,0,	
85,0,	85,0,	0,0,	85,0,	
0,0,	0,0,	0,0,	0,0,	
85,109,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	85,0,	85,0,	
85,0,	85,0,	85,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	0,0,	87,0,	
87,0,	87,0,	0,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
87,25,	87,0,	87,0,	87,0,	
87,0,	87,0,	87,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	87,0,	87,0,	87,0,	
87,0,	0,0,	87,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	87,120,	
0,0,	87,0,	87,0,	87,0,	
87,0,	87,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	0,0,	88,0,	88,0,	
88,0,	0,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	88,25,	
88,0,	88,0,	88,0,	88,0,	
88,0,	88,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
88,0,	88,0,	88,0,	88,0,	
0,0,	88,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
88,121,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
88,0,	88,0,	88,0,	88,0,	
88,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
0,0,	89,0,	89,0,	89,0,	
0,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	89,25,	89,0,	
89,0,	89,0,	89,0,	89,0,	
89,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	89,0,	
89,0,	89,0,	89,0,	0,0,	
89,0,	0,0,	0,0,	89,122,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	89,0,	
89,0,	89,0,	89,0,	89,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	0,0,	
90,0,	90,0,	90,0,	0,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	90,25,	90,0,	90,0,	
90,0,	90,0,	90,0,	90,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	90,0,	90,0,	
90,0,	90,0,	0,0,	90,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	90,123,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	90,0,	90,0,	
90,0,	90,0,	90,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	0,0,	91,0,	
91,0,	91,0,	0,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
91,25,	91,0,	91,0,	91,0,	
91,0,	91,0,	91,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	91,0,	91,0,	91,0,	
91,0,	0,0,	91,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	91,124,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	91,0,	91,0,	91,0,	
91,0,	91,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	0,0,	92,0,	92,0,	
92,0,	0,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	92,25,	
92,0,	92,0,	92,0,	92,0,	
92,0,	92,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
92,0,	92,0,	92,0,	92,0,	
0,0,	92,0,	92,125,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
92,0,	92,0,	92,0,	92,0,	
92,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
0,0,	93,0,	93,0,	93,0,	
0,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	93,25,	93,0,	
93,0,	93,0,	93,0,	93,0,	
93,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	93,0,	
93,0,	93,0,	93,0,	0,0,	
93,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
93,126,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	93,0,	
93,0,	93,0,	93,0,	93,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	0,0,	
95,0,	95,0,	95,0,	0,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	95,25,	95,0,	95,0,	
95,0,	95,0,	95,0,	95,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	95,0,	95,0,	
95,0,	95,0,	0,0,	95,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	95,129,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	95,0,	95,0,	
95,0,	95,0,	95,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	0,0,	96,0,	
96,0,	96,0,	0,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
96,25,	96,0,	96,0,	96,0,	
96,0,	96,0,	96,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	96,0,	96,0,	96,0,	
96,0,	0,0,	96,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	96,130,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	96,0,	96,0,	96,0,	
96,0,	96,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	0,0,	97,0,	97,0,	
97,0,	0,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	97,25,	
97,0,	97,0,	97,0,	97,0,	
97,0,	97,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
97,0,	97,0,	97,0,	97,0,	
0,0,	97,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	97,131,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
97,0,	97,0,	97,0,	97,0,	
97,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
0,0,	98,0,	98,0,	98,0,	
0,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	98,25,	98,0,	
98,0,	98,0,	98,0,	98,0,	
98,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	98,0,	
98,0,	98,0,	98,0,	0,0,	
98,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
98,132,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	98,0,	
98,0,	98,0,	98,0,	98,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	0,0,	
99,0,	99,0,	99,0,	0,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	99,25,	99,0,	99,0,	
99,0,	99,0,	99,0,	99,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	99,0,	99,0,	
99,0,	99,0,	0,0,	99,0,	
0,0,	0,0,	0,0,	0,0,	
99,133,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	99,0,	99,0,	
99,0,	99,0,	99,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	0,0,	100,0,	
100,0,	100,0,	0,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
100,25,	100,0,	100,0,	100,0,	
100,0,	100,0,	100,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	100,0,	100,0,	100,0,	
100,0,	0,0,	100,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	100,134,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	100,0,	100,0,	100,0,	
100,0,	100,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	0,0,	101,0,	101,0,	
101,0,	0,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	101,25,	
101,0,	101,0,	101,0,	101,0,	
101,0,	101,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
101,0,	101,0,	101,0,	101,0,	
0,0,	101,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	101,135,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
101,0,	101,0,	101,0,	101,0,	
101,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
0,0,	102,0,	102,0,	102,0,	
0,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	102,25,	102,0,	
102,0,	102,0,	102,0,	102,0,	
102,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	102,0,	
102,0,	102,0,	102,0,	0,0,	
102,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	102,136,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	102,0,	
102,0,	102,0,	102,0,	102,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	0,0,	
103,0,	103,0,	103,0,	0,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	103,25,	103,0,	103,0,	
103,0,	103,0,	103,0,	103,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	103,0,	103,0,	
103,0,	103,0,	0,0,	103,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
103,137,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	103,0,	103,0,	
103,0,	103,0,	103,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	0,0,	104,0,	
104,0,	104,0,	0,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
104,25,	104,0,	104,0,	104,0,	
104,0,	104,0,	104,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	104,0,	104,0,	104,0,	
104,0,	0,0,	104,0,	104,138,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	104,0,	104,0,	104,0,	
104,0,	104,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	0,0,	105,0,	105,0,	
105,0,	0,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	105,25,	
105,0,	105,0,	105,0,	105,0,	
105,0,	105,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
105,0,	105,0,	105,0,	105,0,	
0,0,	105,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	105,139,	0,0,	
0,0,	0,0,	0,0,	0,0,	
105,0,	105,0,	105,0,	105,0,	
105,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
0,0,	106,0,	106,0,	106,0,	
0,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	106,25,	106,0,	
106,0,	106,0,	106,0,	106,0,	
106,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	106,0,	
106,0,	106,0,	106,0,	106,140,	
106,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	106,0,	
106,0,	106,0,	106,0,	106,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	0,0,	
107,0,	107,0,	107,0,	0,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	107,25,	107,0,	107,0,	
107,0,	107,0,	107,0,	107,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	107,0,	107,0,	
107,0,	107,0,	107,141,	107,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	107,0,	107,0,	
107,0,	107,0,	107,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	0,0,	108,0,	
108,0,	108,0,	0,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
108,25,	108,0,	108,0,	108,0,	
108,0,	108,0,	108,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	108,0,	108,0,	108,0,	
108,0,	0,0,	108,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
108,142,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	108,0,	108,0,	108,0,	
108,0,	108,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	0,0,	109,0,	109,0,	
109,0,	0,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	109,25,	
109,0,	109,0,	109,0,	109,0,	
109,0,	109,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
109,0,	109,0,	109,0,	109,0,	
0,0,	109,0,	0,0,	0,0,	
0,0,	0,0,	109,143,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
109,0,	109,0,	109,0,	109,0,	
109,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
0,0,	110,0,	110,0,	110,0,	
0,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	110,25,	110,0,	
110,0,	110,0,	110,0,	110,0,	
110,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	110,0,	
110,0,	110,0,	110,0,	0,0,	
110,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
110,144,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	110,0,	
110,0,	110,0,	110,0,	110,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	0,0,	
111,0,	111,0,	111,0,	0,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	111,25,	111,0,	111,0,	
111,0,	111,0,	111,0,	111,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	111,0,	111,0,	
111,0,	111,0,	0,0,	111,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	111,145,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	111,0,	111,0,	
111,0,	111,0,	111,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	0,0,	112,0,	
112,0,	112,0,	0,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
112,25,	112,0,	112,0,	112,0,	
112,0,	112,0,	112,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	112,0,	112,0,	112,0,	
112,0,	0,0,	112,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	112,146,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	112,0,	112,0,	112,0,	
112,0,	112,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	0,0,	113,0,	113,0,	
113,0,	0,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	113,25,	
113,0,	113,0,	113,0,	113,0,	
113,0,	113,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
113,0,	113,0,	113,0,	113,0,	
0,0,	113,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	113,147,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
113,0,	113,0,	113,0,	113,0,	
113,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
0,0,	114,0,	114,0,	114,0,	
0,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	114,25,	114,0,	
114,0,	114,0,	114,0,	114,0,	
114,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	114,0,	
114,0,	114,0,	114,0,	0,0,	
114,0,	114,148,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	114,0,	
114,0,	114,0,	114,0,	114,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	0,0,	
115,0,	115,0,	115,0,	0,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	115,25,	115,0,	115,0,	
115,0,	115,0,	115,0,	115,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	115,0,	115,0,	
115,0,	115,0,	0,0,	115,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
115,149,	0,0,	0,0,	0,0,	
0,0,	0,0,	115,0,	115,0,	
115,0,	115,0,	115,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	0,0,	116,0,	
116,0,	116,0,	0,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
116,25,	116,0,	116,0,	116,0,	
116,0,	116,0,	116,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	116,0,	116,0,	116,0,	
116,0,	0,0,	116,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	116,150,	
0,0,	0,0,	0,0,	0,0,	
0,0,	116,0,	116,0,	116,0,	
116,0,	116,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	0,0,	117,0,	117,0,	
117,0,	0,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	117,25,	
117,0,	117,0,	117,0,	117,0,	
117,0,	117,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
117,0,	117,0,	117,0,	117,0,	
0,0,	117,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	117,151,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
117,0,	117,0,	117,0,	117,0,	
117,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
0,0,	118,0,	118,0,	118,0,	
0,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	118,25,	118,0,	
118,0,	118,0,	118,0,	118,0,	
118,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	118,0,	
118,0,	118,0,	118,0,	118,152,	
118,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	118,0,	
118,0,	118,0,	118,0,	118,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	0,0,	
119,0,	119,0,	119,0,	0,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	119,25,	119,0,	119,0,	
119,0,	119,0,	119,0,	119,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	119,0,	119,0,	
119,0,	119,0,	119,153,	119,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	119,0,	119,0,	
119,0,	119,0,	119,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	0,0,	120,0,	
120,0,	120,0,	0,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
120,25,	120,0,	120,0,	120,0,	
120,0,	120,0,	120,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	120,0,	120,0,	120,0,	
120,0,	120,154,	120,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	120,0,	120,0,	120,0,	
120,0,	120,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	0,0,	121,0,	121,0,	
121,0,	0,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	121,25,	
121,0,	121,0,	121,0,	121,0,	
121,0,	121,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
121,0,	121,0,	121,0,	121,0,	
0,0,	121,0,	0,0,	121,155,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
121,0,	121,0,	121,0,	121,0,	
121,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
0,0,	122,0,	122,0,	122,0,	
0,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	122,25,	122,0,	
122,0,	122,0,	122,0,	122,0,	
122,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	122,0,	
122,0,	122,0,	122,0,	0,0,	
122,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
122,156,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	122,0,	
122,0,	122,0,	122,0,	122,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	0,0,	
123,0,	123,0,	123,0,	0,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	123,25,	123,0,	123,0,	
123,0,	123,0,	123,0,	123,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	123,0,	123,0,	
123,0,	123,0,	123,157,	123,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	123,0,	123,0,	
123,0,	123,0,	123,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	0,0,	124,0,	
124,0,	124,0,	0,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
124,25,	124,0,	124,0,	124,0,	
124,0,	124,0,	124,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	124,0,	124,0,	124,0,	
124,0,	0,0,	124,0,	0,0,	
0,0,	0,0,	0,0,	124,158,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	124,0,	124,0,	124,0,	
124,0,	124,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	0,0,	125,0,	125,0,	
125,0,	0,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	125,25,	
125,0,	125,0,	125,0,	125,0,	
125,0,	125,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
125,0,	125,0,	125,0,	125,0,	
0,0,	125,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	125,159,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
125,0,	125,0,	125,0,	125,0,	
125,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
0,0,	126,0,	126,0,	126,0,	
0,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	126,25,	126,0,	
126,0,	126,0,	126,0,	126,0,	
126,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	126,0,	
126,0,	126,0,	126,0,	0,0,	
126,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	126,160,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	126,0,	
126,0,	126,0,	126,0,	126,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	0,0,	
127,0,	127,0,	127,0,	0,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	127,25,	127,0,	127,0,	
127,0,	127,0,	127,0,	127,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	127,0,	127,0,	
127,0,	127,0,	0,0,	127,0,	
0,0,	0,0,	0,0,	127,161,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	127,0,	127,0,	
127,0,	127,0,	127,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	0,0,	128,0,	
128,0,	128,0,	0,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
128,25,	128,0,	128,0,	128,0,	
128,0,	128,0,	128,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	128,0,	128,0,	128,0,	
128,0,	0,0,	128,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
128,162,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	128,0,	128,0,	128,0,	
128,0,	128,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	0,0,	129,0,	129,0,	
129,0,	0,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	129,25,	
129,0,	129,0,	129,0,	129,0,	
129,0,	129,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
129,0,	129,0,	129,0,	129,0,	
129,163,	129,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
129,0,	129,0,	129,0,	129,0,	
129,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
0,0,	130,0,	130,0,	130,0,	
0,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	130,25,	130,0,	
130,0,	130,0,	130,0,	130,0,	
130,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	130,0,	
130,0,	130,0,	130,0,	0,0,	
130,0,	0,0,	0,0,	130,164,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	130,0,	
130,0,	130,0,	130,0,	130,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	0,0,	
131,0,	131,0,	131,0,	0,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	131,25,	131,0,	131,0,	
131,0,	131,0,	131,0,	131,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	131,0,	131,0,	
131,0,	131,0,	0,0,	131,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
131,165,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	131,0,	131,0,	
131,0,	131,0,	131,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	0,0,	132,0,	
132,0,	132,0,	0,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
132,25,	132,0,	132,0,	132,0,	
132,0,	132,0,	132,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,0,	132,0,	132,0,	
132,0,	0,0,	132,0,	132,166,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	132,0,	132,0,	132,0,	
132,0,	132,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	0,0,	133,0,	133,0,	
133,0,	0,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	133,25,	
133,0,	133,0,	133,0,	133,0,	
133,0,	133,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
133,0,	133,0,	133,0,	133,0,	
0,0,	133,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
133,0,	133,0,	133,0,	133,0,	
133,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
0,0,	134,0,	134,0,	134,0,	
0,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	134,25,	134,0,	
134,0,	134,0,	134,0,	134,0,	
134,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	134,0,	
134,0,	134,0,	134,0,	0,0,	
134,0,	0,0,	0,0,	0,0,	
0,0,	134,167,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	134,0,	
134,0,	134,0,	134,0,	134,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	0,0,	
135,0,	135,0,	135,0,	0,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	135,25,	135,0,	135,0,	
135,0,	135,0,	135,0,	135,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,0,	135,0,	
135,0,	135,0,	0,0,	135,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	135,168,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	135,0,	135,0,	
135,0,	135,0,	135,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	0,0,	136,0,	
136,0,	136,0,	0,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
136,25,	136,0,	136,0,	136,0,	
136,0,	136,0,	136,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	136,0,	136,0,	136,0,	
136,0,	0,0,	136,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
136,169,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	136,0,	136,0,	136,0,	
136,0,	136,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	0,0,	137,0,	137,0,	
137,0,	0,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	137,25,	
137,0,	137,0,	137,0,	137,0,	
137,0,	137,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
137,0,	137,0,	137,0,	137,0,	
0,0,	137,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	137,170,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
137,0,	137,0,	137,0,	137,0,	
137,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
0,0,	138,0,	138,0,	138,0,	
0,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	138,25,	138,0,	
138,0,	138,0,	138,0,	138,0,	
138,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	138,0,	
138,0,	138,0,	138,0,	0,0,	
138,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	138,171,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	138,0,	
138,0,	138,0,	138,0,	138,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	0,0,	
139,0,	139,0,	139,0,	0,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	139,25,	139,0,	139,0,	
139,0,	139,0,	139,0,	139,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	139,0,	139,0,	
139,0,	139,0,	0,0,	139,0,	
139,172,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	139,0,	139,0,	
139,0,	139,0,	139,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	0,0,	142,0,	
142,0,	142,0,	0,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
142,25,	142,0,	142,0,	142,0,	
142,0,	142,0,	142,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	142,0,	142,0,	142,0,	
142,0,	0,0,	142,0,	0,0,	
0,0,	0,0,	0,0,	142,177,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	142,0,	142,0,	142,0,	
142,0,	142,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	0,0,	143,0,	143,0,	
143,0,	0,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	143,25,	
143,0,	143,0,	143,0,	143,0,	
143,0,	143,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
143,0,	143,0,	143,0,	143,0,	
0,0,	143,0,	0,0,	0,0,	
0,0,	143,178,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
143,0,	143,0,	143,0,	143,0,	
143,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
0,0,	144,0,	144,0,	144,0,	
0,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	144,25,	144,0,	
144,0,	144,0,	144,0,	144,0,	
144,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	144,0,	
144,0,	144,0,	144,0,	0,0,	
144,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
144,179,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	144,0,	
144,0,	144,0,	144,0,	144,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	0,0,	
145,0,	145,0,	145,0,	0,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	145,25,	145,0,	145,0,	
145,0,	145,0,	145,0,	145,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,0,	145,0,	
145,0,	145,0,	0,0,	145,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	145,180,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	145,0,	145,0,	
145,0,	145,0,	145,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	0,0,	146,0,	
146,0,	146,0,	0,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
146,25,	146,0,	146,0,	146,0,	
146,0,	146,0,	146,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	146,0,	146,0,	146,0,	
146,0,	0,0,	146,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	146,181,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	146,0,	146,0,	146,0,	
146,0,	146,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	0,0,	147,0,	147,0,	
147,0,	0,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	147,25,	
147,0,	147,0,	147,0,	147,0,	
147,0,	147,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
147,0,	147,0,	147,0,	147,0,	
0,0,	147,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	147,182,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
147,0,	147,0,	147,0,	147,0,	
147,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
0,0,	149,0,	149,0,	149,0,	
0,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	149,25,	149,0,	
149,0,	149,0,	149,0,	149,0,	
149,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	149,0,	
149,0,	149,0,	149,0,	0,0,	
149,0,	149,185,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	149,0,	
149,0,	149,0,	149,0,	149,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	0,0,	
150,0,	150,0,	150,0,	0,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	150,25,	150,0,	150,0,	
150,0,	150,0,	150,0,	150,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	150,0,	150,0,	
150,0,	150,0,	0,0,	150,0,	
0,0,	150,186,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	150,0,	150,0,	
150,0,	150,0,	150,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	0,0,	151,0,	
151,0,	151,0,	0,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
151,25,	151,0,	151,0,	151,0,	
151,0,	151,0,	151,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	151,0,	151,0,	151,0,	
151,0,	0,0,	151,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	151,187,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	151,0,	151,0,	151,0,	
151,0,	151,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	0,0,	154,0,	154,0,	
154,0,	0,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	154,25,	
154,0,	154,0,	154,0,	154,0,	
154,0,	154,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
154,0,	154,0,	154,0,	154,0,	
0,0,	154,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	154,192,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
154,0,	154,0,	154,0,	154,0,	
154,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
0,0,	155,0,	155,0,	155,0,	
0,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	155,25,	155,0,	
155,0,	155,0,	155,0,	155,0,	
155,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	155,0,	
155,0,	155,0,	155,0,	0,0,	
155,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	155,193,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	155,0,	
155,0,	155,0,	155,0,	155,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	0,0,	
156,0,	156,0,	156,0,	0,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	156,25,	156,0,	156,0,	
156,0,	156,0,	156,0,	156,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	156,0,	156,0,	
156,0,	156,0,	156,194,	156,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	156,0,	156,0,	
156,0,	156,0,	156,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	0,0,	157,0,	
157,0,	157,0,	0,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
157,25,	157,0,	157,0,	157,0,	
157,0,	157,0,	157,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	157,0,	157,0,	157,0,	
157,0,	0,0,	157,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	157,195,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	157,0,	157,0,	157,0,	
157,0,	157,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	0,0,	158,0,	158,0,	
158,0,	0,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	158,25,	
158,0,	158,0,	158,0,	158,0,	
158,0,	158,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
158,0,	158,0,	158,0,	158,0,	
158,196,	158,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
158,0,	158,0,	158,0,	158,0,	
158,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
0,0,	159,0,	159,0,	159,0,	
0,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	159,25,	159,0,	
159,0,	159,0,	159,0,	159,0,	
159,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	159,0,	
159,0,	159,0,	159,0,	0,0,	
159,0,	0,0,	0,0,	0,0,	
0,0,	159,197,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	159,0,	
159,0,	159,0,	159,0,	159,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	0,0,	
160,0,	160,0,	160,0,	0,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	160,25,	160,0,	160,0,	
160,0,	160,0,	160,0,	160,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	160,0,	160,0,	
160,0,	160,0,	0,0,	160,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	160,0,	160,0,	
160,0,	160,0,	160,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	0,0,	161,0,	
161,0,	161,0,	0,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
161,25,	161,0,	161,0,	161,0,	
161,0,	161,0,	161,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	161,0,	161,0,	161,0,	
161,0,	0,0,	161,0,	0,0,	
0,0,	0,0,	161,198,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	161,0,	161,0,	161,0,	
161,0,	161,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	0,0,	162,0,	162,0,	
162,0,	0,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	162,25,	
162,0,	162,0,	162,0,	162,0,	
162,0,	162,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
162,0,	162,0,	162,0,	162,0,	
0,0,	162,0,	0,0,	0,0,	
0,0,	0,0,	162,199,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
162,0,	162,0,	162,0,	162,0,	
162,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
0,0,	163,0,	163,0,	163,0,	
0,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	163,25,	163,0,	
163,0,	163,0,	163,0,	163,0,	
163,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	163,0,	
163,0,	163,0,	163,0,	0,0,	
163,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	163,200,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	163,0,	
163,0,	163,0,	163,0,	163,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	0,0,	
164,0,	164,0,	164,0,	0,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	164,25,	164,0,	164,0,	
164,0,	164,0,	164,0,	164,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	164,0,	164,0,	
164,0,	164,0,	0,0,	164,0,	
164,201,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	164,0,	164,0,	
164,0,	164,0,	164,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	0,0,	165,0,	
165,0,	165,0,	0,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
165,25,	165,0,	165,0,	165,0,	
165,0,	165,0,	165,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	165,0,	165,0,	165,0,	
165,0,	0,0,	165,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
165,202,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	165,0,	165,0,	165,0,	
165,0,	165,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	0,0,	166,0,	166,0,	
166,0,	0,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	166,25,	
166,0,	166,0,	166,0,	166,0,	
166,0,	166,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
166,0,	166,0,	166,0,	166,0,	
0,0,	166,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	166,203,	0,0,	
166,0,	166,0,	166,0,	166,0,	
166,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
0,0,	167,0,	167,0,	167,0,	
0,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	167,25,	167,0,	
167,0,	167,0,	167,0,	167,0,	
167,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	167,0,	
167,0,	167,0,	167,0,	167,204,	
167,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	167,0,	
167,0,	167,0,	167,0,	167,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	0,0,	
168,0,	168,0,	168,0,	0,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	168,25,	168,0,	168,0,	
168,0,	168,0,	168,0,	168,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	168,0,	168,0,	
168,0,	168,0,	0,0,	168,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	168,205,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	168,0,	168,0,	
168,0,	168,0,	168,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	0,0,	169,0,	
169,0,	169,0,	0,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
169,25,	169,0,	169,0,	169,0,	
169,0,	169,0,	169,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	169,0,	169,0,	169,0,	
169,0,	0,0,	169,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	169,206,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	169,0,	169,0,	169,0,	
169,0,	169,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	0,0,	170,0,	170,0,	
170,0,	0,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	170,25,	
170,0,	170,0,	170,0,	170,0,	
170,0,	170,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
170,0,	170,0,	170,0,	170,0,	
0,0,	170,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
170,0,	170,0,	170,0,	170,0,	
170,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
0,0,	171,0,	171,0,	171,0,	
0,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	171,25,	171,0,	
171,0,	171,0,	171,0,	171,0,	
171,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	171,0,	
171,0,	171,0,	171,0,	0,0,	
171,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	171,207,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	171,0,	
171,0,	171,0,	171,0,	171,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	0,0,	
172,0,	172,0,	172,0,	0,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	172,25,	172,0,	172,0,	
172,0,	172,0,	172,0,	172,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	172,0,	172,0,	
172,0,	172,0,	0,0,	172,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	172,208,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	172,0,	172,0,	
172,0,	172,0,	172,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	0,0,	173,0,	
173,0,	173,0,	0,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
173,25,	173,0,	173,0,	173,0,	
173,0,	173,0,	173,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	173,0,	173,0,	173,0,	
173,0,	0,0,	173,0,	0,0,	
173,209,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	173,0,	173,0,	173,0,	
173,0,	173,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	0,0,	174,0,	174,0,	
174,0,	0,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	174,25,	
174,0,	174,0,	174,0,	174,0,	
174,0,	174,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
174,0,	174,0,	174,0,	174,0,	
0,0,	174,0,	174,210,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
174,0,	174,0,	174,0,	174,0,	
174,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
0,0,	175,0,	175,0,	175,0,	
0,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	175,25,	175,0,	
175,0,	175,0,	175,0,	175,0,	
175,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	175,0,	
175,0,	175,0,	175,0,	0,0,	
175,0,	0,0,	175,211,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	175,0,	
175,0,	175,0,	175,0,	175,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	0,0,	
176,0,	176,0,	176,0,	0,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	176,25,	176,0,	176,0,	
176,0,	176,0,	176,0,	176,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	176,0,	176,0,	
176,0,	176,0,	0,0,	176,0,	
176,212,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	176,0,	176,0,	
176,0,	176,0,	176,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	0,0,	177,0,	
177,0,	177,0,	0,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
177,25,	177,0,	177,0,	177,0,	
177,0,	177,0,	177,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	177,0,	177,0,	177,0,	
177,0,	0,0,	177,0,	0,0,	
0,0,	0,0,	0,0,	177,213,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	177,0,	177,0,	177,0,	
177,0,	177,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	0,0,	178,0,	178,0,	
178,0,	0,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	178,25,	
178,0,	178,0,	178,0,	178,0,	
178,0,	178,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
178,0,	178,0,	178,0,	178,0,	
0,0,	178,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
178,0,	178,0,	178,0,	178,0,	
178,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
0,0,	179,0,	179,0,	179,0,	
0,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	179,25,	179,0,	
179,0,	179,0,	179,0,	179,0,	
179,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	179,0,	
179,0,	179,0,	179,0,	0,0,	
179,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
179,214,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	179,0,	
179,0,	179,0,	179,0,	179,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	0,0,	
180,0,	180,0,	180,0,	0,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	180,25,	180,0,	180,0,	
180,0,	180,0,	180,0,	180,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	180,0,	180,0,	
180,0,	180,0,	0,0,	180,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	180,215,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	180,0,	180,0,	
180,0,	180,0,	180,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	0,0,	181,0,	
181,0,	181,0,	0,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
181,25,	181,0,	181,0,	181,0,	
181,0,	181,0,	181,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	181,0,	181,0,	181,0,	
181,0,	0,0,	181,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	181,216,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	181,0,	181,0,	181,0,	
181,0,	181,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	0,0,	182,0,	182,0,	
182,0,	0,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	182,25,	
182,0,	182,0,	182,0,	182,0,	
182,0,	182,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
182,0,	182,0,	182,0,	182,0,	
0,0,	182,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
182,0,	182,0,	182,0,	182,0,	
182,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
0,0,	183,0,	183,0,	183,0,	
0,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	183,25,	183,0,	
183,0,	183,0,	183,0,	183,0,	
183,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	183,0,	
183,0,	183,0,	183,0,	0,0,	
183,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	183,217,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	183,0,	
183,0,	183,0,	183,0,	183,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	0,0,	
184,0,	184,0,	184,0,	0,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	184,25,	184,0,	184,0,	
184,0,	184,0,	184,0,	184,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	184,0,	184,0,	
184,0,	184,0,	0,0,	184,0,	
184,218,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	184,0,	184,0,	
184,0,	184,0,	184,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	0,0,	185,0,	
185,0,	185,0,	0,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
185,25,	185,0,	185,0,	185,0,	
185,0,	185,0,	185,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	185,0,	185,0,	185,0,	
185,0,	0,0,	185,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
185,219,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	185,0,	185,0,	185,0,	
185,0,	185,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	0,0,	186,0,	186,0,	
186,0,	0,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	186,25,	
186,0,	186,0,	186,0,	186,0,	
186,0,	186,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
186,0,	186,0,	186,0,	186,0,	
0,0,	186,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
186,220,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
186,0,	186,0,	186,0,	186,0,	
186,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
0,0,	187,0,	187,0,	187,0,	
0,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	187,25,	187,0,	
187,0,	187,0,	187,0,	187,0,	
187,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	187,0,	
187,0,	187,0,	187,0,	0,0,	
187,0,	187,221,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	187,0,	
187,0,	187,0,	187,0,	187,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	0,0,	
188,0,	188,0,	188,0,	0,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	188,25,	188,0,	188,0,	
188,0,	188,0,	188,0,	188,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	188,0,	188,0,	
188,0,	188,0,	0,0,	188,0,	
0,0,	188,222,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	188,0,	188,0,	
188,0,	188,0,	188,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	0,0,	189,0,	
189,0,	189,0,	0,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
189,25,	189,0,	189,0,	189,0,	
189,0,	189,0,	189,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	189,0,	189,0,	189,0,	
189,0,	0,0,	189,0,	189,223,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	189,0,	189,0,	189,0,	
189,0,	189,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	0,0,	190,0,	190,0,	
190,0,	0,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	190,25,	
190,0,	190,0,	190,0,	190,0,	
190,0,	190,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
190,0,	190,0,	190,0,	190,0,	
0,0,	190,0,	0,0,	190,224,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
190,0,	190,0,	190,0,	190,0,	
190,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
0,0,	191,0,	191,0,	191,0,	
0,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	191,25,	191,0,	
191,0,	191,0,	191,0,	191,0,	
191,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	191,0,	
191,0,	191,0,	191,0,	0,0,	
191,0,	191,225,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	191,0,	
191,0,	191,0,	191,0,	191,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	0,0,	
192,0,	192,0,	192,0,	0,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	192,25,	192,0,	192,0,	
192,0,	192,0,	192,0,	192,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	192,0,	192,0,	
192,0,	192,0,	0,0,	192,0,	
0,0,	0,0,	0,0,	0,0,	
192,226,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	192,0,	192,0,	
192,0,	192,0,	192,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	0,0,	193,0,	
193,0,	193,0,	0,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
193,25,	193,0,	193,0,	193,0,	
193,0,	193,0,	193,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	193,0,	193,0,	193,0,	
193,0,	0,0,	193,0,	0,0,	
0,0,	0,0,	0,0,	193,227,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	193,0,	193,0,	193,0,	
193,0,	193,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	0,0,	194,0,	194,0,	
194,0,	0,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	194,25,	
194,0,	194,0,	194,0,	194,0,	
194,0,	194,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
194,0,	194,0,	194,0,	194,0,	
0,0,	194,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
194,228,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
194,0,	194,0,	194,0,	194,0,	
194,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
0,0,	195,0,	195,0,	195,0,	
0,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	195,25,	195,0,	
195,0,	195,0,	195,0,	195,0,	
195,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	195,0,	
195,0,	195,0,	195,0,	0,0,	
195,0,	0,0,	0,0,	0,0,	
0,0,	195,229,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	195,0,	
195,0,	195,0,	195,0,	195,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	0,0,	
196,0,	196,0,	196,0,	0,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	196,25,	196,0,	196,0,	
196,0,	196,0,	196,0,	196,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	196,0,	196,0,	
196,0,	196,0,	0,0,	196,0,	
0,0,	0,0,	0,0,	0,0,	
196,230,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	196,0,	196,0,	
196,0,	196,0,	196,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	0,0,	197,0,	
197,0,	197,0,	0,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
197,25,	197,0,	197,0,	197,0,	
197,0,	197,0,	197,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	197,0,	197,0,	197,0,	
197,0,	0,0,	197,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	197,0,	197,0,	197,0,	
197,0,	197,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	0,0,	198,0,	198,0,	
198,0,	0,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	198,25,	
198,0,	198,0,	198,0,	198,0,	
198,0,	198,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
198,0,	198,0,	198,0,	198,0,	
0,0,	198,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	198,231,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
198,0,	198,0,	198,0,	198,0,	
198,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
0,0,	199,0,	199,0,	199,0,	
0,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	199,25,	199,0,	
199,0,	199,0,	199,0,	199,0,	
199,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	199,0,	
199,0,	199,0,	199,0,	0,0,	
199,0,	0,0,	0,0,	0,0,	
199,232,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	199,0,	
199,0,	199,0,	199,0,	199,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	0,0,	
200,0,	200,0,	200,0,	0,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	200,25,	200,0,	200,0,	
200,0,	200,0,	200,0,	200,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	200,0,	200,0,	
200,0,	200,0,	0,0,	200,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	200,233,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	200,0,	200,0,	
200,0,	200,0,	200,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	0,0,	201,0,	
201,0,	201,0,	0,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
201,25,	201,0,	201,0,	201,0,	
201,0,	201,0,	201,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	201,0,	201,0,	201,0,	
201,0,	0,0,	201,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	201,234,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	201,0,	201,0,	201,0,	
201,0,	201,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	0,0,	202,0,	202,0,	
202,0,	0,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	202,25,	
202,0,	202,0,	202,0,	202,0,	
202,0,	202,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
202,0,	202,0,	202,0,	202,0,	
0,0,	202,0,	0,0,	0,0,	
0,0,	0,0,	202,235,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
202,0,	202,0,	202,0,	202,0,	
202,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
0,0,	203,0,	203,0,	203,0,	
0,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	203,25,	203,0,	
203,0,	203,0,	203,0,	203,0,	
203,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	203,0,	
203,0,	203,0,	203,0,	0,0,	
203,0,	0,0,	0,0,	0,0,	
0,0,	203,236,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	203,0,	
203,0,	203,0,	203,0,	203,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	0,0,	
205,0,	205,0,	205,0,	0,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	205,25,	205,0,	205,0,	
205,0,	205,0,	205,0,	205,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	205,0,	205,0,	
205,0,	205,0,	0,0,	205,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
205,239,	0,0,	205,0,	205,0,	
205,0,	205,0,	205,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	0,0,	206,0,	
206,0,	206,0,	0,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
206,25,	206,0,	206,0,	206,0,	
206,0,	206,0,	206,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	206,0,	206,0,	206,0,	
206,0,	0,0,	206,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	206,240,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	206,0,	206,0,	206,0,	
206,0,	206,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	0,0,	207,0,	207,0,	
207,0,	0,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	207,25,	
207,0,	207,0,	207,0,	207,0,	
207,0,	207,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
207,0,	207,0,	207,0,	207,0,	
0,0,	207,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
207,0,	207,0,	207,0,	207,0,	
207,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
0,0,	208,0,	208,0,	208,0,	
0,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	208,25,	208,0,	
208,0,	208,0,	208,0,	208,0,	
208,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	208,0,	
208,0,	208,0,	208,0,	0,0,	
208,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
208,241,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	208,0,	
208,0,	208,0,	208,0,	208,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	0,0,	
209,0,	209,0,	209,0,	0,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	209,25,	209,0,	209,0,	
209,0,	209,0,	209,0,	209,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	209,0,	209,0,	
209,0,	209,0,	0,0,	209,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	209,242,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	209,0,	209,0,	
209,0,	209,0,	209,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	0,0,	211,0,	
211,0,	211,0,	0,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
211,25,	211,0,	211,0,	211,0,	
211,0,	211,0,	211,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	211,0,	211,0,	211,0,	
211,0,	0,0,	211,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
211,245,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	211,0,	211,0,	211,0,	
211,0,	211,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	0,0,	213,0,	213,0,	
213,0,	0,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	213,25,	
213,0,	213,0,	213,0,	213,0,	
213,0,	213,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
213,0,	213,0,	213,0,	213,0,	
213,248,	213,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
213,0,	213,0,	213,0,	213,0,	
213,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
0,0,	214,0,	214,0,	214,0,	
0,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	214,25,	214,0,	
214,0,	214,0,	214,0,	214,0,	
214,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	214,0,	
214,0,	214,0,	214,0,	0,0,	
214,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	214,249,	0,0,	214,0,	
214,0,	214,0,	214,0,	214,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	0,0,	
215,0,	215,0,	215,0,	0,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	215,25,	215,0,	215,0,	
215,0,	215,0,	215,0,	215,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	215,0,	215,0,	
215,0,	215,0,	0,0,	215,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	215,250,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	215,0,	215,0,	
215,0,	215,0,	215,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	0,0,	216,0,	
216,0,	216,0,	0,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
216,25,	216,0,	216,0,	216,0,	
216,0,	216,0,	216,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	216,0,	216,0,	216,0,	
216,0,	0,0,	216,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	216,251,	
0,0,	216,0,	216,0,	216,0,	
216,0,	216,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	0,0,	217,0,	217,0,	
217,0,	0,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	217,25,	
217,0,	217,0,	217,0,	217,0,	
217,0,	217,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
217,0,	217,0,	217,0,	217,0,	
0,0,	217,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
217,0,	217,0,	217,0,	217,0,	
217,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
0,0,	218,0,	218,0,	218,0,	
0,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	218,25,	218,0,	
218,0,	218,0,	218,0,	218,0,	
218,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	218,0,	
218,0,	218,0,	218,0,	0,0,	
218,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
218,252,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	218,0,	
218,0,	218,0,	218,0,	218,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	0,0,	
219,0,	219,0,	219,0,	0,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	219,25,	219,0,	219,0,	
219,0,	219,0,	219,0,	219,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	219,0,	219,0,	
219,0,	219,0,	0,0,	219,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	219,253,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	219,0,	219,0,	
219,0,	219,0,	219,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	0,0,	220,0,	
220,0,	220,0,	0,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
220,25,	220,0,	220,0,	220,0,	
220,0,	220,0,	220,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	220,0,	220,0,	220,0,	
220,0,	0,0,	220,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	220,254,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	220,0,	220,0,	220,0,	
220,0,	220,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	0,0,	221,0,	221,0,	
221,0,	0,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	221,25,	
221,0,	221,0,	221,0,	221,0,	
221,0,	221,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
221,0,	221,0,	221,0,	221,0,	
0,0,	221,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	221,255,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
221,0,	221,0,	221,0,	221,0,	
221,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
0,0,	222,0,	222,0,	222,0,	
0,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	222,25,	222,0,	
222,0,	222,0,	222,0,	222,0,	
222,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	222,0,	
222,0,	222,0,	222,0,	0,0,	
222,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	222,256,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	222,0,	
222,0,	222,0,	222,0,	222,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	0,0,	
224,0,	224,0,	224,0,	0,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	224,25,	224,0,	224,0,	
224,0,	224,0,	224,0,	224,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	224,0,	224,0,	
224,0,	224,0,	0,0,	224,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	224,259,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	224,0,	224,0,	
224,0,	224,0,	224,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	0,0,	226,0,	
226,0,	226,0,	0,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
226,25,	226,0,	226,0,	226,0,	
226,0,	226,0,	226,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	226,0,	226,0,	226,0,	
226,0,	226,262,	226,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	226,0,	226,0,	226,0,	
226,0,	226,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	0,0,	227,0,	227,0,	
227,0,	0,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	227,25,	
227,0,	227,0,	227,0,	227,0,	
227,0,	227,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
227,0,	227,0,	227,0,	227,0,	
0,0,	227,0,	0,0,	0,0,	
227,263,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
227,0,	227,0,	227,0,	227,0,	
227,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
0,0,	228,0,	228,0,	228,0,	
0,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	228,25,	228,0,	
228,0,	228,0,	228,0,	228,0,	
228,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	228,0,	
228,0,	228,0,	228,0,	0,0,	
228,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	228,264,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	228,0,	
228,0,	228,0,	228,0,	228,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	0,0,	
229,0,	229,0,	229,0,	0,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	229,25,	229,0,	229,0,	
229,0,	229,0,	229,0,	229,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	229,0,	229,0,	
229,0,	229,0,	229,265,	229,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	229,0,	229,0,	
229,0,	229,0,	229,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	0,0,	230,0,	
230,0,	230,0,	0,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
230,25,	230,0,	230,0,	230,0,	
230,0,	230,0,	230,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	230,0,	230,0,	230,0,	
230,0,	0,0,	230,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	230,266,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	230,0,	230,0,	230,0,	
230,0,	230,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	0,0,	231,0,	231,0,	
231,0,	0,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	231,25,	
231,0,	231,0,	231,0,	231,0,	
231,0,	231,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
231,0,	231,0,	231,0,	231,0,	
0,0,	231,0,	0,0,	0,0,	
0,0,	0,0,	231,267,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
231,0,	231,0,	231,0,	231,0,	
231,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
0,0,	232,0,	232,0,	232,0,	
0,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	232,25,	232,0,	
232,0,	232,0,	232,0,	232,0,	
232,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	232,0,	
232,0,	232,0,	232,0,	0,0,	
232,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	232,268,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	232,0,	
232,0,	232,0,	232,0,	232,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	0,0,	
233,0,	233,0,	233,0,	0,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	233,25,	233,0,	233,0,	
233,0,	233,0,	233,0,	233,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	233,0,	233,0,	
233,0,	233,0,	0,0,	233,0,	
233,269,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	233,0,	233,0,	
233,0,	233,0,	233,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	0,0,	234,0,	
234,0,	234,0,	0,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
234,25,	234,0,	234,0,	234,0,	
234,0,	234,0,	234,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	234,0,	234,0,	234,0,	
234,0,	0,0,	234,0,	0,0,	
0,0,	0,0,	0,0,	234,270,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	234,0,	234,0,	234,0,	
234,0,	234,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	0,0,	235,0,	235,0,	
235,0,	0,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	235,25,	
235,0,	235,0,	235,0,	235,0,	
235,0,	235,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
235,0,	235,0,	235,0,	235,0,	
235,271,	235,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
235,0,	235,0,	235,0,	235,0,	
235,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
0,0,	236,0,	236,0,	236,0,	
0,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	236,25,	236,0,	
236,0,	236,0,	236,0,	236,0,	
236,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	236,0,	
236,0,	236,0,	236,0,	0,0,	
236,0,	0,0,	0,0,	0,0,	
236,272,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	236,0,	
236,0,	236,0,	236,0,	236,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	0,0,	
237,0,	237,0,	237,0,	0,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	237,25,	237,0,	237,0,	
237,0,	237,0,	237,0,	237,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	237,0,	237,0,	
237,0,	237,0,	0,0,	237,0,	
0,0,	0,0,	0,0,	237,273,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	237,0,	237,0,	
237,0,	237,0,	237,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	0,0,	238,0,	
238,0,	238,0,	0,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
238,25,	238,0,	238,0,	238,0,	
238,0,	238,0,	238,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	238,0,	238,0,	238,0,	
238,0,	0,0,	238,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
238,274,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	238,0,	238,0,	238,0,	
238,0,	238,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	0,0,	239,0,	239,0,	
239,0,	0,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	239,25,	
239,0,	239,0,	239,0,	239,0,	
239,0,	239,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
239,0,	239,0,	239,0,	239,0,	
0,0,	239,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
239,0,	239,0,	239,0,	239,0,	
239,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
0,0,	240,0,	240,0,	240,0,	
0,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	240,25,	240,0,	
240,0,	240,0,	240,0,	240,0,	
240,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	240,0,	
240,0,	240,0,	240,0,	0,0,	
240,0,	240,275,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	240,0,	
240,0,	240,0,	240,0,	240,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	0,0,	
241,0,	241,0,	241,0,	0,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	241,25,	241,0,	241,0,	
241,0,	241,0,	241,0,	241,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	241,0,	241,0,	
241,0,	241,0,	0,0,	241,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
241,276,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	241,0,	241,0,	
241,0,	241,0,	241,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	0,0,	242,0,	
242,0,	242,0,	0,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
242,25,	242,0,	242,0,	242,0,	
242,0,	242,0,	242,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	242,0,	242,0,	242,0,	
242,0,	0,0,	242,0,	0,0,	
0,0,	0,0,	0,0,	242,277,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	242,0,	242,0,	242,0,	
242,0,	242,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	0,0,	243,0,	243,0,	
243,0,	0,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	243,25,	
243,0,	243,0,	243,0,	243,0,	
243,0,	243,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
243,0,	243,0,	243,0,	243,0,	
0,0,	243,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	243,278,	0,0,	
0,0,	0,0,	0,0,	0,0,	
243,0,	243,0,	243,0,	243,0,	
243,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
0,0,	244,0,	244,0,	244,0,	
0,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	244,25,	244,0,	
244,0,	244,0,	244,0,	244,0,	
244,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	244,0,	
244,0,	244,0,	244,0,	0,0,	
244,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	244,279,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	244,0,	
244,0,	244,0,	244,0,	244,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	0,0,	
245,0,	245,0,	245,0,	0,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	245,25,	245,0,	245,0,	
245,0,	245,0,	245,0,	245,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	245,0,	245,0,	
245,0,	245,0,	0,0,	245,0,	
0,0,	0,0,	0,0,	0,0,	
245,280,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	245,0,	245,0,	
245,0,	245,0,	245,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	0,0,	246,0,	
246,0,	246,0,	0,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
246,25,	246,0,	246,0,	246,0,	
246,0,	246,0,	246,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	246,0,	246,0,	246,0,	
246,0,	0,0,	246,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	246,281,	
0,0,	0,0,	0,0,	0,0,	
0,0,	246,0,	246,0,	246,0,	
246,0,	246,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	0,0,	247,0,	247,0,	
247,0,	0,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	247,25,	
247,0,	247,0,	247,0,	247,0,	
247,0,	247,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
247,0,	247,0,	247,0,	247,0,	
0,0,	247,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	247,282,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
247,0,	247,0,	247,0,	247,0,	
247,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
0,0,	248,0,	248,0,	248,0,	
0,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	248,25,	248,0,	
248,0,	248,0,	248,0,	248,0,	
248,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	248,0,	
248,0,	248,0,	248,0,	0,0,	
248,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	248,283,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	248,0,	
248,0,	248,0,	248,0,	248,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	0,0,	
249,0,	249,0,	249,0,	0,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	249,25,	249,0,	249,0,	
249,0,	249,0,	249,0,	249,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	249,0,	249,0,	
249,0,	249,0,	0,0,	249,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	249,0,	249,0,	
249,0,	249,0,	249,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	0,0,	250,0,	
250,0,	250,0,	0,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
250,25,	250,0,	250,0,	250,0,	
250,0,	250,0,	250,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	250,0,	250,0,	250,0,	
250,0,	0,0,	250,0,	250,284,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	250,0,	250,0,	250,0,	
250,0,	250,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	0,0,	251,0,	251,0,	
251,0,	0,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	251,25,	
251,0,	251,0,	251,0,	251,0,	
251,0,	251,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
251,0,	251,0,	251,0,	251,0,	
251,285,	251,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
251,0,	251,0,	251,0,	251,0,	
251,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
0,0,	252,0,	252,0,	252,0,	
0,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	252,25,	252,0,	
252,0,	252,0,	252,0,	252,0,	
252,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	252,0,	
252,0,	252,0,	252,0,	0,0,	
252,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
252,286,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	252,0,	
252,0,	252,0,	252,0,	252,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	0,0,	
253,0,	253,0,	253,0,	0,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	253,25,	253,0,	253,0,	
253,0,	253,0,	253,0,	253,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	253,0,	253,0,	
253,0,	253,0,	0,0,	253,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
253,287,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	253,0,	253,0,	
253,0,	253,0,	253,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	0,0,	254,0,	
254,0,	254,0,	0,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
254,25,	254,0,	254,0,	254,0,	
254,0,	254,0,	254,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	254,0,	254,0,	254,0,	
254,0,	0,0,	254,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	254,288,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	254,0,	254,0,	254,0,	
254,0,	254,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	0,0,	255,0,	255,0,	
255,0,	0,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	255,25,	
255,0,	255,0,	255,0,	255,0,	
255,0,	255,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
255,0,	255,0,	255,0,	255,0,	
0,0,	255,0,	0,0,	0,0,	
0,0,	0,0,	255,289,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
255,0,	255,0,	255,0,	255,0,	
255,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
0,0,	256,0,	256,0,	256,0,	
0,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	256,25,	256,0,	
256,0,	256,0,	256,0,	256,0,	
256,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	256,0,	
256,0,	256,0,	256,0,	0,0,	
256,0,	0,0,	0,0,	0,0,	
0,0,	256,290,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	256,0,	
256,0,	256,0,	256,0,	256,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	0,0,	
257,0,	257,0,	257,0,	0,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	257,25,	257,0,	257,0,	
257,0,	257,0,	257,0,	257,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	257,0,	257,0,	
257,0,	257,0,	0,0,	257,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
257,291,	0,0,	0,0,	0,0,	
0,0,	0,0,	257,0,	257,0,	
257,0,	257,0,	257,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	0,0,	258,0,	
258,0,	258,0,	0,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
258,25,	258,0,	258,0,	258,0,	
258,0,	258,0,	258,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	258,0,	258,0,	258,0,	
258,0,	0,0,	258,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	258,292,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	258,0,	258,0,	258,0,	
258,0,	258,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	0,0,	259,0,	259,0,	
259,0,	0,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	259,25,	
259,0,	259,0,	259,0,	259,0,	
259,0,	259,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
259,0,	259,0,	259,0,	259,0,	
0,0,	259,0,	0,0,	0,0,	
0,0,	0,0,	259,293,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
259,0,	259,0,	259,0,	259,0,	
259,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
0,0,	260,0,	260,0,	260,0,	
0,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	260,25,	260,0,	
260,0,	260,0,	260,0,	260,0,	
260,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	260,0,	
260,0,	260,0,	260,0,	0,0,	
260,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	260,294,	0,0,	0,0,	
0,0,	0,0,	0,0,	260,0,	
260,0,	260,0,	260,0,	260,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	0,0,	
261,0,	261,0,	261,0,	0,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	261,25,	261,0,	261,0,	
261,0,	261,0,	261,0,	261,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	261,0,	261,0,	
261,0,	261,0,	0,0,	261,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
261,295,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	261,0,	261,0,	
261,0,	261,0,	261,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	0,0,	262,0,	
262,0,	262,0,	0,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
262,25,	262,0,	262,0,	262,0,	
262,0,	262,0,	262,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	262,0,	262,0,	262,0,	
262,0,	0,0,	262,0,	0,0,	
0,0,	0,0,	0,0,	262,296,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	262,0,	262,0,	262,0,	
262,0,	262,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	0,0,	263,0,	263,0,	
263,0,	0,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	263,25,	
263,0,	263,0,	263,0,	263,0,	
263,0,	263,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
263,0,	263,0,	263,0,	263,0,	
0,0,	263,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	263,297,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
263,0,	263,0,	263,0,	263,0,	
263,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
0,0,	264,0,	264,0,	264,0,	
0,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	264,25,	264,0,	
264,0,	264,0,	264,0,	264,0,	
264,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	264,0,	
264,0,	264,0,	264,0,	264,298,	
264,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	264,0,	
264,0,	264,0,	264,0,	264,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	0,0,	
265,0,	265,0,	265,0,	0,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	265,25,	265,0,	265,0,	
265,0,	265,0,	265,0,	265,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	265,0,	265,0,	
265,0,	265,0,	0,0,	265,0,	
0,0,	0,0,	0,0,	0,0,	
265,299,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	265,0,	265,0,	
265,0,	265,0,	265,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	0,0,	266,0,	
266,0,	266,0,	0,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
266,25,	266,0,	266,0,	266,0,	
266,0,	266,0,	266,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	266,0,	266,0,	266,0,	
266,0,	0,0,	266,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	266,300,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	266,0,	266,0,	266,0,	
266,0,	266,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	0,0,	267,0,	267,0,	
267,0,	0,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	267,25,	
267,0,	267,0,	267,0,	267,0,	
267,0,	267,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
267,0,	267,0,	267,0,	267,0,	
0,0,	267,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
267,301,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
267,0,	267,0,	267,0,	267,0,	
267,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
0,0,	268,0,	268,0,	268,0,	
0,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	268,25,	268,0,	
268,0,	268,0,	268,0,	268,0,	
268,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	268,0,	
268,0,	268,0,	268,0,	0,0,	
268,0,	0,0,	0,0,	268,302,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	268,0,	
268,0,	268,0,	268,0,	268,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	0,0,	
269,0,	269,0,	269,0,	0,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	269,25,	269,0,	269,0,	
269,0,	269,0,	269,0,	269,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	269,0,	269,0,	
269,0,	269,0,	0,0,	269,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	269,303,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	269,0,	269,0,	
269,0,	269,0,	269,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	0,0,	270,0,	
270,0,	270,0,	0,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
270,25,	270,0,	270,0,	270,0,	
270,0,	270,0,	270,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	270,0,	270,0,	270,0,	
270,0,	0,0,	270,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	270,0,	270,0,	270,0,	
270,0,	270,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	0,0,	271,0,	271,0,	
271,0,	0,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	271,25,	
271,0,	271,0,	271,0,	271,0,	
271,0,	271,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
271,0,	271,0,	271,0,	271,0,	
0,0,	271,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	271,304,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
271,0,	271,0,	271,0,	271,0,	
271,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
0,0,	272,0,	272,0,	272,0,	
0,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	272,25,	272,0,	
272,0,	272,0,	272,0,	272,0,	
272,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	272,0,	
272,0,	272,0,	272,0,	272,305,	
272,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	272,0,	
272,0,	272,0,	272,0,	272,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	0,0,	
273,0,	273,0,	273,0,	0,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	273,25,	273,0,	273,0,	
273,0,	273,0,	273,0,	273,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	273,0,	273,0,	
273,0,	273,0,	0,0,	273,0,	
0,0,	0,0,	0,0,	273,306,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	273,0,	273,0,	
273,0,	273,0,	273,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	0,0,	274,0,	
274,0,	274,0,	0,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
274,25,	274,0,	274,0,	274,0,	
274,0,	274,0,	274,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	274,0,	274,0,	274,0,	
274,0,	0,0,	274,0,	0,0,	
0,0,	0,0,	0,0,	274,307,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	274,0,	274,0,	274,0,	
274,0,	274,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	0,0,	275,0,	275,0,	
275,0,	0,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	275,25,	
275,0,	275,0,	275,0,	275,0,	
275,0,	275,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
275,0,	275,0,	275,0,	275,0,	
0,0,	275,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	275,308,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
275,0,	275,0,	275,0,	275,0,	
275,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
0,0,	276,0,	276,0,	276,0,	
0,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	276,25,	276,0,	
276,0,	276,0,	276,0,	276,0,	
276,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	276,0,	
276,0,	276,0,	276,0,	0,0,	
276,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	276,309,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	276,0,	
276,0,	276,0,	276,0,	276,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	0,0,	
277,0,	277,0,	277,0,	0,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	277,25,	277,0,	277,0,	
277,0,	277,0,	277,0,	277,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	277,0,	277,0,	
277,0,	277,0,	0,0,	277,0,	
0,0,	0,0,	277,310,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	277,0,	277,0,	
277,0,	277,0,	277,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	0,0,	278,0,	
278,0,	278,0,	0,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
278,25,	278,0,	278,0,	278,0,	
278,0,	278,0,	278,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	278,0,	278,0,	278,0,	
278,0,	0,0,	278,0,	0,0,	
0,0,	0,0,	0,0,	278,311,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	278,0,	278,0,	278,0,	
278,0,	278,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	0,0,	279,0,	279,0,	
279,0,	0,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	279,25,	
279,0,	279,0,	279,0,	279,0,	
279,0,	279,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
279,0,	279,0,	279,0,	279,0,	
0,0,	279,0,	279,312,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
279,0,	279,0,	279,0,	279,0,	
279,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
0,0,	280,0,	280,0,	280,0,	
0,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	280,25,	280,0,	
280,0,	280,0,	280,0,	280,0,	
280,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	280,0,	
280,0,	280,0,	280,0,	0,0,	
280,0,	0,0,	0,0,	280,313,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	280,0,	
280,0,	280,0,	280,0,	280,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	0,0,	
281,0,	281,0,	281,0,	0,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	281,25,	281,0,	281,0,	
281,0,	281,0,	281,0,	281,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	281,0,	281,0,	
281,0,	281,0,	0,0,	281,0,	
0,0,	0,0,	0,0,	0,0,	
281,314,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	281,0,	281,0,	
281,0,	281,0,	281,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	0,0,	282,0,	
282,0,	282,0,	0,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
282,25,	282,0,	282,0,	282,0,	
282,0,	282,0,	282,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	282,0,	282,0,	282,0,	
282,0,	0,0,	282,0,	282,315,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	282,0,	282,0,	282,0,	
282,0,	282,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	0,0,	283,0,	283,0,	
283,0,	0,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	283,25,	
283,0,	283,0,	283,0,	283,0,	
283,0,	283,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
283,0,	283,0,	283,0,	283,0,	
0,0,	283,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	283,316,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
283,0,	283,0,	283,0,	283,0,	
283,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
0,0,	284,0,	284,0,	284,0,	
0,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	284,25,	284,0,	
284,0,	284,0,	284,0,	284,0,	
284,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	284,0,	
284,0,	284,0,	284,0,	0,0,	
284,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	284,317,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	284,0,	
284,0,	284,0,	284,0,	284,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	0,0,	
285,0,	285,0,	285,0,	0,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	285,25,	285,0,	285,0,	
285,0,	285,0,	285,0,	285,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	285,0,	285,0,	
285,0,	285,0,	0,0,	285,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	285,318,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	285,0,	285,0,	
285,0,	285,0,	285,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	0,0,	286,0,	
286,0,	286,0,	0,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
286,25,	286,0,	286,0,	286,0,	
286,0,	286,0,	286,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	286,0,	286,0,	286,0,	
286,0,	0,0,	286,0,	0,0,	
0,0,	0,0,	0,0,	286,319,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	286,0,	286,0,	286,0,	
286,0,	286,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	0,0,	287,0,	287,0,	
287,0,	0,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	287,25,	
287,0,	287,0,	287,0,	287,0,	
287,0,	287,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
287,0,	287,0,	287,0,	287,0,	
0,0,	287,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	287,320,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
287,0,	287,0,	287,0,	287,0,	
287,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
0,0,	288,0,	288,0,	288,0,	
0,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	288,25,	288,0,	
288,0,	288,0,	288,0,	288,0,	
288,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	288,0,	
288,0,	288,0,	288,0,	0,0,	
288,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
288,321,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	288,0,	
288,0,	288,0,	288,0,	288,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	0,0,	
289,0,	289,0,	289,0,	0,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	289,25,	289,0,	289,0,	
289,0,	289,0,	289,0,	289,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	289,0,	289,0,	
289,0,	289,0,	289,322,	289,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	289,0,	289,0,	
289,0,	289,0,	289,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	0,0,	290,0,	
290,0,	290,0,	0,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
290,25,	290,0,	290,0,	290,0,	
290,0,	290,0,	290,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	290,0,	290,0,	290,0,	
290,0,	0,0,	290,0,	0,0,	
0,0,	290,323,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	290,0,	290,0,	290,0,	
290,0,	290,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	0,0,	291,0,	291,0,	
291,0,	0,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	291,25,	
291,0,	291,0,	291,0,	291,0,	
291,0,	291,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
291,0,	291,0,	291,0,	291,0,	
0,0,	291,0,	0,0,	0,0,	
0,0,	0,0,	291,324,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
291,0,	291,0,	291,0,	291,0,	
291,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
0,0,	292,0,	292,0,	292,0,	
0,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	292,25,	292,0,	
292,0,	292,0,	292,0,	292,0,	
292,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	292,0,	
292,0,	292,0,	292,0,	0,0,	
292,0,	292,325,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	292,0,	
292,0,	292,0,	292,0,	292,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	0,0,	
293,0,	293,0,	293,0,	0,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	293,25,	293,0,	293,0,	
293,0,	293,0,	293,0,	293,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	293,0,	293,0,	
293,0,	293,0,	0,0,	293,0,	
0,0,	0,0,	293,326,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	293,0,	293,0,	
293,0,	293,0,	293,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	0,0,	294,0,	
294,0,	294,0,	0,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
294,25,	294,0,	294,0,	294,0,	
294,0,	294,0,	294,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	294,0,	294,0,	294,0,	
294,0,	0,0,	294,0,	0,0,	
0,0,	0,0,	0,0,	294,327,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	294,0,	294,0,	294,0,	
294,0,	294,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	0,0,	295,0,	295,0,	
295,0,	0,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	295,25,	
295,0,	295,0,	295,0,	295,0,	
295,0,	295,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
295,0,	295,0,	295,0,	295,0,	
0,0,	295,0,	295,328,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
295,0,	295,0,	295,0,	295,0,	
295,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
0,0,	296,0,	296,0,	296,0,	
0,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	296,25,	296,0,	
296,0,	296,0,	296,0,	296,0,	
296,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	296,0,	
296,0,	296,0,	296,0,	0,0,	
296,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
296,329,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	296,0,	
296,0,	296,0,	296,0,	296,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	0,0,	
297,0,	297,0,	297,0,	0,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	297,25,	297,0,	297,0,	
297,0,	297,0,	297,0,	297,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	297,0,	297,0,	
297,0,	297,0,	297,330,	297,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	297,0,	297,0,	
297,0,	297,0,	297,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	0,0,	299,0,	
299,0,	299,0,	0,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
299,25,	299,0,	299,0,	299,0,	
299,0,	299,0,	299,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	299,0,	299,0,	299,0,	
299,0,	0,0,	299,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	299,335,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	299,0,	299,0,	299,0,	
299,0,	299,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	0,0,	300,0,	300,0,	
300,0,	0,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	300,25,	
300,0,	300,0,	300,0,	300,0,	
300,0,	300,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
300,0,	300,0,	300,0,	300,0,	
0,0,	300,0,	0,0,	0,0,	
0,0,	0,0,	300,336,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
300,0,	300,0,	300,0,	300,0,	
300,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
0,0,	301,0,	301,0,	301,0,	
0,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	301,25,	301,0,	
301,0,	301,0,	301,0,	301,0,	
301,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	301,0,	
301,0,	301,0,	301,0,	0,0,	
301,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	301,337,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	301,0,	
301,0,	301,0,	301,0,	301,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	0,0,	
302,0,	302,0,	302,0,	0,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	302,25,	302,0,	302,0,	
302,0,	302,0,	302,0,	302,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	302,0,	302,0,	
302,0,	302,0,	0,0,	302,0,	
302,338,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	302,0,	302,0,	
302,0,	302,0,	302,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	0,0,	303,0,	
303,0,	303,0,	0,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
303,25,	303,0,	303,0,	303,0,	
303,0,	303,0,	303,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	303,0,	303,0,	303,0,	
303,0,	0,0,	303,0,	0,0,	
0,0,	0,0,	0,0,	303,339,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	303,0,	303,0,	303,0,	
303,0,	303,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	0,0,	304,0,	304,0,	
304,0,	0,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	304,25,	
304,0,	304,0,	304,0,	304,0,	
304,0,	304,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
304,0,	304,0,	304,0,	304,0,	
0,0,	304,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	304,340,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
304,0,	304,0,	304,0,	304,0,	
304,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
0,0,	305,0,	305,0,	305,0,	
0,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	305,25,	305,0,	
305,0,	305,0,	305,0,	305,0,	
305,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	305,0,	
305,0,	305,0,	305,0,	0,0,	
305,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
305,341,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	305,0,	
305,0,	305,0,	305,0,	305,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	0,0,	
306,0,	306,0,	306,0,	0,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	306,25,	306,0,	306,0,	
306,0,	306,0,	306,0,	306,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	306,0,	306,0,	
306,0,	306,0,	0,0,	306,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	306,342,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	306,0,	306,0,	
306,0,	306,0,	306,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	0,0,	307,0,	
307,0,	307,0,	0,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
307,25,	307,0,	307,0,	307,0,	
307,0,	307,0,	307,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	307,0,	307,0,	307,0,	
307,0,	0,0,	307,0,	0,0,	
0,0,	0,0,	307,343,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	307,0,	307,0,	307,0,	
307,0,	307,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	0,0,	308,0,	308,0,	
308,0,	0,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	308,25,	
308,0,	308,0,	308,0,	308,0,	
308,0,	308,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
308,0,	308,0,	308,0,	308,0,	
0,0,	308,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	308,344,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
308,0,	308,0,	308,0,	308,0,	
308,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
0,0,	309,0,	309,0,	309,0,	
0,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	309,25,	309,0,	
309,0,	309,0,	309,0,	309,0,	
309,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	309,0,	
309,0,	309,0,	309,0,	0,0,	
309,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	309,345,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	309,0,	
309,0,	309,0,	309,0,	309,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	0,0,	
310,0,	310,0,	310,0,	0,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	310,25,	310,0,	310,0,	
310,0,	310,0,	310,0,	310,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	310,0,	310,0,	
310,0,	310,0,	0,0,	310,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	310,346,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	310,0,	310,0,	
310,0,	310,0,	310,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	0,0,	311,0,	
311,0,	311,0,	0,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
311,25,	311,0,	311,0,	311,0,	
311,0,	311,0,	311,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	311,0,	311,0,	311,0,	
311,0,	0,0,	311,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	311,0,	311,0,	311,0,	
311,0,	311,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	0,0,	312,0,	312,0,	
312,0,	0,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	312,25,	
312,0,	312,0,	312,0,	312,0,	
312,0,	312,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
312,0,	312,0,	312,0,	312,0,	
0,0,	312,0,	0,0,	312,347,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
312,0,	312,0,	312,0,	312,0,	
312,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
0,0,	313,0,	313,0,	313,0,	
0,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	313,25,	313,0,	
313,0,	313,0,	313,0,	313,0,	
313,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	313,0,	
313,0,	313,0,	313,0,	0,0,	
313,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
313,348,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	313,0,	
313,0,	313,0,	313,0,	313,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	0,0,	
314,0,	314,0,	314,0,	0,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	314,25,	314,0,	314,0,	
314,0,	314,0,	314,0,	314,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	314,0,	314,0,	
314,0,	314,0,	0,0,	314,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	314,0,	314,0,	
314,0,	314,0,	314,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	0,0,	315,0,	
315,0,	315,0,	0,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
315,25,	315,0,	315,0,	315,0,	
315,0,	315,0,	315,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	315,0,	315,0,	315,0,	
315,0,	0,0,	315,0,	0,0,	
315,349,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	315,0,	315,0,	315,0,	
315,0,	315,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	0,0,	316,0,	316,0,	
316,0,	0,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	316,25,	
316,0,	316,0,	316,0,	316,0,	
316,0,	316,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
316,0,	316,0,	316,0,	316,0,	
0,0,	316,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
316,0,	316,0,	316,0,	316,0,	
316,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
0,0,	317,0,	317,0,	317,0,	
0,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	317,25,	317,0,	
317,0,	317,0,	317,0,	317,0,	
317,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	317,0,	
317,0,	317,0,	317,0,	0,0,	
317,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
317,350,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	317,0,	
317,0,	317,0,	317,0,	317,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	0,0,	
318,0,	318,0,	318,0,	0,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	318,25,	318,0,	318,0,	
318,0,	318,0,	318,0,	318,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	318,0,	318,0,	
318,0,	318,0,	0,0,	318,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
318,351,	0,0,	0,0,	0,0,	
0,0,	0,0,	318,0,	318,0,	
318,0,	318,0,	318,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	0,0,	319,0,	
319,0,	319,0,	0,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
319,25,	319,0,	319,0,	319,0,	
319,0,	319,0,	319,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	319,0,	319,0,	319,0,	
319,0,	0,0,	319,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	319,352,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	319,0,	319,0,	319,0,	
319,0,	319,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	0,0,	320,0,	320,0,	
320,0,	0,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	320,25,	
320,0,	320,0,	320,0,	320,0,	
320,0,	320,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
320,0,	320,0,	320,0,	320,0,	
0,0,	320,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	320,353,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
320,0,	320,0,	320,0,	320,0,	
320,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
0,0,	321,0,	321,0,	321,0,	
0,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	321,25,	321,0,	
321,0,	321,0,	321,0,	321,0,	
321,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	321,0,	
321,0,	321,0,	321,0,	0,0,	
321,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	321,354,	0,0,	0,0,	
0,0,	0,0,	0,0,	321,0,	
321,0,	321,0,	321,0,	321,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	0,0,	
322,0,	322,0,	322,0,	0,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	322,25,	322,0,	322,0,	
322,0,	322,0,	322,0,	322,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	322,0,	322,0,	
322,0,	322,0,	0,0,	322,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	322,355,	0,0,	0,0,	
0,0,	0,0,	322,0,	322,0,	
322,0,	322,0,	322,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	0,0,	323,0,	
323,0,	323,0,	0,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
323,25,	323,0,	323,0,	323,0,	
323,0,	323,0,	323,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	323,0,	323,0,	323,0,	
323,0,	0,0,	323,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	323,356,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	323,0,	323,0,	323,0,	
323,0,	323,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	0,0,	324,0,	324,0,	
324,0,	0,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	324,25,	
324,0,	324,0,	324,0,	324,0,	
324,0,	324,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
324,0,	324,0,	324,0,	324,0,	
0,0,	324,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
324,0,	324,0,	324,0,	324,0,	
324,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
0,0,	325,0,	325,0,	325,0,	
0,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	325,25,	325,0,	
325,0,	325,0,	325,0,	325,0,	
325,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	325,0,	
325,0,	325,0,	325,0,	0,0,	
325,0,	0,0,	325,357,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	325,0,	
325,0,	325,0,	325,0,	325,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	0,0,	
326,0,	326,0,	326,0,	0,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	326,25,	326,0,	326,0,	
326,0,	326,0,	326,0,	326,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	326,0,	326,0,	
326,0,	326,0,	0,0,	326,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	326,358,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	326,0,	326,0,	
326,0,	326,0,	326,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	0,0,	327,0,	
327,0,	327,0,	0,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
327,25,	327,0,	327,0,	327,0,	
327,0,	327,0,	327,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	327,0,	327,0,	327,0,	
327,0,	0,0,	327,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	327,0,	327,0,	327,0,	
327,0,	327,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	0,0,	328,0,	328,0,	
328,0,	0,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	328,25,	
328,0,	328,0,	328,0,	328,0,	
328,0,	328,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
328,0,	328,0,	328,0,	328,0,	
0,0,	328,0,	0,0,	328,359,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
328,0,	328,0,	328,0,	328,0,	
328,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
0,0,	329,0,	329,0,	329,0,	
0,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	329,25,	329,0,	
329,0,	329,0,	329,0,	329,0,	
329,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	329,0,	
329,0,	329,0,	329,0,	0,0,	
329,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	329,360,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	329,0,	
329,0,	329,0,	329,0,	329,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	0,0,	
330,0,	330,0,	330,0,	0,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	330,25,	330,0,	330,0,	
330,0,	330,0,	330,0,	330,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	330,0,	330,0,	
330,0,	330,0,	0,0,	330,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	330,361,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	330,0,	330,0,	
330,0,	330,0,	330,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	0,0,	331,0,	
331,0,	331,0,	0,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
331,25,	331,0,	331,0,	331,0,	
331,0,	331,0,	331,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	331,0,	331,0,	331,0,	
331,0,	0,0,	331,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	331,362,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	331,0,	331,0,	331,0,	
331,0,	331,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	0,0,	332,0,	332,0,	
332,0,	0,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	332,25,	
332,0,	332,0,	332,0,	332,0,	
332,0,	332,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
332,0,	332,0,	332,0,	332,0,	
0,0,	332,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	332,363,	0,0,	
0,0,	0,0,	0,0,	0,0,	
332,0,	332,0,	332,0,	332,0,	
332,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
0,0,	333,0,	333,0,	333,0,	
0,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	333,25,	333,0,	
333,0,	333,0,	333,0,	333,0,	
333,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	333,0,	
333,0,	333,0,	333,0,	0,0,	
333,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
333,364,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	333,0,	
333,0,	333,0,	333,0,	333,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	0,0,	
334,0,	334,0,	334,0,	0,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	334,25,	334,0,	334,0,	
334,0,	334,0,	334,0,	334,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	334,0,	334,0,	
334,0,	334,0,	0,0,	334,0,	
0,0,	0,0,	0,0,	0,0,	
334,365,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	334,0,	334,0,	
334,0,	334,0,	334,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	0,0,	335,0,	
335,0,	335,0,	0,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
335,25,	335,0,	335,0,	335,0,	
335,0,	335,0,	335,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	335,0,	335,0,	335,0,	
335,0,	0,0,	335,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	335,366,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	335,0,	335,0,	335,0,	
335,0,	335,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	0,0,	336,0,	336,0,	
336,0,	0,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	336,25,	
336,0,	336,0,	336,0,	336,0,	
336,0,	336,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
336,0,	336,0,	336,0,	336,0,	
0,0,	336,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
336,0,	336,0,	336,0,	336,0,	
336,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
0,0,	337,0,	337,0,	337,0,	
0,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	337,25,	337,0,	
337,0,	337,0,	337,0,	337,0,	
337,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	337,0,	
337,0,	337,0,	337,0,	0,0,	
337,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	337,0,	
337,0,	337,0,	337,0,	337,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	0,0,	
338,0,	338,0,	338,0,	0,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	338,25,	338,0,	338,0,	
338,0,	338,0,	338,0,	338,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	338,0,	338,0,	
338,0,	338,0,	0,0,	338,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	338,367,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	338,0,	338,0,	
338,0,	338,0,	338,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	0,0,	339,0,	
339,0,	339,0,	0,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
339,25,	339,0,	339,0,	339,0,	
339,0,	339,0,	339,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	339,0,	339,0,	339,0,	
339,0,	0,0,	339,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	339,0,	339,0,	339,0,	
339,0,	339,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	0,0,	340,0,	340,0,	
340,0,	0,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	340,25,	
340,0,	340,0,	340,0,	340,0,	
340,0,	340,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
340,0,	340,0,	340,0,	340,0,	
0,0,	340,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
340,368,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
340,0,	340,0,	340,0,	340,0,	
340,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
0,0,	341,0,	341,0,	341,0,	
0,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	341,25,	341,0,	
341,0,	341,0,	341,0,	341,0,	
341,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	341,0,	
341,0,	341,0,	341,0,	0,0,	
341,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	341,369,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	341,0,	
341,0,	341,0,	341,0,	341,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	0,0,	
342,0,	342,0,	342,0,	0,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	342,25,	342,0,	342,0,	
342,0,	342,0,	342,0,	342,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	342,0,	342,0,	
342,0,	342,0,	0,0,	342,0,	
0,0,	0,0,	0,0,	0,0,	
342,370,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	342,0,	342,0,	
342,0,	342,0,	342,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	0,0,	343,0,	
343,0,	343,0,	0,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
343,25,	343,0,	343,0,	343,0,	
343,0,	343,0,	343,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	343,0,	343,0,	343,0,	
343,0,	0,0,	343,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	343,371,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	343,0,	343,0,	343,0,	
343,0,	343,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	0,0,	344,0,	344,0,	
344,0,	0,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	344,25,	
344,0,	344,0,	344,0,	344,0,	
344,0,	344,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
344,0,	344,0,	344,0,	344,0,	
0,0,	344,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
344,0,	344,0,	344,0,	344,0,	
344,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
0,0,	345,0,	345,0,	345,0,	
0,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	345,25,	345,0,	
345,0,	345,0,	345,0,	345,0,	
345,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	345,0,	
345,0,	345,0,	345,0,	0,0,	
345,0,	0,0,	0,0,	0,0,	
0,0,	345,372,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	345,0,	
345,0,	345,0,	345,0,	345,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	0,0,	
346,0,	346,0,	346,0,	0,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	346,25,	346,0,	346,0,	
346,0,	346,0,	346,0,	346,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	346,0,	346,0,	
346,0,	346,0,	346,373,	346,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	346,0,	346,0,	
346,0,	346,0,	346,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	0,0,	347,0,	
347,0,	347,0,	0,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
347,25,	347,0,	347,0,	347,0,	
347,0,	347,0,	347,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	347,0,	347,0,	347,0,	
347,0,	0,0,	347,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	347,374,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	347,0,	347,0,	347,0,	
347,0,	347,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	0,0,	348,0,	348,0,	
348,0,	0,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	348,25,	
348,0,	348,0,	348,0,	348,0,	
348,0,	348,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
348,0,	348,0,	348,0,	348,0,	
348,375,	348,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
348,0,	348,0,	348,0,	348,0,	
348,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
0,0,	349,0,	349,0,	349,0,	
0,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	349,25,	349,0,	
349,0,	349,0,	349,0,	349,0,	
349,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	349,0,	
349,0,	349,0,	349,0,	0,0,	
349,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
349,376,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	349,0,	
349,0,	349,0,	349,0,	349,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	0,0,	
350,0,	350,0,	350,0,	0,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	350,25,	350,0,	350,0,	
350,0,	350,0,	350,0,	350,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	350,0,	350,0,	
350,0,	350,0,	0,0,	350,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	350,0,	350,0,	
350,0,	350,0,	350,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	0,0,	351,0,	
351,0,	351,0,	0,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
351,25,	351,0,	351,0,	351,0,	
351,0,	351,0,	351,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	351,0,	351,0,	351,0,	
351,0,	0,0,	351,0,	0,0,	
351,377,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	351,0,	351,0,	351,0,	
351,0,	351,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	0,0,	352,0,	352,0,	
352,0,	0,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	352,25,	
352,0,	352,0,	352,0,	352,0,	
352,0,	352,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
352,0,	352,0,	352,0,	352,0,	
352,378,	352,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
352,0,	352,0,	352,0,	352,0,	
352,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
0,0,	353,0,	353,0,	353,0,	
0,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	353,25,	353,0,	
353,0,	353,0,	353,0,	353,0,	
353,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	353,0,	
353,0,	353,0,	353,0,	0,0,	
353,0,	0,0,	0,0,	0,0,	
0,0,	353,379,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	353,0,	
353,0,	353,0,	353,0,	353,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	0,0,	
354,0,	354,0,	354,0,	0,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	354,25,	354,0,	354,0,	
354,0,	354,0,	354,0,	354,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	354,0,	354,0,	
354,0,	354,0,	0,0,	354,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	354,380,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	354,0,	354,0,	
354,0,	354,0,	354,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	0,0,	355,0,	
355,0,	355,0,	0,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
355,25,	355,0,	355,0,	355,0,	
355,0,	355,0,	355,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	355,0,	355,0,	355,0,	
355,0,	0,0,	355,0,	355,381,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	355,0,	355,0,	355,0,	
355,0,	355,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	0,0,	356,0,	356,0,	
356,0,	0,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	356,25,	
356,0,	356,0,	356,0,	356,0,	
356,0,	356,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
356,0,	356,0,	356,0,	356,0,	
356,382,	356,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
356,0,	356,0,	356,0,	356,0,	
356,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
0,0,	357,0,	357,0,	357,0,	
0,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	357,25,	357,0,	
357,0,	357,0,	357,0,	357,0,	
357,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	357,0,	
357,0,	357,0,	357,0,	0,0,	
357,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
357,383,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	357,0,	
357,0,	357,0,	357,0,	357,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	0,0,	
358,0,	358,0,	358,0,	0,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	358,25,	358,0,	358,0,	
358,0,	358,0,	358,0,	358,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	358,0,	358,0,	
358,0,	358,0,	358,384,	358,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	358,0,	358,0,	
358,0,	358,0,	358,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	0,0,	359,0,	
359,0,	359,0,	0,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
359,25,	359,0,	359,0,	359,0,	
359,0,	359,0,	359,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	359,0,	359,0,	359,0,	
359,0,	0,0,	359,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	359,385,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	359,0,	359,0,	359,0,	
359,0,	359,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	0,0,	360,0,	360,0,	
360,0,	0,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	360,25,	
360,0,	360,0,	360,0,	360,0,	
360,0,	360,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
360,0,	360,0,	360,0,	360,0,	
0,0,	360,0,	0,0,	0,0,	
0,0,	0,0,	360,386,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
360,0,	360,0,	360,0,	360,0,	
360,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
0,0,	361,0,	361,0,	361,0,	
0,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	361,25,	361,0,	
361,0,	361,0,	361,0,	361,0,	
361,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	361,0,	
361,0,	361,0,	361,0,	0,0,	
361,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	361,387,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	361,0,	
361,0,	361,0,	361,0,	361,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	0,0,	
362,0,	362,0,	362,0,	0,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	362,25,	362,0,	362,0,	
362,0,	362,0,	362,0,	362,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	362,0,	362,0,	
362,0,	362,0,	0,0,	362,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	362,388,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	362,0,	362,0,	
362,0,	362,0,	362,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	0,0,	363,0,	
363,0,	363,0,	0,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
363,25,	363,0,	363,0,	363,0,	
363,0,	363,0,	363,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	363,0,	363,0,	363,0,	
363,0,	0,0,	363,0,	363,389,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	363,0,	363,0,	363,0,	
363,0,	363,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	0,0,	364,0,	364,0,	
364,0,	0,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	364,25,	
364,0,	364,0,	364,0,	364,0,	
364,0,	364,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
364,0,	364,0,	364,0,	364,0,	
0,0,	364,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	364,390,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
364,0,	364,0,	364,0,	364,0,	
364,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
0,0,	365,0,	365,0,	365,0,	
0,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	365,25,	365,0,	
365,0,	365,0,	365,0,	365,0,	
365,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	365,0,	
365,0,	365,0,	365,0,	0,0,	
365,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	365,391,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	365,0,	
365,0,	365,0,	365,0,	365,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	0,0,	
366,0,	366,0,	366,0,	0,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	366,25,	366,0,	366,0,	
366,0,	366,0,	366,0,	366,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	366,0,	366,0,	
366,0,	366,0,	0,0,	366,0,	
0,0,	0,0,	0,0,	0,0,	
366,392,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	366,0,	366,0,	
366,0,	366,0,	366,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	0,0,	367,0,	
367,0,	367,0,	0,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
367,25,	367,0,	367,0,	367,0,	
367,0,	367,0,	367,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	367,0,	367,0,	367,0,	
367,0,	0,0,	367,0,	0,0,	
0,0,	0,0,	0,0,	367,393,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	367,0,	367,0,	367,0,	
367,0,	367,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	0,0,	368,0,	368,0,	
368,0,	0,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	368,25,	
368,0,	368,0,	368,0,	368,0,	
368,0,	368,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
368,0,	368,0,	368,0,	368,0,	
0,0,	368,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	368,394,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
368,0,	368,0,	368,0,	368,0,	
368,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
0,0,	369,0,	369,0,	369,0,	
0,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	369,25,	369,0,	
369,0,	369,0,	369,0,	369,0,	
369,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	369,0,	
369,0,	369,0,	369,0,	0,0,	
369,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	369,395,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	369,0,	
369,0,	369,0,	369,0,	369,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	0,0,	
370,0,	370,0,	370,0,	0,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	370,25,	370,0,	370,0,	
370,0,	370,0,	370,0,	370,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	370,0,	370,0,	
370,0,	370,0,	0,0,	370,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	370,396,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	370,0,	370,0,	
370,0,	370,0,	370,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	0,0,	371,0,	
371,0,	371,0,	0,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
371,25,	371,0,	371,0,	371,0,	
371,0,	371,0,	371,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	371,0,	371,0,	371,0,	
371,0,	0,0,	371,0,	0,0,	
0,0,	371,397,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	371,0,	371,0,	371,0,	
371,0,	371,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	0,0,	372,0,	372,0,	
372,0,	0,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	372,25,	
372,0,	372,0,	372,0,	372,0,	
372,0,	372,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
372,0,	372,0,	372,0,	372,0,	
0,0,	372,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	372,398,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
372,0,	372,0,	372,0,	372,0,	
372,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
0,0,	373,0,	373,0,	373,0,	
0,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	373,25,	373,0,	
373,0,	373,0,	373,0,	373,0,	
373,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	373,0,	
373,0,	373,0,	373,0,	0,0,	
373,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	373,399,	0,0,	
0,0,	0,0,	0,0,	373,0,	
373,0,	373,0,	373,0,	373,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	0,0,	
374,0,	374,0,	374,0,	0,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	374,25,	374,0,	374,0,	
374,0,	374,0,	374,0,	374,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	374,0,	374,0,	
374,0,	374,0,	0,0,	374,0,	
0,0,	0,0,	0,0,	0,0,	
374,400,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	374,0,	374,0,	
374,0,	374,0,	374,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	0,0,	375,0,	
375,0,	375,0,	0,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
375,25,	375,0,	375,0,	375,0,	
375,0,	375,0,	375,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	375,0,	375,0,	375,0,	
375,0,	0,0,	375,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
375,401,	0,0,	0,0,	0,0,	
0,0,	375,0,	375,0,	375,0,	
375,0,	375,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	0,0,	376,0,	376,0,	
376,0,	0,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	376,25,	
376,0,	376,0,	376,0,	376,0,	
376,0,	376,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
376,0,	376,0,	376,0,	376,0,	
0,0,	376,0,	0,0,	0,0,	
0,0,	0,0,	376,402,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
376,0,	376,0,	376,0,	376,0,	
376,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
0,0,	377,0,	377,0,	377,0,	
0,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	377,25,	377,0,	
377,0,	377,0,	377,0,	377,0,	
377,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	377,0,	
377,0,	377,0,	377,0,	0,0,	
377,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	377,403,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	377,0,	
377,0,	377,0,	377,0,	377,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	0,0,	
378,0,	378,0,	378,0,	0,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	378,25,	378,0,	378,0,	
378,0,	378,0,	378,0,	378,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	378,0,	378,0,	
378,0,	378,0,	0,0,	378,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	378,404,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	378,0,	378,0,	
378,0,	378,0,	378,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	0,0,	379,0,	
379,0,	379,0,	0,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
379,25,	379,0,	379,0,	379,0,	
379,0,	379,0,	379,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	379,0,	379,0,	379,0,	
379,0,	0,0,	379,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
379,405,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	379,0,	379,0,	379,0,	
379,0,	379,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	0,0,	380,0,	380,0,	
380,0,	0,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	380,25,	
380,0,	380,0,	380,0,	380,0,	
380,0,	380,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
380,0,	380,0,	380,0,	380,0,	
0,0,	380,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	380,406,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
380,0,	380,0,	380,0,	380,0,	
380,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
0,0,	381,0,	381,0,	381,0,	
0,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	381,25,	381,0,	
381,0,	381,0,	381,0,	381,0,	
381,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	381,0,	
381,0,	381,0,	381,0,	0,0,	
381,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
381,407,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	381,0,	
381,0,	381,0,	381,0,	381,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	0,0,	
382,0,	382,0,	382,0,	0,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	382,25,	382,0,	382,0,	
382,0,	382,0,	382,0,	382,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	382,0,	382,0,	
382,0,	382,0,	0,0,	382,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	382,408,	0,0,	0,0,	
0,0,	0,0,	382,0,	382,0,	
382,0,	382,0,	382,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	0,0,	383,0,	
383,0,	383,0,	0,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
383,25,	383,0,	383,0,	383,0,	
383,0,	383,0,	383,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	383,0,	383,0,	383,0,	
383,0,	0,0,	383,0,	0,0,	
0,0,	0,0,	0,0,	383,409,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	383,0,	383,0,	383,0,	
383,0,	383,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	0,0,	384,0,	384,0,	
384,0,	0,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	384,25,	
384,0,	384,0,	384,0,	384,0,	
384,0,	384,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
384,0,	384,0,	384,0,	384,0,	
0,0,	384,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	384,410,	
0,0,	0,0,	0,0,	0,0,	
384,0,	384,0,	384,0,	384,0,	
384,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
0,0,	385,0,	385,0,	385,0,	
0,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	385,25,	385,0,	
385,0,	385,0,	385,0,	385,0,	
385,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	385,0,	
385,0,	385,0,	385,0,	0,0,	
385,0,	0,0,	0,0,	0,0,	
0,0,	385,411,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	385,0,	
385,0,	385,0,	385,0,	385,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	0,0,	
386,0,	386,0,	386,0,	0,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	386,25,	386,0,	386,0,	
386,0,	386,0,	386,0,	386,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	386,0,	386,0,	
386,0,	386,0,	0,0,	386,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	386,0,	386,0,	
386,0,	386,0,	386,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	0,0,	387,0,	
387,0,	387,0,	0,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
387,25,	387,0,	387,0,	387,0,	
387,0,	387,0,	387,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	387,0,	387,0,	387,0,	
387,0,	0,0,	387,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	387,412,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	387,0,	387,0,	387,0,	
387,0,	387,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	0,0,	388,0,	388,0,	
388,0,	0,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	388,25,	
388,0,	388,0,	388,0,	388,0,	
388,0,	388,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
388,0,	388,0,	388,0,	388,0,	
0,0,	388,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
388,413,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
388,0,	388,0,	388,0,	388,0,	
388,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
0,0,	389,0,	389,0,	389,0,	
0,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	389,25,	389,0,	
389,0,	389,0,	389,0,	389,0,	
389,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	389,0,	
389,0,	389,0,	389,0,	0,0,	
389,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	389,414,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	389,0,	
389,0,	389,0,	389,0,	389,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	0,0,	
390,0,	390,0,	390,0,	0,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	390,25,	390,0,	390,0,	
390,0,	390,0,	390,0,	390,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	390,0,	390,0,	
390,0,	390,0,	0,0,	390,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
390,415,	0,0,	0,0,	0,0,	
0,0,	0,0,	390,0,	390,0,	
390,0,	390,0,	390,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	0,0,	391,0,	
391,0,	391,0,	0,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
391,25,	391,0,	391,0,	391,0,	
391,0,	391,0,	391,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	391,0,	391,0,	391,0,	
391,0,	0,0,	391,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	391,416,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	391,0,	391,0,	391,0,	
391,0,	391,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	0,0,	392,0,	392,0,	
392,0,	0,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	392,25,	
392,0,	392,0,	392,0,	392,0,	
392,0,	392,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
392,0,	392,0,	392,0,	392,0,	
392,417,	392,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
392,0,	392,0,	392,0,	392,0,	
392,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
0,0,	393,0,	393,0,	393,0,	
0,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	393,25,	393,0,	
393,0,	393,0,	393,0,	393,0,	
393,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	393,0,	
393,0,	393,0,	393,0,	0,0,	
393,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	393,0,	
393,0,	393,0,	393,0,	393,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	0,0,	
394,0,	394,0,	394,0,	0,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	394,25,	394,0,	394,0,	
394,0,	394,0,	394,0,	394,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	394,0,	394,0,	
394,0,	394,0,	0,0,	394,0,	
0,0,	0,0,	0,0,	0,0,	
394,418,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	394,0,	394,0,	
394,0,	394,0,	394,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	0,0,	395,0,	
395,0,	395,0,	0,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
395,25,	395,0,	395,0,	395,0,	
395,0,	395,0,	395,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	395,0,	395,0,	395,0,	
395,0,	0,0,	395,0,	0,0,	
395,419,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	395,0,	395,0,	395,0,	
395,0,	395,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	0,0,	396,0,	396,0,	
396,0,	0,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	396,25,	
396,0,	396,0,	396,0,	396,0,	
396,0,	396,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
396,0,	396,0,	396,0,	396,0,	
0,0,	396,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
396,420,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
396,0,	396,0,	396,0,	396,0,	
396,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
0,0,	397,0,	397,0,	397,0,	
0,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	397,25,	397,0,	
397,0,	397,0,	397,0,	397,0,	
397,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	397,0,	
397,0,	397,0,	397,0,	0,0,	
397,0,	397,421,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	397,0,	
397,0,	397,0,	397,0,	397,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	0,0,	
398,0,	398,0,	398,0,	0,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	398,25,	398,0,	398,0,	
398,0,	398,0,	398,0,	398,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	398,0,	398,0,	
398,0,	398,0,	0,0,	398,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	398,0,	398,0,	
398,0,	398,0,	398,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	0,0,	399,0,	
399,0,	399,0,	0,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
399,25,	399,0,	399,0,	399,0,	
399,0,	399,0,	399,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	399,0,	399,0,	399,0,	
399,0,	0,0,	399,0,	399,422,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	399,0,	399,0,	399,0,	
399,0,	399,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	0,0,	400,0,	400,0,	
400,0,	0,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	400,25,	
400,0,	400,0,	400,0,	400,0,	
400,0,	400,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
400,0,	400,0,	400,0,	400,0,	
0,0,	400,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
400,0,	400,0,	400,0,	400,0,	
400,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
0,0,	401,0,	401,0,	401,0,	
0,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	401,25,	401,0,	
401,0,	401,0,	401,0,	401,0,	
401,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	401,0,	
401,0,	401,0,	401,0,	0,0,	
401,0,	401,423,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	401,0,	
401,0,	401,0,	401,0,	401,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	0,0,	
402,0,	402,0,	402,0,	0,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	402,25,	402,0,	402,0,	
402,0,	402,0,	402,0,	402,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	402,0,	402,0,	
402,0,	402,0,	0,0,	402,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	402,0,	402,0,	
402,0,	402,0,	402,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	0,0,	403,0,	
403,0,	403,0,	0,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
403,25,	403,0,	403,0,	403,0,	
403,0,	403,0,	403,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,0,	403,0,	403,0,	
403,0,	0,0,	403,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	403,424,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	403,0,	403,0,	403,0,	
403,0,	403,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	0,0,	404,0,	404,0,	
404,0,	0,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	404,25,	
404,0,	404,0,	404,0,	404,0,	
404,0,	404,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
404,0,	404,0,	404,0,	404,0,	
0,0,	404,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	404,425,	0,0,	
0,0,	0,0,	0,0,	0,0,	
404,0,	404,0,	404,0,	404,0,	
404,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
0,0,	405,0,	405,0,	405,0,	
0,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	405,25,	405,0,	
405,0,	405,0,	405,0,	405,0,	
405,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	405,0,	
405,0,	405,0,	405,0,	0,0,	
405,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	405,0,	
405,0,	405,0,	405,0,	405,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	0,0,	
406,0,	406,0,	406,0,	0,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	406,25,	406,0,	406,0,	
406,0,	406,0,	406,0,	406,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	406,0,	406,0,	
406,0,	406,0,	0,0,	406,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	406,426,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	406,0,	406,0,	
406,0,	406,0,	406,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	0,0,	407,0,	
407,0,	407,0,	0,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
407,25,	407,0,	407,0,	407,0,	
407,0,	407,0,	407,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	407,0,	407,0,	407,0,	
407,0,	0,0,	407,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	407,427,	
0,0,	0,0,	0,0,	0,0,	
0,0,	407,0,	407,0,	407,0,	
407,0,	407,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	0,0,	408,0,	408,0,	
408,0,	0,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	408,25,	
408,0,	408,0,	408,0,	408,0,	
408,0,	408,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
408,0,	408,0,	408,0,	408,0,	
0,0,	408,0,	408,428,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
408,0,	408,0,	408,0,	408,0,	
408,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
0,0,	409,0,	409,0,	409,0,	
0,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	409,25,	409,0,	
409,0,	409,0,	409,0,	409,0,	
409,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	409,0,	
409,0,	409,0,	409,0,	0,0,	
409,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	409,0,	
409,0,	409,0,	409,0,	409,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	0,0,	
410,0,	410,0,	410,0,	0,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	410,25,	410,0,	410,0,	
410,0,	410,0,	410,0,	410,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	410,0,	410,0,	
410,0,	410,0,	0,0,	410,0,	
410,429,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	410,0,	410,0,	
410,0,	410,0,	410,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	0,0,	411,0,	
411,0,	411,0,	0,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
411,25,	411,0,	411,0,	411,0,	
411,0,	411,0,	411,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	411,0,	411,0,	411,0,	
411,0,	0,0,	411,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	411,0,	411,0,	411,0,	
411,0,	411,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	0,0,	412,0,	412,0,	
412,0,	0,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	412,25,	
412,0,	412,0,	412,0,	412,0,	
412,0,	412,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
412,0,	412,0,	412,0,	412,0,	
0,0,	412,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	412,430,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
412,0,	412,0,	412,0,	412,0,	
412,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
0,0,	413,0,	413,0,	413,0,	
0,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	413,25,	413,0,	
413,0,	413,0,	413,0,	413,0,	
413,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	413,0,	
413,0,	413,0,	413,0,	0,0,	
413,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
413,431,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	413,0,	
413,0,	413,0,	413,0,	413,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	0,0,	
414,0,	414,0,	414,0,	0,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	414,25,	414,0,	414,0,	
414,0,	414,0,	414,0,	414,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	414,0,	414,0,	
414,0,	414,0,	0,0,	414,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	414,432,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	414,0,	414,0,	
414,0,	414,0,	414,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	0,0,	415,0,	
415,0,	415,0,	0,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
415,25,	415,0,	415,0,	415,0,	
415,0,	415,0,	415,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	415,0,	415,0,	415,0,	
415,0,	0,0,	415,0,	0,0,	
0,0,	415,433,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	415,0,	415,0,	415,0,	
415,0,	415,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	0,0,	416,0,	416,0,	
416,0,	0,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	416,25,	
416,0,	416,0,	416,0,	416,0,	
416,0,	416,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
416,0,	416,0,	416,0,	416,0,	
0,0,	416,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
416,0,	416,0,	416,0,	416,0,	
416,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
0,0,	417,0,	417,0,	417,0,	
0,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	417,25,	417,0,	
417,0,	417,0,	417,0,	417,0,	
417,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	417,0,	
417,0,	417,0,	417,0,	0,0,	
417,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	417,434,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	417,0,	
417,0,	417,0,	417,0,	417,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	0,0,	
418,0,	418,0,	418,0,	0,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	418,25,	418,0,	418,0,	
418,0,	418,0,	418,0,	418,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	418,0,	418,0,	
418,0,	418,0,	0,0,	418,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	418,435,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	418,0,	418,0,	
418,0,	418,0,	418,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	0,0,	419,0,	
419,0,	419,0,	0,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
419,25,	419,0,	419,0,	419,0,	
419,0,	419,0,	419,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	419,0,	419,0,	419,0,	
419,0,	0,0,	419,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	419,436,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	419,0,	419,0,	419,0,	
419,0,	419,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	0,0,	420,0,	420,0,	
420,0,	0,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	420,25,	
420,0,	420,0,	420,0,	420,0,	
420,0,	420,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
420,0,	420,0,	420,0,	420,0,	
0,0,	420,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
420,0,	420,0,	420,0,	420,0,	
420,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
0,0,	421,0,	421,0,	421,0,	
0,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	421,25,	421,0,	
421,0,	421,0,	421,0,	421,0,	
421,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	421,0,	
421,0,	421,0,	421,0,	0,0,	
421,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
421,437,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	421,0,	
421,0,	421,0,	421,0,	421,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	0,0,	
424,0,	424,0,	424,0,	0,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	424,25,	424,0,	424,0,	
424,0,	424,0,	424,0,	424,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	424,0,	424,0,	
424,0,	424,0,	0,0,	424,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
424,442,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	424,0,	424,0,	
424,0,	424,0,	424,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	0,0,	425,0,	
425,0,	425,0,	0,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
425,25,	425,0,	425,0,	425,0,	
425,0,	425,0,	425,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	425,0,	425,0,	425,0,	
425,0,	0,0,	425,0,	0,0,	
425,443,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	425,0,	425,0,	425,0,	
425,0,	425,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	0,0,	426,0,	426,0,	
426,0,	0,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	426,25,	
426,0,	426,0,	426,0,	426,0,	
426,0,	426,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
426,0,	426,0,	426,0,	426,0,	
0,0,	426,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	426,444,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
426,0,	426,0,	426,0,	426,0,	
426,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
0,0,	427,0,	427,0,	427,0,	
0,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	427,25,	427,0,	
427,0,	427,0,	427,0,	427,0,	
427,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	427,0,	
427,0,	427,0,	427,0,	0,0,	
427,0,	0,0,	0,0,	0,0,	
0,0,	427,445,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	427,0,	
427,0,	427,0,	427,0,	427,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	0,0,	
430,0,	430,0,	430,0,	0,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	430,25,	430,0,	430,0,	
430,0,	430,0,	430,0,	430,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	430,0,	430,0,	
430,0,	430,0,	0,0,	430,0,	
0,0,	0,0,	0,0,	0,0,	
430,450,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	430,0,	430,0,	
430,0,	430,0,	430,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	0,0,	431,0,	
431,0,	431,0,	0,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
431,25,	431,0,	431,0,	431,0,	
431,0,	431,0,	431,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	431,0,	431,0,	431,0,	
431,0,	0,0,	431,0,	431,451,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	431,0,	431,0,	431,0,	
431,0,	431,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	0,0,	432,0,	432,0,	
432,0,	0,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	432,25,	
432,0,	432,0,	432,0,	432,0,	
432,0,	432,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
432,0,	432,0,	432,0,	432,0,	
0,0,	432,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	432,452,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
432,0,	432,0,	432,0,	432,0,	
432,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
0,0,	433,0,	433,0,	433,0,	
0,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	433,25,	433,0,	
433,0,	433,0,	433,0,	433,0,	
433,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	433,0,	
433,0,	433,0,	433,0,	0,0,	
433,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
433,453,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	433,0,	
433,0,	433,0,	433,0,	433,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	0,0,	
434,0,	434,0,	434,0,	0,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	434,25,	434,0,	434,0,	
434,0,	434,0,	434,0,	434,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	434,0,	434,0,	
434,0,	434,0,	0,0,	434,0,	
434,454,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	434,0,	434,0,	
434,0,	434,0,	434,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	0,0,	435,0,	
435,0,	435,0,	0,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
435,25,	435,0,	435,0,	435,0,	
435,0,	435,0,	435,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	435,0,	435,0,	435,0,	
435,0,	0,0,	435,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	435,455,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	435,0,	435,0,	435,0,	
435,0,	435,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	0,0,	436,0,	436,0,	
436,0,	0,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	436,25,	
436,0,	436,0,	436,0,	436,0,	
436,0,	436,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
436,0,	436,0,	436,0,	436,0,	
0,0,	436,0,	0,0,	0,0,	
0,0,	0,0,	436,456,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
436,0,	436,0,	436,0,	436,0,	
436,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
0,0,	437,0,	437,0,	437,0,	
0,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	437,25,	437,0,	
437,0,	437,0,	437,0,	437,0,	
437,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	437,0,	
437,0,	437,0,	437,0,	0,0,	
437,0,	0,0,	0,0,	0,0,	
0,0,	437,457,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	437,0,	
437,0,	437,0,	437,0,	437,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	0,0,	
438,0,	438,0,	438,0,	0,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	438,25,	438,0,	438,0,	
438,0,	438,0,	438,0,	438,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	438,0,	438,0,	
438,0,	438,0,	0,0,	438,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
438,458,	0,0,	0,0,	0,0,	
0,0,	0,0,	438,0,	438,0,	
438,0,	438,0,	438,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	0,0,	439,0,	
439,0,	439,0,	0,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
439,25,	439,0,	439,0,	439,0,	
439,0,	439,0,	439,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	439,0,	439,0,	439,0,	
439,0,	0,0,	439,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	439,459,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	439,0,	439,0,	439,0,	
439,0,	439,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	0,0,	440,0,	440,0,	
440,0,	0,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	440,25,	
440,0,	440,0,	440,0,	440,0,	
440,0,	440,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
440,0,	440,0,	440,0,	440,0,	
0,0,	440,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	440,460,	0,0,	
0,0,	0,0,	0,0,	0,0,	
440,0,	440,0,	440,0,	440,0,	
440,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
0,0,	441,0,	441,0,	441,0,	
0,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	441,25,	441,0,	
441,0,	441,0,	441,0,	441,0,	
441,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	441,0,	
441,0,	441,0,	441,0,	0,0,	
441,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	441,461,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	441,0,	
441,0,	441,0,	441,0,	441,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	0,0,	
442,0,	442,0,	442,0,	0,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	442,25,	442,0,	442,0,	
442,0,	442,0,	442,0,	442,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	442,0,	442,0,	
442,0,	442,0,	0,0,	442,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	442,462,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	442,0,	442,0,	
442,0,	442,0,	442,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	0,0,	443,0,	
443,0,	443,0,	0,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
443,25,	443,0,	443,0,	443,0,	
443,0,	443,0,	443,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	443,0,	443,0,	443,0,	
443,0,	0,0,	443,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	443,463,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	443,0,	443,0,	443,0,	
443,0,	443,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	0,0,	444,0,	444,0,	
444,0,	0,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	444,25,	
444,0,	444,0,	444,0,	444,0,	
444,0,	444,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
444,0,	444,0,	444,0,	444,0,	
444,464,	444,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
444,0,	444,0,	444,0,	444,0,	
444,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
0,0,	445,0,	445,0,	445,0,	
0,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	445,25,	445,0,	
445,0,	445,0,	445,0,	445,0,	
445,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	445,0,	
445,0,	445,0,	445,0,	0,0,	
445,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	445,0,	
445,0,	445,0,	445,0,	445,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	0,0,	
446,0,	446,0,	446,0,	0,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	446,25,	446,0,	446,0,	
446,0,	446,0,	446,0,	446,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	446,0,	446,0,	
446,0,	446,0,	0,0,	446,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
446,465,	0,0,	0,0,	0,0,	
0,0,	0,0,	446,0,	446,0,	
446,0,	446,0,	446,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	0,0,	447,0,	
447,0,	447,0,	0,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
447,25,	447,0,	447,0,	447,0,	
447,0,	447,0,	447,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	447,0,	447,0,	447,0,	
447,0,	0,0,	447,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	447,466,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	447,0,	447,0,	447,0,	
447,0,	447,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	0,0,	448,0,	448,0,	
448,0,	0,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	448,25,	
448,0,	448,0,	448,0,	448,0,	
448,0,	448,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
448,0,	448,0,	448,0,	448,0,	
0,0,	448,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	448,467,	0,0,	
0,0,	0,0,	0,0,	0,0,	
448,0,	448,0,	448,0,	448,0,	
448,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
0,0,	449,0,	449,0,	449,0,	
0,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	449,25,	449,0,	
449,0,	449,0,	449,0,	449,0,	
449,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	449,0,	
449,0,	449,0,	449,0,	0,0,	
449,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	449,468,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	449,0,	
449,0,	449,0,	449,0,	449,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	0,0,	
450,0,	450,0,	450,0,	0,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	450,25,	450,0,	450,0,	
450,0,	450,0,	450,0,	450,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	450,0,	450,0,	
450,0,	450,0,	0,0,	450,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	450,469,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	450,0,	450,0,	
450,0,	450,0,	450,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	0,0,	451,0,	
451,0,	451,0,	0,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
451,25,	451,0,	451,0,	451,0,	
451,0,	451,0,	451,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	451,0,	451,0,	451,0,	
451,0,	0,0,	451,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
451,470,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	451,0,	451,0,	451,0,	
451,0,	451,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	0,0,	452,0,	452,0,	
452,0,	0,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	452,25,	
452,0,	452,0,	452,0,	452,0,	
452,0,	452,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
452,0,	452,0,	452,0,	452,0,	
0,0,	452,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	452,471,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
452,0,	452,0,	452,0,	452,0,	
452,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
0,0,	453,0,	453,0,	453,0,	
0,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	453,25,	453,0,	
453,0,	453,0,	453,0,	453,0,	
453,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	453,0,	
453,0,	453,0,	453,0,	0,0,	
453,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	453,472,	0,0,	0,0,	
0,0,	0,0,	0,0,	453,0,	
453,0,	453,0,	453,0,	453,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	0,0,	
454,0,	454,0,	454,0,	0,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	454,25,	454,0,	454,0,	
454,0,	454,0,	454,0,	454,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,0,	454,0,	
454,0,	454,0,	0,0,	454,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
454,473,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	454,0,	454,0,	
454,0,	454,0,	454,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	0,0,	455,0,	
455,0,	455,0,	0,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
455,25,	455,0,	455,0,	455,0,	
455,0,	455,0,	455,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	455,0,	455,0,	455,0,	
455,0,	0,0,	455,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	455,474,	
0,0,	455,0,	455,0,	455,0,	
455,0,	455,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	0,0,	456,0,	456,0,	
456,0,	0,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	456,25,	
456,0,	456,0,	456,0,	456,0,	
456,0,	456,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
456,0,	456,0,	456,0,	456,0,	
0,0,	456,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	456,475,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
456,0,	456,0,	456,0,	456,0,	
456,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
0,0,	457,0,	457,0,	457,0,	
0,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	457,25,	457,0,	
457,0,	457,0,	457,0,	457,0,	
457,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	457,0,	
457,0,	457,0,	457,0,	0,0,	
457,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	457,0,	
457,0,	457,0,	457,0,	457,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	0,0,	
458,0,	458,0,	458,0,	0,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	458,25,	458,0,	458,0,	
458,0,	458,0,	458,0,	458,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	458,0,	458,0,	
458,0,	458,0,	0,0,	458,0,	
0,0,	0,0,	0,0,	0,0,	
458,476,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	458,0,	458,0,	
458,0,	458,0,	458,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	0,0,	459,0,	
459,0,	459,0,	0,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
459,25,	459,0,	459,0,	459,0,	
459,0,	459,0,	459,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	459,0,	459,0,	459,0,	
459,0,	0,0,	459,0,	459,477,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	459,0,	459,0,	459,0,	
459,0,	459,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	0,0,	460,0,	460,0,	
460,0,	0,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	460,25,	
460,0,	460,0,	460,0,	460,0,	
460,0,	460,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
460,0,	460,0,	460,0,	460,0,	
0,0,	460,0,	0,0,	0,0,	
0,0,	0,0,	460,478,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
460,0,	460,0,	460,0,	460,0,	
460,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
0,0,	461,0,	461,0,	461,0,	
0,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	461,25,	461,0,	
461,0,	461,0,	461,0,	461,0,	
461,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	461,0,	
461,0,	461,0,	461,0,	0,0,	
461,0,	461,479,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	461,0,	
461,0,	461,0,	461,0,	461,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	0,0,	
462,0,	462,0,	462,0,	0,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	462,25,	462,0,	462,0,	
462,0,	462,0,	462,0,	462,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	462,0,	462,0,	
462,0,	462,0,	0,0,	462,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
462,480,	0,0,	0,0,	0,0,	
0,0,	0,0,	462,0,	462,0,	
462,0,	462,0,	462,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	0,0,	463,0,	
463,0,	463,0,	0,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
463,25,	463,0,	463,0,	463,0,	
463,0,	463,0,	463,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	463,0,	463,0,	463,0,	
463,0,	0,0,	463,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	463,481,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	463,0,	463,0,	463,0,	
463,0,	463,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	0,0,	464,0,	464,0,	
464,0,	0,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	464,25,	
464,0,	464,0,	464,0,	464,0,	
464,0,	464,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
464,0,	464,0,	464,0,	464,0,	
0,0,	464,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
464,482,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
464,0,	464,0,	464,0,	464,0,	
464,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
0,0,	465,0,	465,0,	465,0,	
0,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	465,25,	465,0,	
465,0,	465,0,	465,0,	465,0,	
465,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	465,0,	
465,0,	465,0,	465,0,	0,0,	
465,0,	0,0,	0,0,	0,0,	
0,0,	465,483,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	465,0,	
465,0,	465,0,	465,0,	465,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	0,0,	
466,0,	466,0,	466,0,	0,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	466,25,	466,0,	466,0,	
466,0,	466,0,	466,0,	466,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	466,0,	466,0,	
466,0,	466,0,	0,0,	466,0,	
466,484,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	466,0,	466,0,	
466,0,	466,0,	466,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	0,0,	467,0,	
467,0,	467,0,	0,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
467,25,	467,0,	467,0,	467,0,	
467,0,	467,0,	467,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	467,0,	467,0,	467,0,	
467,0,	0,0,	467,0,	0,0,	
0,0,	0,0,	0,0,	467,485,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	467,0,	467,0,	467,0,	
467,0,	467,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	0,0,	468,0,	468,0,	
468,0,	0,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	468,25,	
468,0,	468,0,	468,0,	468,0,	
468,0,	468,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
468,0,	468,0,	468,0,	468,0,	
0,0,	468,0,	468,486,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
468,0,	468,0,	468,0,	468,0,	
468,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
0,0,	469,0,	469,0,	469,0,	
0,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	469,25,	469,0,	
469,0,	469,0,	469,0,	469,0,	
469,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	469,0,	
469,0,	469,0,	469,0,	0,0,	
469,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
469,487,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	469,0,	
469,0,	469,0,	469,0,	469,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	0,0,	
470,0,	470,0,	470,0,	0,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	470,25,	470,0,	470,0,	
470,0,	470,0,	470,0,	470,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	470,0,	470,0,	
470,0,	470,0,	0,0,	470,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	470,488,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	470,0,	470,0,	
470,0,	470,0,	470,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	0,0,	471,0,	
471,0,	471,0,	0,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
471,25,	471,0,	471,0,	471,0,	
471,0,	471,0,	471,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	471,0,	471,0,	471,0,	
471,0,	0,0,	471,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	471,489,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	471,0,	471,0,	471,0,	
471,0,	471,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	0,0,	472,0,	472,0,	
472,0,	0,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	472,25,	
472,0,	472,0,	472,0,	472,0,	
472,0,	472,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
472,0,	472,0,	472,0,	472,0,	
0,0,	472,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	472,490,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
472,0,	472,0,	472,0,	472,0,	
472,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
0,0,	473,0,	473,0,	473,0,	
0,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	473,25,	473,0,	
473,0,	473,0,	473,0,	473,0,	
473,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	473,0,	
473,0,	473,0,	473,0,	0,0,	
473,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
473,491,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	473,0,	
473,0,	473,0,	473,0,	473,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	0,0,	
474,0,	474,0,	474,0,	0,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	474,25,	474,0,	474,0,	
474,0,	474,0,	474,0,	474,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	474,0,	474,0,	
474,0,	474,0,	0,0,	474,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	474,0,	474,0,	
474,0,	474,0,	474,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	0,0,	475,0,	
475,0,	475,0,	0,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
475,25,	475,0,	475,0,	475,0,	
475,0,	475,0,	475,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	475,0,	475,0,	475,0,	
475,0,	0,0,	475,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	475,492,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	475,0,	475,0,	475,0,	
475,0,	475,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	0,0,	476,0,	476,0,	
476,0,	0,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	476,25,	
476,0,	476,0,	476,0,	476,0,	
476,0,	476,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
476,0,	476,0,	476,0,	476,0,	
0,0,	476,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
476,0,	476,0,	476,0,	476,0,	
476,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
0,0,	477,0,	477,0,	477,0,	
0,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	477,25,	477,0,	
477,0,	477,0,	477,0,	477,0,	
477,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	477,0,	
477,0,	477,0,	477,0,	0,0,	
477,0,	0,0,	477,493,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	477,0,	
477,0,	477,0,	477,0,	477,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	0,0,	
478,0,	478,0,	478,0,	0,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	478,25,	478,0,	478,0,	
478,0,	478,0,	478,0,	478,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	478,0,	478,0,	
478,0,	478,0,	0,0,	478,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	478,0,	478,0,	
478,0,	478,0,	478,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	0,0,	479,0,	
479,0,	479,0,	0,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
479,25,	479,0,	479,0,	479,0,	
479,0,	479,0,	479,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,0,	479,0,	479,0,	
479,0,	0,0,	479,0,	0,0,	
479,494,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	479,0,	479,0,	479,0,	
479,0,	479,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	0,0,	480,0,	480,0,	
480,0,	0,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	480,25,	
480,0,	480,0,	480,0,	480,0,	
480,0,	480,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
480,0,	480,0,	480,0,	480,0,	
0,0,	480,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	480,495,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
480,0,	480,0,	480,0,	480,0,	
480,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
0,0,	481,0,	481,0,	481,0,	
0,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	481,25,	481,0,	
481,0,	481,0,	481,0,	481,0,	
481,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	481,0,	
481,0,	481,0,	481,0,	0,0,	
481,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	481,496,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	481,0,	
481,0,	481,0,	481,0,	481,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	0,0,	
482,0,	482,0,	482,0,	0,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	482,25,	482,0,	482,0,	
482,0,	482,0,	482,0,	482,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	482,0,	482,0,	
482,0,	482,0,	0,0,	482,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	482,497,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	482,0,	482,0,	
482,0,	482,0,	482,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	0,0,	483,0,	
483,0,	483,0,	0,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
483,25,	483,0,	483,0,	483,0,	
483,0,	483,0,	483,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	483,0,	483,0,	483,0,	
483,0,	0,0,	483,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	483,0,	483,0,	483,0,	
483,0,	483,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	0,0,	484,0,	484,0,	
484,0,	0,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	484,25,	
484,0,	484,0,	484,0,	484,0,	
484,0,	484,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
484,0,	484,0,	484,0,	484,0,	
0,0,	484,0,	0,0,	484,498,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
484,0,	484,0,	484,0,	484,0,	
484,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
0,0,	485,0,	485,0,	485,0,	
0,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	485,25,	485,0,	
485,0,	485,0,	485,0,	485,0,	
485,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	485,0,	
485,0,	485,0,	485,0,	0,0,	
485,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	485,0,	
485,0,	485,0,	485,0,	485,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	0,0,	
486,0,	486,0,	486,0,	0,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	486,25,	486,0,	486,0,	
486,0,	486,0,	486,0,	486,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	486,0,	486,0,	
486,0,	486,0,	0,0,	486,0,	
0,0,	486,499,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	486,0,	486,0,	
486,0,	486,0,	486,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	0,0,	487,0,	
487,0,	487,0,	0,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
487,25,	487,0,	487,0,	487,0,	
487,0,	487,0,	487,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	487,0,	487,0,	487,0,	
487,0,	0,0,	487,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	487,500,	
0,0,	487,0,	487,0,	487,0,	
487,0,	487,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	0,0,	488,0,	488,0,	
488,0,	0,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	488,25,	
488,0,	488,0,	488,0,	488,0,	
488,0,	488,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
488,0,	488,0,	488,0,	488,0,	
0,0,	488,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
488,0,	488,0,	488,0,	488,0,	
488,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
0,0,	489,0,	489,0,	489,0,	
0,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	489,25,	489,0,	
489,0,	489,0,	489,0,	489,0,	
489,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	489,0,	
489,0,	489,0,	489,0,	0,0,	
489,0,	0,0,	0,0,	0,0,	
0,0,	489,501,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	489,0,	
489,0,	489,0,	489,0,	489,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	0,0,	
490,0,	490,0,	490,0,	0,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	490,25,	490,0,	490,0,	
490,0,	490,0,	490,0,	490,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	490,0,	490,0,	
490,0,	490,0,	0,0,	490,0,	
0,0,	0,0,	0,0,	0,0,	
490,502,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	490,0,	490,0,	
490,0,	490,0,	490,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	0,0,	491,0,	
491,0,	491,0,	0,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
491,25,	491,0,	491,0,	491,0,	
491,0,	491,0,	491,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	491,0,	491,0,	491,0,	
491,0,	0,0,	491,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	491,0,	491,0,	491,0,	
491,0,	491,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	0,0,	492,0,	492,0,	
492,0,	0,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	492,25,	
492,0,	492,0,	492,0,	492,0,	
492,0,	492,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
492,0,	492,0,	492,0,	492,0,	
0,0,	492,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
492,0,	492,0,	492,0,	492,0,	
492,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
0,0,	493,0,	493,0,	493,0,	
0,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	493,25,	493,0,	
493,0,	493,0,	493,0,	493,0,	
493,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	493,0,	
493,0,	493,0,	493,0,	0,0,	
493,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
493,503,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	493,0,	
493,0,	493,0,	493,0,	493,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	0,0,	
494,0,	494,0,	494,0,	0,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	494,25,	494,0,	494,0,	
494,0,	494,0,	494,0,	494,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	494,0,	494,0,	
494,0,	494,0,	0,0,	494,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	494,504,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	494,0,	494,0,	
494,0,	494,0,	494,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	0,0,	495,0,	
495,0,	495,0,	0,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
495,25,	495,0,	495,0,	495,0,	
495,0,	495,0,	495,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,0,	495,0,	495,0,	
495,0,	0,0,	495,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	495,505,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	495,0,	495,0,	495,0,	
495,0,	495,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	0,0,	496,0,	496,0,	
496,0,	0,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	496,25,	
496,0,	496,0,	496,0,	496,0,	
496,0,	496,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
496,0,	496,0,	496,0,	496,0,	
0,0,	496,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	496,506,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
496,0,	496,0,	496,0,	496,0,	
496,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
0,0,	497,0,	497,0,	497,0,	
0,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	497,25,	497,0,	
497,0,	497,0,	497,0,	497,0,	
497,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	497,0,	
497,0,	497,0,	497,0,	0,0,	
497,0,	0,0,	0,0,	0,0,	
0,0,	497,507,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	497,0,	
497,0,	497,0,	497,0,	497,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	0,0,	
498,0,	498,0,	498,0,	0,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	498,25,	498,0,	498,0,	
498,0,	498,0,	498,0,	498,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	498,0,	498,0,	
498,0,	498,0,	0,0,	498,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	498,508,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	498,0,	498,0,	
498,0,	498,0,	498,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	0,0,	499,0,	
499,0,	499,0,	0,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
499,25,	499,0,	499,0,	499,0,	
499,0,	499,0,	499,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	499,0,	499,0,	499,0,	
499,0,	0,0,	499,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	499,509,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	499,0,	499,0,	499,0,	
499,0,	499,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	0,0,	500,0,	500,0,	
500,0,	0,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	500,25,	
500,0,	500,0,	500,0,	500,0,	
500,0,	500,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
500,0,	500,0,	500,0,	500,0,	
0,0,	500,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
500,0,	500,0,	500,0,	500,0,	
500,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
0,0,	501,0,	501,0,	501,0,	
0,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	501,25,	501,0,	
501,0,	501,0,	501,0,	501,0,	
501,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	501,0,	
501,0,	501,0,	501,0,	0,0,	
501,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	501,510,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	501,0,	
501,0,	501,0,	501,0,	501,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	0,0,	
502,0,	502,0,	502,0,	0,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	502,25,	502,0,	502,0,	
502,0,	502,0,	502,0,	502,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	502,0,	502,0,	
502,0,	502,0,	0,0,	502,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	502,0,	502,0,	
502,0,	502,0,	502,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	0,0,	503,0,	
503,0,	503,0,	0,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
503,25,	503,0,	503,0,	503,0,	
503,0,	503,0,	503,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	503,0,	503,0,	503,0,	
503,0,	0,0,	503,0,	0,0,	
0,0,	0,0,	0,0,	503,511,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	503,0,	503,0,	503,0,	
503,0,	503,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	0,0,	504,0,	504,0,	
504,0,	0,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	504,25,	
504,0,	504,0,	504,0,	504,0,	
504,0,	504,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
504,0,	504,0,	504,0,	504,0,	
0,0,	504,0,	0,0,	0,0,	
0,0,	0,0,	504,512,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
504,0,	504,0,	504,0,	504,0,	
504,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
0,0,	505,0,	505,0,	505,0,	
0,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	505,25,	505,0,	
505,0,	505,0,	505,0,	505,0,	
505,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	505,0,	
505,0,	505,0,	505,0,	0,0,	
505,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	505,513,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	505,0,	
505,0,	505,0,	505,0,	505,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	0,0,	
506,0,	506,0,	506,0,	0,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	506,25,	506,0,	506,0,	
506,0,	506,0,	506,0,	506,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	506,0,	506,0,	
506,0,	506,0,	0,0,	506,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
506,514,	0,0,	0,0,	0,0,	
0,0,	0,0,	506,0,	506,0,	
506,0,	506,0,	506,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	0,0,	507,0,	
507,0,	507,0,	0,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
507,25,	507,0,	507,0,	507,0,	
507,0,	507,0,	507,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	507,0,	507,0,	507,0,	
507,0,	0,0,	507,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
507,515,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	507,0,	507,0,	507,0,	
507,0,	507,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	0,0,	508,0,	508,0,	
508,0,	0,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	508,25,	
508,0,	508,0,	508,0,	508,0,	
508,0,	508,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
508,0,	508,0,	508,0,	508,0,	
0,0,	508,0,	0,0,	0,0,	
0,0,	0,0,	508,516,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
508,0,	508,0,	508,0,	508,0,	
508,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
0,0,	509,0,	509,0,	509,0,	
0,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	509,25,	509,0,	
509,0,	509,0,	509,0,	509,0,	
509,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	509,0,	
509,0,	509,0,	509,0,	0,0,	
509,0,	0,0,	0,0,	0,0,	
0,0,	509,517,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	509,0,	
509,0,	509,0,	509,0,	509,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	0,0,	
510,0,	510,0,	510,0,	0,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	510,25,	510,0,	510,0,	
510,0,	510,0,	510,0,	510,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	510,0,	510,0,	
510,0,	510,0,	0,0,	510,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	510,0,	510,0,	
510,0,	510,0,	510,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	0,0,	511,0,	
511,0,	511,0,	0,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
511,25,	511,0,	511,0,	511,0,	
511,0,	511,0,	511,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	511,0,	511,0,	511,0,	
511,0,	0,0,	511,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	511,0,	511,0,	511,0,	
511,0,	511,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	0,0,	512,0,	512,0,	
512,0,	0,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	512,25,	
512,0,	512,0,	512,0,	512,0,	
512,0,	512,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
512,0,	512,0,	512,0,	512,0,	
0,0,	512,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
512,0,	512,0,	512,0,	512,0,	
512,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
0,0,	513,0,	513,0,	513,0,	
0,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	513,25,	513,0,	
513,0,	513,0,	513,0,	513,0,	
513,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	513,0,	
513,0,	513,0,	513,0,	0,0,	
513,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	513,518,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	513,0,	
513,0,	513,0,	513,0,	513,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	0,0,	
514,0,	514,0,	514,0,	0,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	514,25,	514,0,	514,0,	
514,0,	514,0,	514,0,	514,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	514,0,	514,0,	
514,0,	514,0,	0,0,	514,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	514,519,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	514,0,	514,0,	
514,0,	514,0,	514,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	0,0,	515,0,	
515,0,	515,0,	0,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
515,25,	515,0,	515,0,	515,0,	
515,0,	515,0,	515,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,0,	515,0,	515,0,	
515,0,	0,0,	515,0,	515,520,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	515,0,	515,0,	515,0,	
515,0,	515,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	0,0,	516,0,	516,0,	
516,0,	0,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	516,25,	
516,0,	516,0,	516,0,	516,0,	
516,0,	516,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
516,0,	516,0,	516,0,	516,0,	
0,0,	516,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
516,0,	516,0,	516,0,	516,0,	
516,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
0,0,	517,0,	517,0,	517,0,	
0,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	517,25,	517,0,	
517,0,	517,0,	517,0,	517,0,	
517,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	517,0,	
517,0,	517,0,	517,0,	0,0,	
517,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	517,0,	
517,0,	517,0,	517,0,	517,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	0,0,	
518,0,	518,0,	518,0,	0,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	518,25,	518,0,	518,0,	
518,0,	518,0,	518,0,	518,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	518,0,	518,0,	
518,0,	518,0,	0,0,	518,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	518,0,	518,0,	
518,0,	518,0,	518,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	0,0,	519,0,	
519,0,	519,0,	0,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
519,25,	519,0,	519,0,	519,0,	
519,0,	519,0,	519,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	519,0,	519,0,	519,0,	
519,0,	0,0,	519,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	519,521,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	519,0,	519,0,	519,0,	
519,0,	519,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	0,0,	520,0,	520,0,	
520,0,	0,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	520,25,	
520,0,	520,0,	520,0,	520,0,	
520,0,	520,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
520,0,	520,0,	520,0,	520,0,	
0,0,	520,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	520,522,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
520,0,	520,0,	520,0,	520,0,	
520,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
0,0,	521,0,	521,0,	521,0,	
0,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	521,25,	521,0,	
521,0,	521,0,	521,0,	521,0,	
521,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	521,0,	
521,0,	521,0,	521,0,	0,0,	
521,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	521,523,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	521,0,	
521,0,	521,0,	521,0,	521,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	0,0,	
522,0,	522,0,	522,0,	0,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	522,25,	522,0,	522,0,	
522,0,	522,0,	522,0,	522,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	522,0,	522,0,	
522,0,	522,0,	0,0,	522,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	522,524,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	522,0,	522,0,	
522,0,	522,0,	522,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	0,0,	523,0,	
523,0,	523,0,	0,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
523,25,	523,0,	523,0,	523,0,	
523,0,	523,0,	523,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	523,0,	523,0,	523,0,	
523,0,	0,0,	523,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
523,525,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	523,0,	523,0,	523,0,	
523,0,	523,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	0,0,	524,0,	524,0,	
524,0,	0,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	524,25,	
524,0,	524,0,	524,0,	524,0,	
524,0,	524,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
524,0,	524,0,	524,0,	524,0,	
0,0,	524,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	524,526,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
524,0,	524,0,	524,0,	524,0,	
524,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
0,0,	525,0,	525,0,	525,0,	
0,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	525,25,	525,0,	
525,0,	525,0,	525,0,	525,0,	
525,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	525,0,	
525,0,	525,0,	525,0,	525,527,	
525,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	525,0,	
525,0,	525,0,	525,0,	525,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	0,0,	
526,0,	526,0,	526,0,	0,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	526,25,	526,0,	526,0,	
526,0,	526,0,	526,0,	526,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	526,0,	526,0,	
526,0,	526,0,	0,0,	526,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	526,0,	526,0,	
526,0,	526,0,	526,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	0,0,	527,0,	
527,0,	527,0,	0,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
527,25,	527,0,	527,0,	527,0,	
527,0,	527,0,	527,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	527,0,	527,0,	527,0,	
527,0,	0,0,	527,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	527,528,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	527,0,	527,0,	527,0,	
527,0,	527,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	0,0,	528,0,	528,0,	
528,0,	0,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	528,25,	
528,0,	528,0,	528,0,	528,0,	
528,0,	528,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
528,0,	528,0,	528,0,	528,0,	
0,0,	528,0,	528,529,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
528,0,	528,0,	528,0,	528,0,	
528,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
0,0,	529,0,	529,0,	529,0,	
0,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	529,25,	529,0,	
529,0,	529,0,	529,0,	529,0,	
529,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	529,0,	
529,0,	529,0,	529,0,	0,0,	
529,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	529,530,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	529,0,	
529,0,	529,0,	529,0,	529,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	0,0,	
530,0,	530,0,	530,0,	0,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	530,25,	530,0,	530,0,	
530,0,	530,0,	530,0,	530,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	530,0,	530,0,	
530,0,	530,0,	0,0,	530,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	530,531,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	530,0,	530,0,	
530,0,	530,0,	530,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	0,0,	531,0,	
531,0,	531,0,	0,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
531,25,	531,0,	531,0,	531,0,	
531,0,	531,0,	531,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	531,0,	531,0,	531,0,	
531,0,	0,0,	531,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	0,0,	0,0,	0,0,	
0,0,	531,0,	531,0,	531,0,	
531,0,	531,0,	0,0,	0,0,	
0,0};
struct yysvf yysvec[] = {
0,	0,	0,
yycrank+-1,	0,		0,	
yycrank+-21,	yysvec+1,	0,	
yycrank+0,	0,		yyvstop+1,
yycrank+3,	0,		yyvstop+3,
yycrank+0,	yysvec+4,	yyvstop+6,
yycrank+4,	yysvec+4,	yyvstop+8,
yycrank+-137,	0,		yyvstop+11,
yycrank+0,	0,		yyvstop+13,
yycrank+0,	0,		yyvstop+16,
yycrank+1,	0,		yyvstop+19,
yycrank+0,	0,		yyvstop+21,
yycrank+-264,	yysvec+7,	yyvstop+24,
yycrank+-391,	yysvec+7,	yyvstop+26,
yycrank+454,	0,		yyvstop+28,
yycrank+91,	yysvec+14,	yyvstop+30,
yycrank+94,	yysvec+14,	yyvstop+32,
yycrank+-576,	yysvec+7,	yyvstop+34,
yycrank+106,	yysvec+14,	yyvstop+36,
yycrank+-703,	yysvec+7,	yyvstop+38,
yycrank+15,	yysvec+14,	yyvstop+40,
yycrank+-830,	yysvec+7,	yyvstop+42,
yycrank+115,	yysvec+14,	yyvstop+44,
yycrank+-957,	yysvec+7,	yyvstop+46,
yycrank+7,	yysvec+4,	yyvstop+48,
yycrank+0,	0,		yyvstop+50,
yycrank+9,	0,		0,	
yycrank+-1084,	yysvec+7,	0,	
yycrank+0,	0,		yyvstop+52,
yycrank+-1211,	yysvec+7,	0,	
yycrank+-1338,	yysvec+7,	0,	
yycrank+-1465,	yysvec+7,	0,	
yycrank+-1592,	yysvec+7,	0,	
yycrank+-1719,	yysvec+7,	0,	
yycrank+124,	yysvec+14,	0,	
yycrank+-1846,	yysvec+7,	0,	
yycrank+-1973,	yysvec+7,	0,	
yycrank+-2100,	yysvec+7,	0,	
yycrank+-2227,	yysvec+7,	0,	
yycrank+-2354,	yysvec+7,	0,	
yycrank+-2481,	yysvec+7,	0,	
yycrank+-2608,	yysvec+7,	0,	
yycrank+-2735,	yysvec+7,	0,	
yycrank+-2862,	yysvec+7,	0,	
yycrank+-2989,	yysvec+7,	0,	
yycrank+-3116,	yysvec+7,	0,	
yycrank+-3243,	yysvec+7,	0,	
yycrank+-3370,	yysvec+7,	0,	
yycrank+125,	yysvec+14,	0,	
yycrank+-3497,	yysvec+7,	0,	
yycrank+-3624,	yysvec+7,	0,	
yycrank+-3751,	yysvec+7,	0,	
yycrank+-3878,	yysvec+7,	0,	
yycrank+-4005,	yysvec+7,	yyvstop+54,
yycrank+-4132,	yysvec+7,	0,	
yycrank+-4259,	yysvec+7,	0,	
yycrank+-4386,	yysvec+7,	0,	
yycrank+-4513,	yysvec+7,	0,	
yycrank+-4640,	yysvec+7,	0,	
yycrank+-4767,	yysvec+7,	0,	
yycrank+-4894,	yysvec+7,	0,	
yycrank+-5021,	yysvec+7,	0,	
yycrank+-5148,	yysvec+7,	0,	
yycrank+-5275,	yysvec+7,	0,	
yycrank+-5402,	yysvec+7,	0,	
yycrank+-5529,	yysvec+7,	0,	
yycrank+-5656,	yysvec+7,	0,	
yycrank+-5783,	yysvec+7,	0,	
yycrank+-5910,	yysvec+7,	0,	
yycrank+-6037,	yysvec+7,	0,	
yycrank+-6164,	yysvec+7,	yyvstop+56,
yycrank+-6291,	yysvec+7,	0,	
yycrank+-6418,	yysvec+7,	0,	
yycrank+-6545,	yysvec+7,	0,	
yycrank+-6672,	yysvec+7,	0,	
yycrank+-6799,	yysvec+7,	0,	
yycrank+-6926,	yysvec+7,	0,	
yycrank+-7053,	yysvec+7,	0,	
yycrank+-13,	0,		yyvstop+58,
yycrank+-7180,	yysvec+7,	0,	
yycrank+-7307,	yysvec+7,	0,	
yycrank+-7434,	yysvec+7,	yyvstop+60,
yycrank+219,	yysvec+14,	0,	
yycrank+-7561,	yysvec+7,	yyvstop+62,
yycrank+-7688,	yysvec+7,	0,	
yycrank+-7815,	yysvec+7,	0,	
yycrank+253,	yysvec+14,	0,	
yycrank+-7942,	yysvec+7,	0,	
yycrank+-8069,	yysvec+7,	0,	
yycrank+-8196,	yysvec+7,	0,	
yycrank+-8323,	yysvec+7,	0,	
yycrank+-8450,	yysvec+7,	0,	
yycrank+-8577,	yysvec+7,	0,	
yycrank+-8704,	yysvec+7,	0,	
yycrank+127,	yysvec+14,	0,	
yycrank+-8831,	yysvec+7,	0,	
yycrank+-8958,	yysvec+7,	0,	
yycrank+-9085,	yysvec+7,	0,	
yycrank+-9212,	yysvec+7,	0,	
yycrank+-9339,	yysvec+7,	0,	
yycrank+-9466,	yysvec+7,	0,	
yycrank+-9593,	yysvec+7,	0,	
yycrank+-9720,	yysvec+7,	0,	
yycrank+-9847,	yysvec+7,	0,	
yycrank+-9974,	yysvec+7,	0,	
yycrank+-10101,	yysvec+7,	0,	
yycrank+-10228,	yysvec+7,	0,	
yycrank+-10355,	yysvec+7,	0,	
yycrank+-10482,	yysvec+7,	0,	
yycrank+-10609,	yysvec+7,	0,	
yycrank+-10736,	yysvec+7,	0,	
yycrank+-10863,	yysvec+7,	0,	
yycrank+-10990,	yysvec+7,	0,	
yycrank+-11117,	yysvec+7,	0,	
yycrank+-11244,	yysvec+7,	0,	
yycrank+-11371,	yysvec+7,	0,	
yycrank+-11498,	yysvec+7,	0,	
yycrank+-11625,	yysvec+7,	0,	
yycrank+-11752,	yysvec+7,	0,	
yycrank+-11879,	yysvec+7,	0,	
yycrank+-12006,	yysvec+7,	yyvstop+64,
yycrank+-12133,	yysvec+7,	0,	
yycrank+-12260,	yysvec+7,	0,	
yycrank+-12387,	yysvec+7,	yyvstop+66,
yycrank+-12514,	yysvec+7,	0,	
yycrank+-12641,	yysvec+7,	0,	
yycrank+-12768,	yysvec+7,	0,	
yycrank+-12895,	yysvec+7,	0,	
yycrank+-13022,	yysvec+7,	0,	
yycrank+-13149,	yysvec+7,	yyvstop+68,
yycrank+-13276,	yysvec+7,	0,	
yycrank+-13403,	yysvec+7,	0,	
yycrank+-13530,	yysvec+7,	0,	
yycrank+-13657,	yysvec+7,	yyvstop+70,
yycrank+-13784,	yysvec+7,	0,	
yycrank+-13911,	yysvec+7,	0,	
yycrank+-14038,	yysvec+7,	0,	
yycrank+-14165,	yysvec+7,	0,	
yycrank+-14292,	yysvec+7,	0,	
yycrank+-14419,	yysvec+7,	0,	
yycrank+140,	yysvec+14,	0,	
yycrank+203,	yysvec+14,	0,	
yycrank+-14546,	yysvec+7,	0,	
yycrank+-14673,	yysvec+7,	0,	
yycrank+-14800,	yysvec+7,	0,	
yycrank+-14927,	yysvec+7,	0,	
yycrank+-15054,	yysvec+7,	0,	
yycrank+-15181,	yysvec+7,	0,	
yycrank+264,	yysvec+14,	0,	
yycrank+-15308,	yysvec+7,	0,	
yycrank+-15435,	yysvec+7,	0,	
yycrank+-15562,	yysvec+7,	0,	
yycrank+265,	yysvec+14,	0,	
yycrank+330,	yysvec+14,	0,	
yycrank+-15689,	yysvec+7,	0,	
yycrank+-15816,	yysvec+7,	0,	
yycrank+-15943,	yysvec+7,	0,	
yycrank+-16070,	yysvec+7,	0,	
yycrank+-16197,	yysvec+7,	0,	
yycrank+-16324,	yysvec+7,	0,	
yycrank+-16451,	yysvec+7,	yyvstop+72,
yycrank+-16578,	yysvec+7,	0,	
yycrank+-16705,	yysvec+7,	0,	
yycrank+-16832,	yysvec+7,	0,	
yycrank+-16959,	yysvec+7,	0,	
yycrank+-17086,	yysvec+7,	0,	
yycrank+-17213,	yysvec+7,	0,	
yycrank+-17340,	yysvec+7,	0,	
yycrank+-17467,	yysvec+7,	0,	
yycrank+-17594,	yysvec+7,	0,	
yycrank+-17721,	yysvec+7,	yyvstop+74,
yycrank+-17848,	yysvec+7,	0,	
yycrank+-17975,	yysvec+7,	0,	
yycrank+-18102,	yysvec+7,	0,	
yycrank+-18229,	yysvec+7,	0,	
yycrank+-18356,	yysvec+7,	0,	
yycrank+-18483,	yysvec+7,	0,	
yycrank+-18610,	yysvec+7,	0,	
yycrank+-18737,	yysvec+7,	yyvstop+76,
yycrank+-18864,	yysvec+7,	0,	
yycrank+-18991,	yysvec+7,	0,	
yycrank+-19118,	yysvec+7,	0,	
yycrank+-19245,	yysvec+7,	yyvstop+78,
yycrank+-19372,	yysvec+7,	0,	
yycrank+-19499,	yysvec+7,	0,	
yycrank+-19626,	yysvec+7,	0,	
yycrank+-19753,	yysvec+7,	0,	
yycrank+-19880,	yysvec+7,	0,	
yycrank+-20007,	yysvec+7,	0,	
yycrank+-20134,	yysvec+7,	0,	
yycrank+-20261,	yysvec+7,	0,	
yycrank+-20388,	yysvec+7,	0,	
yycrank+-20515,	yysvec+7,	0,	
yycrank+-20642,	yysvec+7,	0,	
yycrank+-20769,	yysvec+7,	0,	
yycrank+-20896,	yysvec+7,	0,	
yycrank+-21023,	yysvec+7,	0,	
yycrank+-21150,	yysvec+7,	yyvstop+80,
yycrank+-21277,	yysvec+7,	0,	
yycrank+-21404,	yysvec+7,	0,	
yycrank+-21531,	yysvec+7,	0,	
yycrank+-21658,	yysvec+7,	0,	
yycrank+-21785,	yysvec+7,	0,	
yycrank+-21912,	yysvec+7,	0,	
yycrank+236,	yysvec+14,	0,	
yycrank+-22039,	yysvec+7,	0,	
yycrank+-22166,	yysvec+7,	yyvstop+82,
yycrank+-22293,	yysvec+7,	yyvstop+84,
yycrank+-22420,	yysvec+7,	0,	
yycrank+-22547,	yysvec+7,	0,	
yycrank+348,	yysvec+14,	0,	
yycrank+-22674,	yysvec+7,	0,	
yycrank+349,	yysvec+14,	0,	
yycrank+-22801,	yysvec+7,	0,	
yycrank+-22928,	yysvec+7,	0,	
yycrank+-23055,	yysvec+7,	yyvstop+86,
yycrank+-23182,	yysvec+7,	0,	
yycrank+-23309,	yysvec+7,	yyvstop+88,
yycrank+-23436,	yysvec+7,	0,	
yycrank+-23563,	yysvec+7,	0,	
yycrank+-23690,	yysvec+7,	0,	
yycrank+-23817,	yysvec+7,	0,	
yycrank+-23944,	yysvec+7,	0,	
yycrank+361,	yysvec+14,	0,	
yycrank+-24071,	yysvec+7,	0,	
yycrank+383,	yysvec+14,	0,	
yycrank+-24198,	yysvec+7,	0,	
yycrank+-24325,	yysvec+7,	0,	
yycrank+-24452,	yysvec+7,	0,	
yycrank+-24579,	yysvec+7,	0,	
yycrank+-24706,	yysvec+7,	0,	
yycrank+-24833,	yysvec+7,	0,	
yycrank+-24960,	yysvec+7,	0,	
yycrank+-25087,	yysvec+7,	0,	
yycrank+-25214,	yysvec+7,	0,	
yycrank+-25341,	yysvec+7,	0,	
yycrank+-25468,	yysvec+7,	0,	
yycrank+-25595,	yysvec+7,	0,	
yycrank+-25722,	yysvec+7,	0,	
yycrank+-25849,	yysvec+7,	yyvstop+90,
yycrank+-25976,	yysvec+7,	0,	
yycrank+-26103,	yysvec+7,	0,	
yycrank+-26230,	yysvec+7,	0,	
yycrank+-26357,	yysvec+7,	0,	
yycrank+-26484,	yysvec+7,	0,	
yycrank+-26611,	yysvec+7,	0,	
yycrank+-26738,	yysvec+7,	0,	
yycrank+-26865,	yysvec+7,	0,	
yycrank+-26992,	yysvec+7,	0,	
yycrank+-27119,	yysvec+7,	yyvstop+92,
yycrank+-27246,	yysvec+7,	0,	
yycrank+-27373,	yysvec+7,	0,	
yycrank+-27500,	yysvec+7,	0,	
yycrank+-27627,	yysvec+7,	0,	
yycrank+-27754,	yysvec+7,	0,	
yycrank+-27881,	yysvec+7,	0,	
yycrank+-28008,	yysvec+7,	0,	
yycrank+-28135,	yysvec+7,	0,	
yycrank+-28262,	yysvec+7,	0,	
yycrank+-28389,	yysvec+7,	0,	
yycrank+-28516,	yysvec+7,	0,	
yycrank+-28643,	yysvec+7,	0,	
yycrank+-28770,	yysvec+7,	0,	
yycrank+-28897,	yysvec+7,	0,	
yycrank+-29024,	yysvec+7,	0,	
yycrank+-29151,	yysvec+7,	0,	
yycrank+-29278,	yysvec+7,	0,	
yycrank+-29405,	yysvec+7,	0,	
yycrank+-29532,	yysvec+7,	0,	
yycrank+-29659,	yysvec+7,	0,	
yycrank+-29786,	yysvec+7,	yyvstop+94,
yycrank+-29913,	yysvec+7,	0,	
yycrank+-30040,	yysvec+7,	0,	
yycrank+-30167,	yysvec+7,	0,	
yycrank+-30294,	yysvec+7,	0,	
yycrank+-30421,	yysvec+7,	0,	
yycrank+-30548,	yysvec+7,	0,	
yycrank+-30675,	yysvec+7,	0,	
yycrank+-30802,	yysvec+7,	0,	
yycrank+-30929,	yysvec+7,	0,	
yycrank+-31056,	yysvec+7,	0,	
yycrank+-31183,	yysvec+7,	0,	
yycrank+-31310,	yysvec+7,	0,	
yycrank+-31437,	yysvec+7,	0,	
yycrank+-31564,	yysvec+7,	0,	
yycrank+-31691,	yysvec+7,	0,	
yycrank+-31818,	yysvec+7,	0,	
yycrank+-31945,	yysvec+7,	0,	
yycrank+-32072,	yysvec+7,	0,	
yycrank+-32199,	yysvec+7,	0,	
yycrank+-32326,	yysvec+7,	0,	
yycrank+-32453,	yysvec+7,	0,	
yycrank+-32580,	yysvec+7,	0,	
yycrank+-32707,	yysvec+7,	0,	
yycrank+-32834,	yysvec+7,	0,	
yycrank+-32961,	yysvec+7,	0,	
yycrank+-33088,	yysvec+7,	0,	
yycrank+-33215,	yysvec+7,	0,	
yycrank+530,	yysvec+14,	0,	
yycrank+-33342,	yysvec+7,	0,	
yycrank+-33469,	yysvec+7,	0,	
yycrank+-33596,	yysvec+7,	0,	
yycrank+-33723,	yysvec+7,	0,	
yycrank+-33850,	yysvec+7,	0,	
yycrank+-33977,	yysvec+7,	0,	
yycrank+-34104,	yysvec+7,	0,	
yycrank+-34231,	yysvec+7,	0,	
yycrank+-34358,	yysvec+7,	0,	
yycrank+-34485,	yysvec+7,	0,	
yycrank+-34612,	yysvec+7,	0,	
yycrank+-34739,	yysvec+7,	0,	
yycrank+-34866,	yysvec+7,	yyvstop+96,
yycrank+-34993,	yysvec+7,	0,	
yycrank+-35120,	yysvec+7,	0,	
yycrank+-35247,	yysvec+7,	yyvstop+98,
yycrank+-35374,	yysvec+7,	0,	
yycrank+-35501,	yysvec+7,	yyvstop+100,
yycrank+-35628,	yysvec+7,	0,	
yycrank+-35755,	yysvec+7,	0,	
yycrank+-35882,	yysvec+7,	0,	
yycrank+-36009,	yysvec+7,	0,	
yycrank+-36136,	yysvec+7,	0,	
yycrank+-36263,	yysvec+7,	0,	
yycrank+-36390,	yysvec+7,	0,	
yycrank+-36517,	yysvec+7,	yyvstop+102,
yycrank+-36644,	yysvec+7,	0,	
yycrank+-36771,	yysvec+7,	0,	
yycrank+-36898,	yysvec+7,	yyvstop+104,
yycrank+-37025,	yysvec+7,	0,	
yycrank+-37152,	yysvec+7,	0,	
yycrank+-37279,	yysvec+7,	0,	
yycrank+-37406,	yysvec+7,	0,	
yycrank+-37533,	yysvec+7,	0,	
yycrank+-37660,	yysvec+7,	0,	
yycrank+-37787,	yysvec+7,	0,	
yycrank+-37914,	yysvec+7,	0,	
yycrank+-38041,	yysvec+7,	yyvstop+106,
yycrank+-38168,	yysvec+7,	yyvstop+108,
yycrank+-38295,	yysvec+7,	0,	
yycrank+-38422,	yysvec+7,	yyvstop+110,
yycrank+-38549,	yysvec+7,	0,	
yycrank+-38676,	yysvec+7,	0,	
yycrank+-38803,	yysvec+7,	0,	
yycrank+-38930,	yysvec+7,	0,	
yycrank+-39057,	yysvec+7,	yyvstop+112,
yycrank+-39184,	yysvec+7,	0,	
yycrank+-39311,	yysvec+7,	0,	
yycrank+-39438,	yysvec+7,	0,	
yycrank+-39565,	yysvec+7,	0,	
yycrank+-39692,	yysvec+7,	0,	
yycrank+-39819,	yysvec+7,	yyvstop+114,
yycrank+-39946,	yysvec+7,	0,	
yycrank+-40073,	yysvec+7,	0,	
yycrank+-40200,	yysvec+7,	0,	
yycrank+-40327,	yysvec+7,	0,	
yycrank+-40454,	yysvec+7,	0,	
yycrank+-40581,	yysvec+7,	0,	
yycrank+-40708,	yysvec+7,	0,	
yycrank+-40835,	yysvec+7,	0,	
yycrank+-40962,	yysvec+7,	0,	
yycrank+-41089,	yysvec+7,	0,	
yycrank+-41216,	yysvec+7,	0,	
yycrank+-41343,	yysvec+7,	0,	
yycrank+-41470,	yysvec+7,	0,	
yycrank+-41597,	yysvec+7,	0,	
yycrank+-41724,	yysvec+7,	0,	
yycrank+-41851,	yysvec+7,	0,	
yycrank+-41978,	yysvec+7,	0,	
yycrank+-42105,	yysvec+7,	0,	
yycrank+-42232,	yysvec+7,	0,	
yycrank+-42359,	yysvec+7,	0,	
yycrank+-42486,	yysvec+7,	0,	
yycrank+-42613,	yysvec+7,	0,	
yycrank+-42740,	yysvec+7,	0,	
yycrank+-42867,	yysvec+7,	0,	
yycrank+-42994,	yysvec+7,	0,	
yycrank+-43121,	yysvec+7,	0,	
yycrank+-43248,	yysvec+7,	0,	
yycrank+-43375,	yysvec+7,	0,	
yycrank+-43502,	yysvec+7,	0,	
yycrank+-43629,	yysvec+7,	0,	
yycrank+-43756,	yysvec+7,	0,	
yycrank+-43883,	yysvec+7,	0,	
yycrank+-44010,	yysvec+7,	0,	
yycrank+-44137,	yysvec+7,	0,	
yycrank+-44264,	yysvec+7,	0,	
yycrank+-44391,	yysvec+7,	yyvstop+116,
yycrank+-44518,	yysvec+7,	0,	
yycrank+-44645,	yysvec+7,	0,	
yycrank+-44772,	yysvec+7,	0,	
yycrank+-44899,	yysvec+7,	0,	
yycrank+-45026,	yysvec+7,	0,	
yycrank+-45153,	yysvec+7,	0,	
yycrank+-45280,	yysvec+7,	yyvstop+118,
yycrank+-45407,	yysvec+7,	0,	
yycrank+-45534,	yysvec+7,	0,	
yycrank+-45661,	yysvec+7,	0,	
yycrank+-45788,	yysvec+7,	0,	
yycrank+-45915,	yysvec+7,	yyvstop+120,
yycrank+-46042,	yysvec+7,	0,	
yycrank+-46169,	yysvec+7,	yyvstop+122,
yycrank+-46296,	yysvec+7,	0,	
yycrank+-46423,	yysvec+7,	yyvstop+124,
yycrank+-46550,	yysvec+7,	0,	
yycrank+-46677,	yysvec+7,	0,	
yycrank+-46804,	yysvec+7,	yyvstop+126,
yycrank+-46931,	yysvec+7,	0,	
yycrank+-47058,	yysvec+7,	0,	
yycrank+-47185,	yysvec+7,	0,	
yycrank+-47312,	yysvec+7,	yyvstop+128,
yycrank+-47439,	yysvec+7,	0,	
yycrank+-47566,	yysvec+7,	yyvstop+130,
yycrank+-47693,	yysvec+7,	0,	
yycrank+-47820,	yysvec+7,	0,	
yycrank+-47947,	yysvec+7,	0,	
yycrank+-48074,	yysvec+7,	0,	
yycrank+-48201,	yysvec+7,	yyvstop+132,
yycrank+-48328,	yysvec+7,	0,	
yycrank+-48455,	yysvec+7,	0,	
yycrank+-48582,	yysvec+7,	0,	
yycrank+-48709,	yysvec+7,	yyvstop+134,
yycrank+-48836,	yysvec+7,	0,	
yycrank+384,	yysvec+14,	0,	
yycrank+545,	yysvec+14,	0,	
yycrank+-48963,	yysvec+7,	0,	
yycrank+-49090,	yysvec+7,	0,	
yycrank+-49217,	yysvec+7,	0,	
yycrank+-49344,	yysvec+7,	0,	
yycrank+547,	yysvec+14,	0,	
yycrank+563,	yysvec+14,	0,	
yycrank+-49471,	yysvec+7,	0,	
yycrank+-49598,	yysvec+7,	0,	
yycrank+-49725,	yysvec+7,	0,	
yycrank+-49852,	yysvec+7,	0,	
yycrank+-49979,	yysvec+7,	0,	
yycrank+-50106,	yysvec+7,	0,	
yycrank+-50233,	yysvec+7,	0,	
yycrank+-50360,	yysvec+7,	0,	
yycrank+-50487,	yysvec+7,	0,	
yycrank+-50614,	yysvec+7,	0,	
yycrank+-50741,	yysvec+7,	0,	
yycrank+-50868,	yysvec+7,	0,	
yycrank+-50995,	yysvec+7,	0,	
yycrank+-51122,	yysvec+7,	0,	
yycrank+-51249,	yysvec+7,	yyvstop+136,
yycrank+-51376,	yysvec+7,	yyvstop+138,
yycrank+-51503,	yysvec+7,	0,	
yycrank+-51630,	yysvec+7,	0,	
yycrank+-51757,	yysvec+7,	0,	
yycrank+-51884,	yysvec+7,	0,	
yycrank+-52011,	yysvec+7,	0,	
yycrank+-52138,	yysvec+7,	0,	
yycrank+-52265,	yysvec+7,	0,	
yycrank+-52392,	yysvec+7,	0,	
yycrank+-52519,	yysvec+7,	0,	
yycrank+-52646,	yysvec+7,	0,	
yycrank+-52773,	yysvec+7,	0,	
yycrank+-52900,	yysvec+7,	yyvstop+140,
yycrank+-53027,	yysvec+7,	0,	
yycrank+-53154,	yysvec+7,	0,	
yycrank+-53281,	yysvec+7,	0,	
yycrank+-53408,	yysvec+7,	0,	
yycrank+-53535,	yysvec+7,	0,	
yycrank+-53662,	yysvec+7,	0,	
yycrank+-53789,	yysvec+7,	0,	
yycrank+-53916,	yysvec+7,	0,	
yycrank+-54043,	yysvec+7,	0,	
yycrank+-54170,	yysvec+7,	0,	
yycrank+-54297,	yysvec+7,	0,	
yycrank+-54424,	yysvec+7,	0,	
yycrank+-54551,	yysvec+7,	0,	
yycrank+-54678,	yysvec+7,	0,	
yycrank+-54805,	yysvec+7,	0,	
yycrank+-54932,	yysvec+7,	0,	
yycrank+-55059,	yysvec+7,	yyvstop+142,
yycrank+-55186,	yysvec+7,	0,	
yycrank+-55313,	yysvec+7,	yyvstop+144,
yycrank+-55440,	yysvec+7,	0,	
yycrank+-55567,	yysvec+7,	yyvstop+146,
yycrank+-55694,	yysvec+7,	0,	
yycrank+-55821,	yysvec+7,	0,	
yycrank+-55948,	yysvec+7,	0,	
yycrank+-56075,	yysvec+7,	0,	
yycrank+-56202,	yysvec+7,	yyvstop+148,
yycrank+-56329,	yysvec+7,	0,	
yycrank+-56456,	yysvec+7,	yyvstop+150,
yycrank+-56583,	yysvec+7,	0,	
yycrank+-56710,	yysvec+7,	0,	
yycrank+-56837,	yysvec+7,	yyvstop+152,
yycrank+-56964,	yysvec+7,	0,	
yycrank+-57091,	yysvec+7,	0,	
yycrank+-57218,	yysvec+7,	yyvstop+154,
yycrank+-57345,	yysvec+7,	yyvstop+156,
yycrank+-57472,	yysvec+7,	0,	
yycrank+-57599,	yysvec+7,	0,	
yycrank+-57726,	yysvec+7,	0,	
yycrank+-57853,	yysvec+7,	0,	
yycrank+-57980,	yysvec+7,	0,	
yycrank+-58107,	yysvec+7,	0,	
yycrank+-58234,	yysvec+7,	0,	
yycrank+-58361,	yysvec+7,	yyvstop+158,
yycrank+-58488,	yysvec+7,	0,	
yycrank+-58615,	yysvec+7,	yyvstop+160,
yycrank+-58742,	yysvec+7,	0,	
yycrank+-58869,	yysvec+7,	0,	
yycrank+-58996,	yysvec+7,	0,	
yycrank+-59123,	yysvec+7,	0,	
yycrank+-59250,	yysvec+7,	0,	
yycrank+-59377,	yysvec+7,	0,	
yycrank+-59504,	yysvec+7,	0,	
yycrank+-59631,	yysvec+7,	yyvstop+162,
yycrank+-59758,	yysvec+7,	yyvstop+164,
yycrank+-59885,	yysvec+7,	yyvstop+166,
yycrank+-60012,	yysvec+7,	0,	
yycrank+-60139,	yysvec+7,	0,	
yycrank+-60266,	yysvec+7,	0,	
yycrank+-60393,	yysvec+7,	yyvstop+168,
yycrank+-60520,	yysvec+7,	yyvstop+170,
yycrank+-60647,	yysvec+7,	yyvstop+172,
yycrank+-60774,	yysvec+7,	0,	
yycrank+-60901,	yysvec+7,	0,	
yycrank+-61028,	yysvec+7,	0,	
yycrank+-61155,	yysvec+7,	0,	
yycrank+-61282,	yysvec+7,	0,	
yycrank+-61409,	yysvec+7,	0,	
yycrank+-61536,	yysvec+7,	yyvstop+174,
yycrank+-61663,	yysvec+7,	yyvstop+176,
yycrank+-61790,	yysvec+7,	0,	
yycrank+-61917,	yysvec+7,	0,	
yycrank+-62044,	yysvec+7,	0,	
yycrank+-62171,	yysvec+7,	0,	
yycrank+-62298,	yysvec+7,	yyvstop+178,
0,	0,	0};
struct yywork *yytop = yycrank+62425;
struct yysvf *yybgin = yysvec+1;
char yymatch[] = {
00  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,011 ,012 ,01  ,011 ,011 ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
040 ,01  ,01  ,01  ,'$' ,01  ,01  ,01  ,
01  ,01  ,01  ,01  ,01  ,01  ,01  ,01  ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,01  ,
01  ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,'$' ,
01  ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,'$' ,
'$' ,'$' ,'$' ,01  ,01  ,01  ,01  ,01  ,
0};
char yyextra[] = {
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0,0,0,0,0,0,0,0,
0};
#ifndef lint
static	char ncform_sccsid[] = "@(#)ncform 1.6 88/02/08 SMI"; /* from S5R2 1.2 */
#endif

int yylineno =1;
# define YYU(x) x
# define NLSTATE yyprevious=YYNEWLINE
char yytext[YYLMAX];
struct yysvf *yylstate [YYLMAX], **yylsp, **yyolsp;
char yysbuf[YYLMAX];
char *yysptr = yysbuf;
int *yyfnd;
extern struct yysvf *yyestate;
int yyprevious = YYNEWLINE;
yylook(){
	register struct yysvf *yystate, **lsp;
	register struct yywork *yyt;
	struct yysvf *yyz;
	int yych, yyfirst;
	struct yywork *yyr;
# ifdef LEXDEBUG
	int debug;
# endif
	char *yylastch;
	/* start off machines */
# ifdef LEXDEBUG
	debug = 0;
# endif
	yyfirst=1;
	if (!yymorfg)
		yylastch = yytext;
	else {
		yymorfg=0;
		yylastch = yytext+yyleng;
		}
	for(;;){
		lsp = yylstate;
		yyestate = yystate = yybgin;
		if (yyprevious==YYNEWLINE) yystate++;
		for (;;){
# ifdef LEXDEBUG
			if(debug)fprintf(yyout,"state %d\n",yystate-yysvec-1);
# endif
			yyt = yystate->yystoff;
			if(yyt == yycrank && !yyfirst){  /* may not be any transitions */
				yyz = yystate->yyother;
				if(yyz == 0)break;
				if(yyz->yystoff == yycrank)break;
				}
			*yylastch++ = yych = input();
			yyfirst=0;
		tryagain:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"char ");
				allprint(yych);
				putchar('\n');
				}
# endif
			yyr = yyt;
			if ( (int)yyt > (int)yycrank){
				yyt = yyr + yych;
				if (yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
# ifdef YYOPTIM
			else if((int)yyt < (int)yycrank) {		/* r < yycrank */
				yyt = yyr = yycrank+(yycrank-yyt);
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"compressed state\n");
# endif
				yyt = yyt + yych;
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transitions */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				yyt = yyr + YYU(yymatch[yych]);
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"try fall back character ");
					allprint(YYU(yymatch[yych]));
					putchar('\n');
					}
# endif
				if(yyt <= yytop && yyt->verify+yysvec == yystate){
					if(yyt->advance+yysvec == YYLERR)	/* error transition */
						{unput(*--yylastch);break;}
					*lsp++ = yystate = yyt->advance+yysvec;
					goto contin;
					}
				}
			if ((yystate = yystate->yyother) && (yyt= yystate->yystoff) != yycrank){
# ifdef LEXDEBUG
				if(debug)fprintf(yyout,"fall back to state %d\n",yystate-yysvec-1);
# endif
				goto tryagain;
				}
# endif
			else
				{unput(*--yylastch);break;}
		contin:
# ifdef LEXDEBUG
			if(debug){
				fprintf(yyout,"state %d char ",yystate-yysvec-1);
				allprint(yych);
				putchar('\n');
				}
# endif
			;
			}
# ifdef LEXDEBUG
		if(debug){
			fprintf(yyout,"stopped at %d with ",*(lsp-1)-yysvec-1);
			allprint(yych);
			putchar('\n');
			}
# endif
		while (lsp-- > yylstate){
			*yylastch-- = 0;
			if (*lsp != 0 && (yyfnd= (*lsp)->yystops) && *yyfnd > 0){
				yyolsp = lsp;
				if(yyextra[*yyfnd]){		/* must backup */
					while(yyback((*lsp)->yystops,-*yyfnd) != 1 && lsp > yylstate){
						lsp--;
						unput(*yylastch--);
						}
					}
				yyprevious = YYU(*yylastch);
				yylsp = lsp;
				yyleng = yylastch-yytext+1;
				yytext[yyleng] = 0;
# ifdef LEXDEBUG
				if(debug){
					fprintf(yyout,"\nmatch ");
					sprint(yytext);
					fprintf(yyout," action %d\n",*yyfnd);
					}
# endif
				return(*yyfnd++);
				}
			unput(*yylastch);
			}
		if (yytext[0] == 0  /* && feof(yyin) */)
			{
			yysptr=yysbuf;
			return(0);
			}
		yyprevious = yytext[0] = input();
		if (yyprevious>0)
			output(yyprevious);
		yylastch=yytext;
# ifdef LEXDEBUG
		if(debug)putchar('\n');
# endif
		}
	}
yyback(p, m)
	int *p;
{
if (p==0) return(0);
while (*p)
	{
	if (*p++ == m)
		return(1);
	}
return(0);
}
	/* the following are only used in the lex library */
yyinput(){
	return(input());
	}
yyoutput(c)
  int c; {
	output(c);
	}
yyunput(c)
   int c; {
	unput(c);
	}
