/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

/* this module handles the label table */
#include <string.h>
#include <stdlib.h>
#include "labels.h"
#include "put_code.h"

/*
typedef	struct LABEL
	{
	char 	*name;
	unsigned	pc;		 offset into current put label is 
	int	*unresolved;	 array of offsets of unresolved jumps 
	int	unres_size;
	int	unres_dim;
	} label;
*/

label 	*label_table;

int	label_table_size=0;

int	label_table_dim=0;

int
init_label_table(void)
{
	label_table = (label *)malloc((unsigned)
				      (LABEL_TABLE_SIZE*sizeof(label))
				      );
	label_table_size=0;
	label_table_dim=LABEL_TABLE_SIZE;
	}

void
reset_label_table(void)
{
	int i;
	for(i = 0; i < label_table_size; i++)
		{
		/* free any space */
		free(label_table[i].name);
		/* assume no unresolved jumps */
		}
	label_table_size=0;
	}


/* is_in_label_table **********************************************/
/* return position (will be equal to size of table if not there) */
/* crude linear at present */
/* expands table if necessary */
int
is_in_label_table(char *name)
{
	int count=0;
	int found=0;
	while(count < label_table_size && !found)
		if( !(found = !strcmp(label_table[count].name, name)) )
			count++;
	if(count == label_table_dim)
		label_table = (label *)realloc(label_table, 
					       (sizeof(label)*
					        (label_table_dim += 10)));
	return(count);
	}


/* lookup_label_table ****************************************************/
/* look up a label in the label table.
   if not there allocate a place for it;
		enter unresolved offset;
		set pc to zero;
		return negative offset into the label table.
   if there and unresolved list is empty
		return offset into the label table
   if there and unresolved list is not empty
		enter unresolved offset;
		return (negative offset into the label table) -1
*/
int	
lookup_label_table(char *name, int unres)
{

	int place;
	/* is_in_label_table has side effect of expanding table if nec */
	if((place = is_in_label_table(name)) == label_table_size)
		{
		/* create a new place in the label table */
		label_table[place].name
			= malloc((unsigned)(strlen(name)+1));
		label_table_size++;
		strcpy( label_table[place].name, name);

		/* assign token pc value (once known this will be updated) */
		label_table[place].pc = 0;

		/* alloc and assign unresolved jumps */
		label_table[place].unresolved
			= (int *) malloc((unsigned)(sizeof(int)*10));
		label_table[place].unres_dim = 10;

		label_table[place].unresolved[0] = unres;
		label_table[place].unres_size = 1;

		return(-place - 1);
		}
	else
	{
	/* if address is known */
	if(label_table[place].unres_size == 0)
		return(place);
	else
	/* address not known but label encountered before */
		{
		/* expand unresolved if necessary */
		if(label_table[place].unres_size 
		   == 
		   label_table[place].unres_dim)
			label_table[place].unresolved 
			= 
			(int *) realloc(label_table[place].unresolved,
					(unsigned)
					(sizeof(int)*
					 (label_table[place].unres_dim+=10)));
		label_table[place].unresolved[label_table[place].unres_size++] = unres;
		return(-place - 1);
		}
		
	}
	}


/* resolve_label ********************************************************/
/* returns offset into table of the entered label
   resolves any previously unknown jumps to this label */

/* At present pc is actually an offset into the current put array */
/* The address jumped from is stored in the put array at the position to hold
	the offset.
   This position is kept as one of the entries in the unresolved list.
   Such an offset may now be calculated from the current pc value (passed)
   and the address temporarily stored.
   ie
	offset = pc - temp
   This offset now overwrites temp in the put array. 
*/
int
resolve_label(char *name, int pc)
{
	int place;

	/* if in table ... */
	if((place = is_in_label_table(name)) != label_table_size)
		/* ... resolve unresolved references */
		{
		int i;
		char *save_current_put_position = current_put->position;
		for(i = 0; i < label_table[place].unres_size; i++)
			{
			current_put->position
				= (char *)
				  ( (int)current_put->base
				    +
				    label_table[place].unresolved[i] );
			put_offset(pc - get_offset(current_put->position));
			}
		free(label_table[place].unresolved);
		current_put->position = save_current_put_position;
		}
	/* if not in table ... */
	else
		/* ... add to table */
		{
		/* create a new place in the label table */
                label_table[place].name
                        = malloc((unsigned)(strlen(name)+1));
                label_table_size++;
                strcpy( label_table[place].name, name );
		}
	label_table[place].pc = pc;
	label_table[place].unres_dim = 0;
	label_table[place].unres_size = 0;
	return(place);
	}
