/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "put_code.h"
#include "string_table.h"


extern int string_arg (char *s);
extern int label_arg (char *l);
extern void put_label_offset (char *name, int pc, int address);
extern int some_arg (char *s, int *ip);
extern int int_arg (int *ip);

void
make_and_put_constant_hash_table(int size)
{
	char def[MAX_STRING_LENGTH];

	unsigned table_offset = pc;

	string_arg(def);/* get "default" */
			    /* maybe some test */
	label_arg(def); /* get default label */

	put_constant_atom(0); table_offset+=CONSTANT_SIZE;
	put_label_offset(def, pc, table_offset); table_offset+=OFFSET_SIZE;

	/* get rest of entries */
	{
	int read_atom;
	int i;
	char s[MAX_STRING_LENGTH];
	char l[MAX_STRING_LENGTH];

	while(read_atom = some_arg(s, &i))
		{
		(read_atom > 0)
			? put_constant_atom(lookup_string_table(s))
			: put_constant_integer(i);
		table_offset+=CONSTANT_SIZE;  

		label_arg(l);
		put_label_offset(l, pc, table_offset); table_offset+=OFFSET_SIZE;
		}
	/* put end of table delimiter */
	if(table_offset < (pc+size))
		{
		put_constant_atom(0); put_offset(0); 
		table_offset += (CONSTANT_SIZE+OFFSET_SIZE);
		}

	/* fill rest of table with default */
	while(table_offset < (pc+size))
		{
		put_constant_atom(0); table_offset+=CONSTANT_SIZE;
		put_label_offset(def, pc, table_offset); table_offset+=OFFSET_SIZE;
		}
	} /* end get rest of entries */
	/* set pc to after the table */
	pc += size;
	}

void
make_and_put_structure_hash_table(int size)
{
	char def[MAX_STRING_LENGTH];

	unsigned table_offset = pc;

	string_arg(def);/* get "default" */
			    /* maybe some test */
	label_arg(def); /* get default label */

	put_constant_atom(0);
	put_number(0);
	table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);
	put_label_offset(def, pc, table_offset); table_offset+=OFFSET_SIZE;

	/* get rest of entries */
	{
	char s[MAX_STRING_LENGTH];
	while(string_arg(s))
		{
		int n;
		char l[MAX_STRING_LENGTH];

		int_arg(&n);
		label_arg(l);

		put_constant_atom(lookup_string_table(s));
		put_number(n);
		table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);

		put_label_offset(l, pc, table_offset); table_offset+=OFFSET_SIZE;
		}


	/* put end of table delimiter */
	if(table_offset < (pc+size))
		{
		put_constant_atom(0); put_number(0); put_offset(0); 
		table_offset += (CONSTANT_SIZE+NUMBER_SIZE+OFFSET_SIZE);
		}

	/* fill rest of table with default */
	while(table_offset < (pc+size))
		{
		put_constant_atom(0);
		put_number(0);
		table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);
		put_label_offset(def, pc, table_offset);
		table_offset+=OFFSET_SIZE;
		}
	}
	/* set pc to after the table */
	pc += size;
	}

void
make_and_put_quantifier_hash_table(int size)
{
	char def[MAX_STRING_LENGTH];

	unsigned table_offset = pc;

	string_arg(def);/* get "default" */
			    /* maybe some test */
	label_arg(def); /* get default label */

	put_constant_atom(0);
	put_number(0);
	table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);
	put_label_offset(def, pc, table_offset); table_offset+=OFFSET_SIZE;

	/* get rest of entries */
	{
	char s[MAX_STRING_LENGTH];
	while(string_arg(s))
		{
		int n;
		char l[MAX_STRING_LENGTH];

		int_arg(&n);
		label_arg(l);

		put_constant_atom(lookup_string_table(s));
		put_number(n);
		table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);

		put_label_offset(l, pc, table_offset); table_offset+=OFFSET_SIZE;
		}


	/* put end of table delimiter */
	if(table_offset < (pc+size))
		{
		put_constant_atom(0); put_number(0); put_offset(0); 
		table_offset += (CONSTANT_SIZE+NUMBER_SIZE+OFFSET_SIZE);
		}

	/* fill rest of table with default */
	while(table_offset < (pc+size))
		{
		put_constant_atom(0);
		put_number(0);
		table_offset+=(CONSTANT_SIZE + NUMBER_SIZE);
		put_label_offset(def, pc, table_offset);
		table_offset+=OFFSET_SIZE;
		}
	}
	/* set pc to after the table */
	pc += size;
	}
