/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "built_in.h"
#include "built_in_table.h"

built_in built_in_table[] =
{
	{ "", 0, 0 },

	{ "put", 1, 1 },
	{ "get", 1, 2 },
	{ "put0", 1, 3 },
	{ "get0", 1, 4 },
	{ "$write_atom", 1, 5 },
	{ "$write_integer", 1, 6 },
	{ "$write_var_name", 1, 7 },
	{ "$open", 3, 8 },
	{ "$close", 1, 9 },
	{ "$set_input", 1, 10 },
	{ "$set_output", 1, 11 },
	{ "flush", 0, 12 },
	{ "$read_term_string", 1, 13 },
	{ "$writec", 5, 14 },
	{ "$writeq", 2, 15 },
	{ "$writeRc", 3, 16 },
	{ "$readc", 3, 17 },
	{ "$readRc", 4, 18 },
	{ "$readR1c", 3, 19 },
	{ "quantify", 4, 20 },
	{ "$substitute", 3, 21 },
	{ "$new_dynamic_object_var", 1, 22 },
	{ "$new_local", 1, 23 },
	{ "atom", 1, 24 },
	{ "integer", 1, 25 },
	{ "var", 1, 26 },
	{ "is_object_var", 1, 27 },
	{ "$is_local_object_var", 1, 28 },
	{ "atom_chars", 2, 29 },
	{ "univ", 2, 30 },
	{ "functor", 3, 31 },
	{ "arg", 3, 32 },
	{ "$equal", 2, 33 },
	{ "$var_less_than", 2, 34 },
	{ "$freeze", 1, 35 },
	{ "$thaw", 1, 36 },
	{ "$frozen", 1, 37 },
	{ "$atoms_to_atom", 2, 38 },
	{ "number_chars", 2, 39 },
	{ "get_args", 1, 40 },
	{ "$getwd", 1, 41 },
	{ "$exit", 1, 42 },
	{ "statistics", 1, 43 },
	{ "$write_statistics", 1, 44 },
	{ "$label", 1, 45 },
	{ "$cut", 1, 46 },
	{ "$system", 3, 47 },
	{ "exec", 2, 48 },
	{ "$fork", 0, 49 },
	{ "$fork3", 3, 50 },
	{ "$setFlag", 2, 51 },
	{ "$getFlag", 2, 52 },
	{ "$asserta", 1, 53 },
	{ "$assertz", 1, 54 },
	{ "$first_clause", 3, 55 },
	{ "$next_clause", 2, 56 },
	{ "$last_clause", 1, 57 },
	{ "$erase", 1, 58 },
	{ "$instance", 2, 59 },
	{ "$instance_no_copy", 2, 60 },
	{ "$static_predicate", 3, 61 },
	{ "$first_not_free", 2, 62 },
	{ "$get_not_free", 3, 63 },
	{ "$next_not_free", 2, 64 },
	{ "$consult", 1, 65 },
	{ "$times", 3, 66 },
	{ "$divide", 3, 67 },
	{ "$plus", 3, 68 },
	{ "$minus", 3, 69 },
	{ "$mod", 3, 70 },
	{ "$power", 3, 71 },
	{ "$bitwise_and", 3, 72 },
	{ "$bitwise_or", 3, 73 },
	{ "$bitwise_xor", 3, 74 },
	{ "$shift_left", 3, 75 },
	{ "$shift_right", 3, 76 },
	{ "$minus1", 2, 77 },
	{ "$complement", 2, 78 },
	{ "$not", 2, 79 },
	{ "$lt", 3, 80 },
	{ "$leq", 3, 81 },
	{ "$gt", 3, 82 },
	{ "$geq", 3, 83 },
	{ "$less_than", 2, 84 },
	{ "$first_delayed_problem", 1, 85 },
	{ "$get_delayed_problem", 4, 86 },
	{ "$next_delayed_problem", 2, 87 },
	{ "$check_delayed_problem", 1, 88 },
	{ "retry_delay_problems", 0, 89 },
	{ "$new_persistent_meta_var", 2, 90 },
	{ "$new_persistent_object_var", 2, 91 },
	{ "$persistent_meta_var", 1, 92 },
	{ "$persistent_object_var", 1, 93 },
	{ "$unpersistent_meta_var", 1, 94 },
	{ "$unpersistent_object_var", 1, 95 },
	{ "is_persistent_var", 1, 96 },
	{ "is_persistent_object_var", 1, 97 },
	{ "$persistent_name", 2, 98 },
	{ "$copy_to_heap", 2, 99 },
	{ "$simplify", 2, 100 },
	{ "$object_var", 1, 101 },
	{ "$object_var_prefix_declared", 1, 102 },
	{ "$object_var_prefix", 1, 103 },
	{ "$op_", 3, 104 },
	{ "$first_op", 1, 105 },
	{ "$last_op", 1, 106 },
	{ "$some_op", 5, 107 },
	{ "$next_op", 2, 108 },
	{ "$signal", 2, 109 },
	{ "$ipsetc", 2, 110 },
	{ "$iplookupc", 2, 111 },
	{ "$get_unify_delays", 1, 112 },
	{ "$get_first_unify_delay", 1, 113 },
	{ "create_widget", 3, 201 },
	{ "initialize_X", 2, 202 },
	{ "start_X", 1, 203 },
	{ "get_event", 1, 204 },
	{ "destroy_widget", 1, 205 },
	{ "set_widget_resource", 3, 206 },
	{ "$string_read", 1, 207 },
	{ "$no_string_read", 0, 208 },
	{ "$write_to_text_widget", 1, 209 },
	{ "$close_write_to_text_widget", 0, 210 },
	{ "text_widget_string", 2, 211 },
	{ "clear_text_widget", 3, 212 },
	{ "$new_term_write", 0, 213 },
	{ "$write_done", 0, 214 },
	{ "error_widget", 1, 215 },
	{ "selected_path", 1, 216 },
	{ "selected_widget", 1, 217 },
	{ "$widget_read", 1, 218 },
	{ "popup_widget", 1, 219 },
	{ "popdown_widget", 1, 220 },
	{ "$write_to_term_widget", 1, 221 },
	{ "path_to_string", 4, 222 },
	{ "text_widget_tabs", 2, 223 },
	{ "install_widget_accelerators", 2, 224 },
	{ "set_keyboard_focus_widget", 2, 225 },
	{ "$string_read_position", 1, 226 },
	{ "widget_write_position", 2, 227 },
	{ "save_text_widget", 2, 228 },
	{ "$add_spy", 2, 241 },
	{ "$list_spied_predicates", 0, 242 },
	{ "$delete_spy", 2, 243 },
	{ "$delete_all_spied_predicates", 0, 244 },
	{ "$trace", 0, 245 },
	{ "$append", 3, 246 },

	{ DUMMY, 0, NOT_FOUND }
};
