/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

/* get argument procedures *********************************/
/* all real input reading is left up to lex */
/* i.e. only use input() and parse our own linebuffer */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "string_table.h"
#include "lex.yy.h"

char *linebuf;
int linebuf_dim;
char *in_string;

#define LINEBUF_SIZE 200


extern void warning (char *, ...);

void
init_get(void)
{
        linebuf = malloc((unsigned) LINEBUF_SIZE);
	in_string = linebuf;
	linebuf[0] = (char)0;
	linebuf_dim = LINEBUF_SIZE;
	}

/* note that reallocation of linebuf makes in_string meaningless */
void
expand_linebuf(void)
{
	linebuf_dim += LINEBUF_SIZE;
        linebuf =  realloc(linebuf, linebuf_dim);
	}

#define IS_DELIM(c)	( c == ' '		\
			|| c == '	'	\
			|| c == ','		\
			|| c == '('		\
			|| c == ')'		\
			|| c == ':'		\
			|| c == ']'		\
			|| c == '['		\
			)

void skip_delim(void)
{
        while(IS_DELIM(*in_string))
            in_string++;
        }

void nl(void)
{
        *linebuf = (char)0;
        in_string = linebuf;
        }

#define IS_NUM_CHAR(c) (c >= '0' && c <= '9')
#define NEWLINE(c) (c == '\n' || c == (char)0)

int int_arg(int *ip)
{
	int i=0;
        char *tmp;

	/* skip until integer */
	while( !IS_NUM_CHAR(*in_string) 
	       && 
	       !NEWLINE(*in_string) 
	       &&
	       !(*in_string == '-')
	       )
		in_string++;
	if(NEWLINE(*in_string)) return(0);

	tmp = in_string++;
	i++;
        while( IS_NUM_CHAR(*in_string) )
		{
		i++;
                in_string++;
		}
	*in_string++ = (char)0;
	*ip = atoi(tmp);
	return(i);
        }

#define QUOTE '\''
#define IS_QUOTE(c) (c == QUOTE)

/* space is assumed to have been managed elsewhere */
/* all atom constants are assumed to be enclosed in single quotes */
/* single quotes are escaped by doubling */
int string_arg(char *s)
{
	int i=0, done=0;

	/* match first quote */
	while( !IS_QUOTE(*in_string) && !NEWLINE(*in_string))
		in_string++;
	if(NEWLINE(*in_string)) return(0);
	/* eat first quote */
	in_string++;

	/* match anything but a quote looking after escapes on the fly */
	while(!done && !(i >= MAX_STRING_LENGTH))
		{
		if(IS_QUOTE(*in_string))
			{
			/* eat quote */
			in_string++;
			done = !IS_QUOTE(*in_string);
			}
		if(!done)
			if(NEWLINE(*in_string)) 
			    {
			    getln(); s[i++] = '\n';
			    }
			else if (*in_string == '\t')
			    {
			    s[i++] = '\t';
			    in_string++;
			    }
			else if (*in_string == '\\')
			    {
			    in_string++;
			    switch (*in_string)
			    	{
			    	case 'n':
					s[i++] = '\n';
					in_string++;
					break;
			    	case '\\':
					s[i++] = '\\';
					in_string++;
					break;
			    	default:
					s[i++] = '\\';
					break;
			    	}
			    }
			else			
			    s[i++] = *in_string++;
		}

        s[i++] = (char)0;
	if(i > MAX_STRING_LENGTH) 
		warning("atom too long(%d)...%s", i, s);
	return i;
        }


/* space is assumed to have been managed elsewhere */
/* label args are distinct from other atoms in that they are not enclosed in
   quotes and cannot contain spaces commas or brackets */
int label_arg(char *l)
{
	int i=0, done=0;

	skip_delim();

	/* match anything but spaces, brackets, commas, colons */
	while(!IS_DELIM(*in_string) && !NEWLINE(*in_string))
		l[i++] = *in_string++;

        l[i++] = (char)0;
	if(i > MAX_STRING_LENGTH) 
		warning("label too long(%d)...%s", i, l);
	return i;
        }


int is_atom(void)
{
	skip_delim();
	return(IS_QUOTE(*in_string));
	}

/* updates either a string or integer argument from in_string */
/* returns the number of successfully read chars in the string 
   or  negative the number of ''------''-------''   the integer */

int some_arg(char *s, int *ip)
{
	if(is_atom())
		return(string_arg(s));
	else
		return(-int_arg(ip));
	}
