/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "defs.h"
#include "errors.h"
#include "string_map.h"

global	offset	*string_map;
global	offset	*top_of_string_map;
global	natural	string_map_size=DEFAULT_STRING_MAP_SIZE;


/*----------------------------------------------------------------------------
    allocate a contiguous block of memory for each object files string map
    (old to new). Set the top to the beginning of the block.
----------------------------------------------------------------------------*/
global	void
initialise_string_map(void)
{

	if ((string_map = (offset *) malloc(Kwords_to_chars(string_map_size)))
		== NULL)
		fatal("Not enough memory");
	reinitialise_string_map();
}

global	void
reinitialise_string_map(void)
{
	top_of_string_map = string_map;
}
