/*
 * QU-PROLOG COPYRIGHT NOTICE, LICENCE AND DISCLAIMER.
 * 
 * Copyright 1993 by The University of Queensland, Queensland 4072 Australia
 * 
 * Permission to use, copy and distribute this software 
 * for any non-commercial purpose and without fee is hereby
 * granted, provided that the above copyright notice
 * and this permission notice and warranty
 * disclaimer appear in all copies and in supporting documentation, 
 * and that the name of The University of Queensland not be used in 
 * advertising or publicity pertaining to distribution of the software 
 * without specific, written prior permission.
 * 
 * Source code modifications are prohibited except where written agreement 
 * has been given in advance by The University of Queensland.
 * 
 * The University of Queensland disclaims all warranties with regard to this
 * software, including all implied warranties of merchantability and fitness.
 * In no event shall The University of Queensland be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from
 * loss of use, data or profits, whether in an action of contract, negligence
 * or other tortious action, arising out of or in connection with the use or
 * performance of this software.
 */

#include "name_table.h"
#include "code_area.h"
#include "index.h"
#include "instructions.h"
#include "link.h"
#include "opcodes.h"
#include "pc.h"
#include "query_code.h"
#include "resolve_object.h"
#include "string_table.h"

/*----------------------------------------------------------------------------
pass2:
	complete pass through code table, updating references to
	strings and predicates.

	query_code
	+-------+
	|string#| for '$query'
	+-------+
	|   0	|
	+-------+
	| size	|
	+-------+-----	}
	|	|...	} query code for each object file
	|	|-----	}
	|	|
	|	|
n+1:	TRUST_ME_ELSE_FAIL
	+-------+
	|PROCEED|
	+-------+
		    ******* see in ~/qc/tables/query_code.c *******
	string_map
	+---------------+-----	}
	|old#	| new#	|...	} string map for each object file
	|	|	|-----	}
	|	|	|
	|	|	|
	|	|	|
	+---------------+

	code_area
	+-------+------	}
	|string#|	}
	+-------+	}
	|arity	|	}
	+-------+	}
	|size	|	}
	+-------+	}
	|  c	|	}
	|  o	|	}
	|  d	|	} procedures in eac object file
	|  e	|	}
	+-------+	}
	|string#|	}
	+-------+	}
	|arity	|	}
	+-------+	}
	|size	|	}
	+-------+	}
	|  c	|	}
	|  o	|	}
	|  d	|	}
	|  e	|	}
	+-------+-----	}
	|string#|
	+-------+
	|arity	|
	+-------+
	|size	|
	+-------+
	| ....	|

----------------------------------------------------------------------------*/

extern offset lookup_name_table_offset (char *s, int name_table_tag);
extern offset lookup_predicate_table (offset string_offset, unsigned int arity, offset code_offset, int insert);

global	void
link_object(index *object_index, unsigned int num_of_object_files)
{
	code	*position_of_query_code_size;
	int	i;
	offset	code_offset;
	offset	string_offset;
	natural	arity;
	boolean	insert;


	/*
	 * setup query procedure
	 * 	place TRUST_ME_ELSE_FAIL and PROCEED instruction at the end
	 *      of the query code insert the string table offset for '$query'
	 *	and arity 0 into the top of the query code and
	 *	query code size
	 */
	pc = top_of_query_code;
	PutInstruction(TRUST_ME_ELSE_FAIL);
	PutInstruction(PROCEED);
	top_of_query_code = pc;
	pc = query_code;
	PutOffset(string_offset = lookup_name_table_offset("$query", ATOM_W));
	top_of_string_table += strlen("$query") + 1;
	PutNumber(arity = 0);
	position_of_query_code_size = pc;
	PutConstant(top_of_query_code -
			(position_of_query_code_size + SizeOfConstant));

	/* Put the entry for the query in the hash table. */
	insert = TRUE;
	code_offset = query_code - code_area;
	(void) lookup_predicate_table(string_offset, arity,
				code_offset, insert);
	
	for (i = 0; i < num_of_object_files; i++)
		resolve_object(object_index+i);
}
