(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

(* System dependencies.  Currently not used pervasively *)

functor NewJersey () : SYS =
struct

exception UnexpectedReturn

fun handle_interrupt (infiniteLoop : unit -> unit) =
  let val oldHandler = System.Signals.inqHandler(System.Signals.SIGINT)
  in ( callcc (fn k =>
	 ( System.Signals.setHandler(System.Signals.SIGINT,SOME(fn _ => k)) ;
	   infiniteLoop () ;
	   raise UnexpectedReturn )) ;
       print ("\ninterrupt\n") ;
       infiniteLoop () ;
       raise UnexpectedReturn )
     handle exn => ( System.Signals.setHandler(System.Signals.SIGINT, oldHandler) ;
		     raise exn )
 end

fun output_immediately (outstream,s:string) =
   ( output(outstream,s) ; flush_out outstream )

val exception_name = System.exn_name
val sml_version = System.version
val input_one_line = input_line

fun save_file (filename,date) =
     ( if exportML(filename)
	  then print(System.version ^ "\n" ^ date ^ "\n")
	  else print "Done.\n" )

fun strip_newline (str) = substring (str, 0, size(str) - 1)

fun date () = 
       let val (instream,_) = execute ("/bin/date",[])
	    in strip_newline (input_line instream) end
       handle exn => ( print "Could not get current date.\n" ;
		       raise exn )

val cd = System.Directory.cd

(* System.Directory.getWD seems excessively slow and does not work *)
(* currently (version 0.75 of SML of NJ) under Mach *)

fun cwd () =
       let val (instream,_) = execute ("/bin/pwd",[])
        in strip_newline (input_line instream) end
       handle exn => ( print "Could not get current working directory.\n" ;
		       raise exn )

fun ls str = ( System.system ("ls -F " ^ str) ; () )

fun exit () = System.Unsafe.CInterface.exit (0)
	      handle exn => ( print "Could not exit.\n" ; raise exn )

end  (* functor NewJersey *)
