(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

(* Constraints, external and internal view *)
(* There is an ugly SourceGroup bug workaround in here
   -fp Tue Apr 28 10:03:28 1992 *)

signature CONSTRAINTS_DATATYPES =
sig

  structure Term : TERM

  datatype eqterm
   = Rigid of Term.term * (Term.term * Term.term list)
   | Gvar of Term.term * (Term.term * Term.term list)
   | Flex of Term.term * Term.term
   | Abstraction of Term.term
   | Quant of Term.term
   | Any of Term.term

   datatype dpair = Dpair of eqterm * eqterm

   datatype constraint = Con of dpair list

end

signature CONSTRAINTS =
sig

  include CONSTRAINTS_DATATYPES 

  exception Nonunifiable of unit -> string

  val bare_term : eqterm -> Term.term

  val mkDpair : eqterm * eqterm -> dpair

  val empty_constraint : constraint
  val is_empty_constraint : constraint -> bool
  val makestring_constraint : constraint -> string

  val makestring_dpair : dpair -> string
  val makestring_dset : dpair list -> string

  (* anno makes obvious annotations, reclassify tries hard *)
  val anno : Term.term -> eqterm
  val reclassify : Term.term -> eqterm

end  (* signature CONSTRAINTS *)


signature CONSTRAINTS_ABSTRACT =
sig

  structure Term : TERM

  exception Nonunifiable of unit -> string

  type constraint
  val empty_constraint : constraint
  val is_empty_constraint : constraint -> bool
  val makestring_constraint : constraint -> string

end  (* signature CONSTRAINTS_ABSTRACT *)
