;;; Modifications to the completing tags program.
;;; In particular: we need to change the completion table, once
;;; another tags table is visited.
;;; Author: fp
;;; Last updated Tue Jan  7 20:20:01 1992

(require 'completing-tag)

(defun build-tag-completion-table ()
   "Implicitly create *tag-completion-table*, based on current buffer"
   (goto-char (point-min))
   (setq *tag-completion-table* nil)
   (while (re-search-forward "^ *[^ ]+ +\\([^ ]+\\) " nil t)
      (setq *tag-completion-table* 
	 (cons (list (buffer-substring (match-beginning 1)
			(match-end 1))) *tag-completion-table*))
      )
   )

(defun visit-tags-table (file)
  "Tell tags commands to use tag table file FILE.
FILE should be the name of a file created with the `etags' program.
A directory name is ok too; it means file TAGS in that directory."
  (interactive (list (read-file-name "Visit tags table: (default TAGS) "
				     default-directory
				     (concat default-directory "TAGS")
				     t)))
  (setq file (expand-file-name file))
  (if (file-directory-p file)
      (setq file (concat file "TAGS")))
  (setq tag-table-files nil
	changed-tags-table-p t		; my fix. -fp
	tags-file-name file))

(defun visit-tags-table-buffer ()
   "Select the buffer containing the current tag table.
This is a file whose name is in the variable tags-file-name."
   ;; Modification
   (let (new-flag)
      (or tags-file-name
	 (call-interactively 'visit-tags-table))
      (set-buffer (or (get-file-buffer tags-file-name)
		     (progn
			;; Modification
			(setq new-flag t)
			(setq tag-table-files nil)
			(find-file-noselect tags-file-name))))
      (or (verify-visited-file-modtime (get-file-buffer tags-file-name))
	 (cond ((yes-or-no-p "Tags file has changed, read new contents? ")
		  (revert-buffer t t)
		  ;; Modification
		  (setq new-flag t)
		  (setq tag-table-files nil))))
      (or (eq (char-after 1) ?\^L)
	 (error "File %s not a valid tag table" tags-file-name))
      ;; Modification
      (if changed-tags-table-p
	  (setq new-flag t
		changed-tags-table-p nil))
      (if new-flag (build-tag-completion-table))))
