(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)
(* Modified: Spiro Michaylov <spiro@cs.cmu.edu>     *)

(* The solver for Elf *)

signature SOLVER =
sig
  structure Term : TERM
  structure Sign : SIGN  sharing Sign.Term = Term
  structure Progtab : PROGTAB  sharing Progtab.Term = Term
  structure Constraints : CONSTRAINTS  sharing Constraints.Term = Term

  val sign_to_prog : Sign.sign -> Progtab.progentry list
  val solve : Term.term
                 -> bool
	         -> Constraints.constraint
		 -> (Constraints.constraint -> unit)
		 -> unit

  structure Switch : SWITCH

  val trace : int -> unit
  val untrace : unit -> unit

end  (* signature SOLVER *)
