functor ElfLexFun(structure Tokens: Elf_TOKENS
			   structure Interface: INTERFACE
			      sharing type Interface.pos = int) : LEXER=
   struct
    structure UserDeclarations =
      struct
(* Copyright (c) 1991 by Carnegie Mellon University *)
(* Author: Frank Pfenning <fp@cs.cmu.edu>           *)

structure Tokens = Tokens
structure Interface = Interface
open Interface

type pos = Interface.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult= (svalue,pos) token

val comLevel = ref 0
fun eof () = (* last position will be inaccurate! *)
	     let val lastpos = Interface.last_newline () + 1
	      in
	        ( if !comLevel > 0
		  then ( comLevel := 0 ; 
			 error ("unclosed comment %{", (lastpos, lastpos)) )
		  else  () ;
		  Tokens.EOF(lastpos,lastpos) )
             end

fun makeInt (s : string) =
    (revfold (fn (c,a) => a*10 + (ord c - ord("0"))) (explode s) 0)
fun stripquotes (s : string) = substring(s,1,size(s) - 2)

end (* end of user routines *)
exception LexError (* raised if illegal leaf action tried *)
structure Internal =
	struct

datatype yyfinstate = N of int
type statedata = {fin : yyfinstate list, trans: string}
(* transition & final state table *)
val tab = let
val s0 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s1 =
"\009\009\009\009\009\009\009\009\009\067\069\009\009\009\009\009\
\\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\009\
\\067\010\009\010\010\044\010\039\038\037\010\010\010\035\034\010\
\\032\032\032\032\032\032\032\032\032\032\031\010\029\010\010\010\
\\010\028\028\028\028\028\028\028\028\028\028\028\028\028\028\028\
\\028\028\028\028\028\028\028\028\028\028\028\027\010\026\010\024\
\\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\010\
\\010\010\010\019\015\010\010\010\010\010\010\014\010\012\010\009\
\\009"
val s3 =
"\070\070\070\070\070\070\070\070\070\070\071\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\070\
\\070"
val s5 =
"\072\072\072\072\072\072\072\072\072\072\077\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\075\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\072\
\\072\072\072\072\072\072\072\072\072\072\072\072\072\073\072\072\
\\072"
val s7 =
"\078\078\078\078\078\078\078\078\078\109\111\078\078\078\078\078\
\\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\078\
\\109\079\078\079\079\108\079\103\078\078\079\079\079\079\078\079\
\\101\101\101\101\101\101\101\101\101\101\078\079\079\079\079\079\
\\079\099\099\099\099\099\099\099\099\099\099\099\099\099\099\099\
\\099\099\099\099\099\099\099\099\099\099\099\078\079\078\079\099\
\\079\079\079\079\079\079\079\079\079\079\079\079\095\079\091\079\
\\079\079\086\081\079\079\079\079\079\079\079\078\079\078\079\078\
\\078"
val s10 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s12 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\013\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s15 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\016\011\000\011\000\011\000\
\\000"
val s16 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\017\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s17 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\018\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s19 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\020\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s20 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\021\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s21 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\022\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s22 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\023\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s24 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\025\000\025\025\000\025\025\000\000\025\025\025\025\000\025\
\\025\025\025\025\025\025\025\025\025\025\000\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\025\000\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\025\
\\025\025\025\025\025\025\025\025\025\025\025\000\025\000\025\000\
\\000"
val s29 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\030\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s32 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\033\033\033\033\033\033\033\033\033\033\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s35 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\011\000\011\011\000\011\011\000\000\011\011\011\011\000\011\
\\011\011\011\011\011\011\011\011\011\011\000\011\011\011\036\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\011\
\\011\011\011\011\011\011\011\011\011\011\011\000\011\000\011\000\
\\000"
val s39 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\040\000\040\000\000\000\040\040\040\040\000\040\
\\000\000\000\000\000\000\000\000\000\000\000\040\040\040\040\040\
\\040\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\040\000\040\042\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\000\
\\000"
val s40 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\040\000\040\040\000\040\041\000\000\040\040\040\040\000\040\
\\040\040\040\040\040\040\040\040\040\040\000\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\040\
\\040\040\040\040\040\040\040\040\040\040\040\000\040\000\040\000\
\\000"
val s42 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\042\000\042\042\000\042\043\000\000\042\042\042\042\000\042\
\\042\042\042\042\042\042\042\042\042\042\000\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\042\000\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\042\
\\042\042\042\042\042\042\042\042\042\042\042\000\042\000\042\000\
\\000"
val s44 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\062\000\000\000\000\058\000\
\\046\000\000\000\000\000\000\000\000\000\000\045\000\000\000\000\
\\000"
val s46 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\052\
\\000\000\047\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s47 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\048\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s48 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\049\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s49 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\050\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s50 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\051\000\000\000\000\000\000\000\
\\000"
val s52 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\053\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s53 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\054\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s54 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\055\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s55 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\056\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s56 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\057\000\000\000\000\000\000\000\
\\000"
val s58 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\059\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s59 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\060\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s60 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\061\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s62 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\063\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s63 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\064\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s64 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\065\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s65 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\066\000\000\000\000\000\000\000\
\\000"
val s67 =
"\000\000\000\000\000\000\000\000\000\068\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\068\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s73 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\074\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s75 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\076\000\000\000\000\
\\000"
val s79 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s81 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\082\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s82 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\083\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s83 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\084\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s84 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\085\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s86 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\087\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s87 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\088\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s88 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\089\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s89 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\090\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s91 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\092\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s92 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\093\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s93 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\094\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s95 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\096\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s96 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\097\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s97 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\080\000\080\080\000\080\080\000\000\080\080\080\080\000\080\
\\080\080\080\080\080\080\080\080\080\080\000\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\000\080\000\080\080\
\\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\080\
\\080\080\080\080\098\080\080\080\080\080\080\000\080\000\080\000\
\\000"
val s99 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\100\000\100\100\000\100\100\000\000\100\100\100\100\000\100\
\\100\100\100\100\100\100\100\100\100\100\000\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\000\100\000\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\100\
\\100\100\100\100\100\100\100\100\100\100\100\000\100\000\100\000\
\\000"
val s101 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\102\102\102\102\102\102\102\102\102\102\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
val s103 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\104\000\104\104\000\104\000\000\000\104\104\104\104\000\104\
\\000\000\000\000\000\000\000\000\000\000\000\104\104\104\104\104\
\\104\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\000\104\000\104\106\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\000\104\000\104\000\
\\000"
val s104 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\104\000\104\104\000\104\105\000\000\104\104\104\104\000\104\
\\104\104\104\104\104\104\104\104\104\104\000\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\000\104\000\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\104\
\\104\104\104\104\104\104\104\104\104\104\104\000\104\000\104\000\
\\000"
val s106 =
"\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\106\000\106\106\000\106\107\000\000\106\106\106\106\000\106\
\\106\106\106\106\106\106\106\106\106\106\000\106\106\106\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\000\106\000\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\106\
\\106\106\106\106\106\106\106\106\106\106\106\000\106\000\106\000\
\\000"
val s109 =
"\000\000\000\000\000\000\000\000\000\110\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\110\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\\000"
in Vector.vector
[{fin = [], trans = s0},
{fin = [(N 1)], trans = s1},
{fin = [(N 1)], trans = s1},
{fin = [], trans = s3},
{fin = [], trans = s3},
{fin = [], trans = s5},
{fin = [], trans = s5},
{fin = [(N 132)], trans = s7},
{fin = [(N 132)], trans = s7},
{fin = [(N 116)], trans = s0},
{fin = [(N 85),(N 116)], trans = s10},
{fin = [(N 85)], trans = s10},
{fin = [(N 24),(N 116)], trans = s12},
{fin = [(N 76)], trans = s0},
{fin = [(N 22),(N 116)], trans = s0},
{fin = [(N 85),(N 116)], trans = s15},
{fin = [(N 85)], trans = s16},
{fin = [(N 85)], trans = s17},
{fin = [(N 40),(N 85)], trans = s10},
{fin = [(N 85),(N 116)], trans = s19},
{fin = [(N 85)], trans = s20},
{fin = [(N 85)], trans = s21},
{fin = [(N 85)], trans = s22},
{fin = [(N 35),(N 85)], trans = s10},
{fin = [(N 29),(N 92),(N 116)], trans = s24},
{fin = [(N 92)], trans = s24},
{fin = [(N 20),(N 116)], trans = s0},
{fin = [(N 18),(N 116)], trans = s0},
{fin = [(N 92),(N 116)], trans = s24},
{fin = [(N 85),(N 116)], trans = s29},
{fin = [(N 8),(N 85)], trans = s10},
{fin = [(N 10),(N 116)], trans = s0},
{fin = [(N 95),(N 116)], trans = s32},
{fin = [(N 95)], trans = s32},
{fin = [(N 12),(N 116)], trans = s0},
{fin = [(N 85),(N 116)], trans = s35},
{fin = [(N 27),(N 85)], trans = s10},
{fin = [(N 16),(N 116)], trans = s0},
{fin = [(N 14),(N 116)], trans = s0},
{fin = [(N 116)], trans = s39},
{fin = [], trans = s40},
{fin = [(N 114)], trans = s40},
{fin = [], trans = s42},
{fin = [(N 114)], trans = s42},
{fin = [(N 5),(N 116)], trans = s44},
{fin = [(N 73)], trans = s0},
{fin = [], trans = s46},
{fin = [], trans = s47},
{fin = [], trans = s48},
{fin = [], trans = s49},
{fin = [], trans = s50},
{fin = [(N 55)], trans = s0},
{fin = [], trans = s52},
{fin = [], trans = s53},
{fin = [], trans = s54},
{fin = [], trans = s55},
{fin = [], trans = s56},
{fin = [(N 64)], trans = s0},
{fin = [], trans = s58},
{fin = [], trans = s59},
{fin = [], trans = s60},
{fin = [(N 70)], trans = s0},
{fin = [], trans = s62},
{fin = [], trans = s63},
{fin = [], trans = s64},
{fin = [], trans = s65},
{fin = [(N 47)], trans = s0},
{fin = [(N 1),(N 116)], trans = s67},
{fin = [(N 1)], trans = s67},
{fin = [(N 3)], trans = s0},
{fin = [(N 120)], trans = s0},
{fin = [(N 118)], trans = s0},
{fin = [(N 130)], trans = s0},
{fin = [(N 130)], trans = s73},
{fin = [(N 126)], trans = s0},
{fin = [(N 130)], trans = s75},
{fin = [(N 123)], trans = s0},
{fin = [(N 128)], trans = s0},
{fin = [(N 198)], trans = s0},
{fin = [(N 170),(N 198)], trans = s79},
{fin = [(N 170)], trans = s79},
{fin = [(N 170),(N 198)], trans = s81},
{fin = [(N 170)], trans = s82},
{fin = [(N 170)], trans = s83},
{fin = [(N 170)], trans = s84},
{fin = [(N 142),(N 170)], trans = s79},
{fin = [(N 170),(N 198)], trans = s86},
{fin = [(N 170)], trans = s87},
{fin = [(N 170)], trans = s88},
{fin = [(N 170)], trans = s89},
{fin = [(N 153),(N 170)], trans = s79},
{fin = [(N 170),(N 198)], trans = s91},
{fin = [(N 170)], trans = s92},
{fin = [(N 170)], trans = s93},
{fin = [(N 158),(N 170)], trans = s79},
{fin = [(N 170),(N 198)], trans = s95},
{fin = [(N 170)], trans = s96},
{fin = [(N 170)], trans = s97},
{fin = [(N 147),(N 170)], trans = s79},
{fin = [(N 177),(N 198)], trans = s99},
{fin = [(N 177)], trans = s99},
{fin = [(N 161),(N 198)], trans = s101},
{fin = [(N 161)], trans = s101},
{fin = [(N 198)], trans = s103},
{fin = [], trans = s104},
{fin = [(N 196)], trans = s104},
{fin = [], trans = s106},
{fin = [(N 196)], trans = s106},
{fin = [(N 136),(N 198)], trans = s0},
{fin = [(N 132),(N 198)], trans = s109},
{fin = [(N 132)], trans = s109},
{fin = [(N 134)], trans = s0}]
end
structure StartStates =
	struct
	datatype yystartstate = STARTSTATE of int

(* start state definitions *)

val COMMENT = STARTSTATE 3;
val DCOMMENT = STARTSTATE 5;
val INITIAL = STARTSTATE 1;
val PRAGMA = STARTSTATE 7;

end
type result = UserDeclarations.lexresult
	exception LexerError (* raised if illegal leaf action tried *)
end

fun makeLexer yyinput = 
let 
	val yyb = ref "\n" 		(* buffer *)
	val yybl = ref 1		(*buffer length *)
	val yybufpos = ref 1		(* location of next character to use *)
	val yygone = ref 1		(* position in file of beginning of buffer *)
	val yydone = ref false		(* eof found yet? *)
	val yybegin = ref 1		(*Current 'start state' for lexer *)

	val YYBEGIN = fn (Internal.StartStates.STARTSTATE x) =>
		 yybegin := x

fun lex () : Internal.result =
let fun continue() = lex() in
  let fun scan (s,AcceptingLeaves : Internal.yyfinstate list list,l,i0) =
	let fun action (i,nil) = raise LexError
	| action (i,nil::l) = action (i-1,l)
	| action (i,(node::acts)::l) =
		case node of
		    Internal.N yyk => 
			(let val yytext = substring(!yyb,i0,i-i0)
			     val yypos = i0+ !yygone
			open UserDeclarations Internal.StartStates
 in (yybufpos := i; case yyk of 

			(* Application actions *)

  1 => (continue())
| 10 => (Tokens.COLON(yypos,yypos+1))
| 114 => (Tokens.QUID (stripquotes(yytext),yypos,yypos+size yytext))
| 116 => (error ("ignoring illegal character" ^ yytext,
			   (yypos,yypos+1)); continue())
| 118 => (next_line(yypos); YYBEGIN INITIAL; continue())
| 12 => (Tokens.DOT(yypos,yypos+1))
| 120 => (continue())
| 123 => (comLevel := !comLevel+1; continue())
| 126 => (comLevel := !comLevel-1;
		    if !comLevel=0 then YYBEGIN INITIAL else ();
		    continue())
| 128 => (next_line(yypos); continue())
| 130 => (continue())
| 132 => (continue())
| 134 => (next_line(yypos); YYBEGIN INITIAL;
		    Tokens.EOFPRAGMA(yypos,yypos+1))
| 136 => (YYBEGIN COMMENT; Tokens.EOFPRAGMA(yypos,yypos+1))
| 14 => (Tokens.LPAREN(yypos,yypos+1))
| 142 => (Tokens.SIGMA(yypos,yypos+5))
| 147 => (Tokens.LEFT(yypos,yypos+4))
| 153 => (Tokens.RIGHT(yypos,yypos+5))
| 158 => (Tokens.NONE_(yypos,yypos+4))
| 16 => (Tokens.RPAREN(yypos,yypos+1))
| 161 => (Tokens.NUM(makeInt(yytext),yypos,yypos+size yytext))
| 170 => (Tokens.LCID(yytext,yypos,yypos+size yytext))
| 177 => (Tokens.UCID(yytext,yypos,yypos+size yytext))
| 18 => (Tokens.LBRACKET(yypos,yypos+1))
| 196 => (Tokens.QUID(stripquotes(yytext),yypos,yypos+size yytext))
| 198 => (error ("ignoring illegal character " ^ yytext
			   ^ " in pragma", (yypos, yypos+1)); continue())
| 20 => (Tokens.RBRACKET(yypos,yypos+1))
| 22 => (Tokens.LBRACE(yypos,yypos+1))
| 24 => (Tokens.RBRACE(yypos,yypos+1))
| 27 => (Tokens.ARROW(yypos,yypos+2))
| 29 => (Tokens.UNDERSCORE(yypos,yypos+1))
| 3 => (next_line(yypos); continue())
| 35 => (Tokens.SIGMA(yypos,yypos+5))
| 40 => (Tokens.TYPE(yypos,yypos+4))
| 47 => (YYBEGIN PRAGMA ; Tokens.INFIX(yypos,yypos+6))
| 5 => (YYBEGIN COMMENT; continue())
| 55 => (YYBEGIN PRAGMA ; Tokens.PREFIX(yypos,yypos+7))
| 64 => (YYBEGIN PRAGMA ; Tokens.POSTFIX(yypos,yypos+8))
| 70 => (YYBEGIN PRAGMA; Tokens.NAME(yypos,yypos+5))
| 73 => (YYBEGIN DCOMMENT; comLevel := 1; continue())
| 76 => (error ("unmatched close comment }%", (yypos, yypos+2));
		    continue())
| 8 => (Tokens.BACKARROW(yypos,yypos+2))
| 85 => (Tokens.LCID (yytext,yypos,yypos+size yytext))
| 92 => (Tokens.UCID (yytext,yypos,yypos+size yytext))
| 95 => (Tokens.LCID (yytext,yypos,yypos+size yytext))
| _ => raise Internal.LexerError

		) end )

	val {fin,trans} = Vector.sub(Internal.tab, s)
	val NewAcceptingLeaves = fin::AcceptingLeaves
	in if l = !yybl then
	     if trans = #trans(Vector.sub(Internal.tab,0))
	       then action(l,NewAcceptingLeaves
) else	    let val newchars= if !yydone then "" else yyinput 1024
	    in if (size newchars)=0
		  then (yydone := true;
		        if (l=i0) then UserDeclarations.eof ()
		                  else action(l,NewAcceptingLeaves))
		  else (if i0=l then yyb := newchars
		     else yyb := substring(!yyb,i0,l-i0)^newchars;
		     yygone := !yygone+i0;
		     yybl := size (!yyb);
		     scan (s,AcceptingLeaves,l-i0,0))
	    end
	  else let val NewChar = ordof(!yyb,l)
		val NewState = if NewChar<128 then ordof(trans,NewChar) else ordof(trans,128)
		in if NewState=0 then action(l,NewAcceptingLeaves)
		else scan(NewState,NewAcceptingLeaves,l+1,i0)
	end
	end
(*
	val start= if substring(!yyb,!yybufpos-1,1)="\n"
then !yybegin+1 else !yybegin
*)
	in scan(!yybegin (* start *),nil,!yybufpos,!yybufpos)
    end
end
  in lex
  end
end
