Begin Silent.
AddPath ".".
AddPath "$COQTH/PROGRAMS".
AddPath "$COQTH/SYSTEM".

Require Demo "$COQTH/CONTRIB/Rocq/DEMOS/Demo".
Require Demo2 "$COQTH/CONTRIB/Rocq/DEMOS/Demo2".

AddPath "$COQTH/ARITH".
Restore State Initial.
Require Arith.
Save State after_Arith "After loading the ARITH/Arith library".

Require Wf_nat.
Save State after_Wf_nat "After loading the Wf_nat library".

Require Compare.
Save State after_Compare "After loading the Compare libary".

AddPath "$COQTH/LISTS".
Require List. (* CP *)
Require Inlist. (* CP *)
Save State after_List "After loading the LISTS/List library".

AddPath "$COQTH/SETS".
Require SetTheory.
Save State after_SetTheory "After loading the SETS/SetTheory library".

AddPath "$COQTH/BOOL".
Require Bool.
Save State after_Bool.

Restore State Initial.
Require Classical.
Save State after_Classical.

Restore State after_Arith.
Require Ack "$COQTH/CONTRIB/Rocq/DEMOS/Ack".
Save State after_Ack "Ackermann's function".
Restore State after_Arith.
Require Ack_prog "$COQTH/PROGRAMS/Ack_prog".

(* Lists and Sorting *)

Restore State after_List.
Require TheoryList.

Restore State after_List.
Require Quick_proof "$COQTH/PROGRAMS/Quick_proof".(* CP *)
Restore State after_List.
Require Quick_prog "$COQTH/PROGRAMS/Quick_prog".(* CP *)
Save State after_Quick "First version of Quicksort".

Restore State after_List.
Require Quick2_proof "$COQTH/PROGRAMS/Quick2_proof".(* CP *)
Restore State after_List.
Require Quick2_prog "$COQTH/PROGRAMS/Quick2_prog".(* CP *)
Save State after_Quick2 "Second version of Quicksort".

Restore State after_List.
Require Heap_proof "$COQTH/PROGRAMS/Heap_proof".(* BW *)
Require Heap_prog "$COQTH/PROGRAMS/Heap_prog".(* BW *)
Save State after_Heap.

Restore State after_List.
Require Mergesort_proof "$COQTH/PROGRAMS/Mergesort_proof". (* BW *)
Require Mergesort_prog "$COQTH/PROGRAMS/Mergesort_prog". (* BW *)
Save State after_Mergesort.

(* Various Algorithms *)

Restore State after_SetTheory.

Require Warshall_proof "$COQTH/PROGRAMS/Warshall_proof". (* CP *)
Require Warshall_prog "$COQTH/PROGRAMS/Warshall_prog". (* CP *)

Require Floyd_proof "$COQTH/PROGRAMS/Floyd_proof". (* CP *)
Require Floyd_prog "$COQTH/PROGRAMS/Floyd_prog". (* CP *)

Require Dijkstra_proof "$COQTH/PROGRAMS/Dijkstra_proof". (* CP *)
Restore State after_Compare.
Require Dijkstra_prog "$COQTH/PROGRAMS/Dijkstra_prog". (* CP *)

Restore State after_Arith.
Require Avl_proof "$COQTH/PROGRAMS/Avl_proof". (* CP *)
Require Avl_prog "$COQTH/PROGRAMS/Avl_prog". (* CP *)

Restore State Initial.
Require Manna "$COQTH/PROGRAMS/ALG/Manna". (* CP *) 

Restore State Initial.
Require Format "$COQTH/PROGRAMS/ALG/Format".

Restore State Initial.
Require Peano_prog.

Restore State after_Arith.
Require Compare_prog.

Restore State after_Compare.
Require Div "$COQTH/ARITH/Div".

Restore State after_Compare.
Require Euclid_proof "$COQTH/PROGRAMS/Euclid_proof". (* CP *)
Require Euclid_prog "$COQTH/PROGRAMS/Euclid_prog". (* CP *)
Save State after_Euclid.

(* Gilbreath's card trick *)
Restore State after_Bool.
Require Shuffle "$COQTH/CONTRIB/Rocq/SHUFFLE/Shuffle". (* GH *)

(* A tautology checker *)
Restore State after_Bool.
Require Tauto_proof "$COQTH/PROGRAMS/Tauto_proof". (* CP,BW *)
Restore State after_Bool.
Require Tauto_prog "$COQTH/PROGRAMS/Tauto_prog". (* CP,BW *)

(* Algorithms on Streams-CP *)
Restore State after_Euclid.
Require Eratosthene "$COQTH/STREAMS/Eratosthene".
Require Eqdep "$COQTH/STREAMS/Eqdep".
Require Streams "$COQTH/STREAMS/Streams".

(* Higman's lemma *)
Restore State after_Arith.
Require Higman "$COQTH/CONTRIB/Rocq/HIGMAN/Higman".   (* HH *)

(* Set Theory *)

Restore State Initial.
Require Logic_Type.
Save State after_Logic_Type.

Require Sch_Set "$COQTH/SETS/Sch_Set". (* HH *)
Require Schroeder "$COQTH/SETS/Schroeder". (* HH *)

Restore State after_Logic_Type.
Require Relations "$COQTH/RELATIONS/Relations". (* GH *)
Require Newman "$COQTH/RELATIONS/Newman". (* GH *)

Restore State after_Logic_Type.
Require Tarski "$COQTH/CONTRIB/Rocq/DEMOS/Tarski". (* GD *)
Restore State after_Logic_Type.
Require Tarski1 "$COQTH/CONTRIB/Rocq/DEMOS/Tarski1". (* GD *)

(* Paradoxes *)

Restore State after_Logic_Type.
Require Log_Rel "$COQTH/CONTRIB/Rocq/PARADOXES/Log_Rel". (* AF *)

Reset Initial.
Require Log_Rel1 "$COQTH/CONTRIB/Rocq/PARADOXES/Log_Rel1". (* AF *)
Require Reynolds1 "$COQTH/CONTRIB/Rocq/PARADOXES/Reynolds1". (* AF *)

Restore State after_Arith.
Load "$COQTH/CONTRIB/Rocq/LAMBDA/paths".
Require Lambda "$COQTH/CONTRIB/Rocq/LAMBDA/Lambda".

Restore State after_Arith.
Load "$COQTH/CONTRIB/Nancy/FOUnify/paths".
Require term_unif.

Restore State after_Arith.
Load "$COQTH/CONTRIB/Utrecht/ABP/ABP".

Restore State after_Arith.
Load "$COQTH/CONTRIB/Bordeaux/EXCEPTIONS/leavemult".

Restore State after_Classical.
Load "$COQTH/CONTRIB/Nijmegen/Rem.v".

Restore State Initial.
Load "$COQTH/CONTRIB/Utrecht/Ramsey/Ramsey".

Restore State after_Arith.
Load "$COQTH/CONTRIB/Rocq/ARITH/Chinese/paths".
Load "$COQTH/CONTRIB/Rocq/ARITH/Chinese/Z".

Restore State Initial.
Load "$COQTH/CONTRIB/Rocq/COMPILER/Mini_ML".

Restore State Initial.
Load "$COQTH/CONTRIB/Sophia-Antipolis/condom/paths".
Require condom.

Restore State Initial.
Load "$COQTH/CONTRIB/Rocq/ALGEBRA/Algebra".

Restore State Initial.
Load "$COQTH/CONTRIB/Rocq/SUBST/paths".
Require confluence_LSL.

Restore State Initial.
Load "$COQTH/CONTRIB/Lyon/AUTOMATA/paths".
Require extract.

Restore State after_Arith.
Load "$COQTH/CONTRIB/Eindhoven/ABP/paths".
Load "$COQTH/CONTRIB/Eindhoven/ABP/ABP".

