(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                       Well-founded recursion                              *)
(*                                                                           *)
(*****************************************************************************)
(*      Definitions and lemmas concerning well-founded induction             *)
(*****************************************************************************)

Chapter  Well_founded.

Variable A : Set.

(* The accessibility predicate is defined to be non-informative *)

Inductive Definition Acc [R:A->A->Prop] : A -> Prop 
   = Acc_intro : (x:A)((y:A)(R y x)->(Acc R y))->(Acc R x).

(* the informative elimination :
   to be realised by a fixpoint
   let  Acc_rec F = let rec wf x = F x wf in wf *)
 
Axiom Acc_rec : (R:A->A->Prop)
        (P:A->Set)
         ((x:A)((y:A)(R y x)->(Acc R y))->((y:A)(R y x)->(P y))->(P x))
         ->(a:A)(Acc R a)->(P a).

(* A relation is well-founded if every element is accessible *)

Definition well_founded = [R:A->A->Prop](a:A)(Acc R a).

(* well-founded induction *)

Goal (R:A->A->Prop)(well_founded R)->
     (P:A->Set)((x:A)((y:A)(R y x)->(P y))->(P x))->(a:A)(P a).
Intros; Apply (Acc_rec R); Auto.
(*Apply H.*)
Save well_founded_induction.

End Well_founded.

Provide Wf.
