(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*     Basic specifications : Sets containing logical information            *)
(*                                                                           *)
(*****************************************************************************)

(**************************************************************)
(* Basic specifications : Sets containing logical information *)
(**************************************************************)

Inductive Set sig [A:Set;P:A->Prop] 
    = exist : (x:A)(P x) -> {x:A | (P x)}.

Inductive Set sig2 [A:Set;P,Q:A->Prop] 
    = exist2 : (x:A)(P x) -> (Q x) -> {x:A | (P x) & (Q x)}.

Inductive Set sigS [A:Set;P:A->Set] 
    = existS : (x:A)(P x) -> {x:A & (P x)}.

Inductive Set sigS2 [A:Set;P,Q:A->Set] 
    = existS2 : (x:A)(P x) -> (Q x) -> {x:A & (P x) & (Q x)}.

Syntax sumbool "{_}+{_}".
Inductive Upon bool Set sumbool [A,B:Prop] 
    = left : A ->({A}+{B}) | right : B->({A}+{B}).

Generative Inductive Set sumor [A:Set;B:Prop] 
    = inleft : A -> (A+{B}) | inright : B -> (A+{B}).

Inductive Upon sumor Set Exc [A:Set] = value : A->(Exc A) | error : (Exc A).


(**********)
(* Choice *)
(**********)

Lemma Choice : (S,S':Set)(R:S->S'->Prop)((x:S){y:S'|(R x y)})
                       -> {f:S->S'|(z:S)(R z (f z))}.
Goal.
Intros S S' R H.
Exists [z:S](<S'>Match (H z) with [y:S'][h:(R z y)]y).
Intro z; Elim (H z); Trivial.
Save.

Lemma Choice2 : (S,S':Set)(R:S->S'->Set)((x:S){y:S' & (R x y)})
                       -> {f:S->S' & (z:S)(R z (f z))}.
Goal.
Intros S S' R H.
Exists [z:S](<S'>Match (H z) with [y:S'][h:(R z y)]y).
Intro z; Elim (H z); Trivial.
Save.

Lemma bool_choice : (S:Set)(R1,R2:S->Prop)((x:S){(R1 x)}+{(R2 x)}) ->
 {f:S->bool|(x:S)( (<bool>(f x)=true  /\ (R1 x)) 
                \/ (<bool>(f x)=false /\ (R2 x)))}.
Goal.
Intros S R1 R2 H.
Exists [z:S](<bool>Match (H z) with [r:(R1 z)]true [r:(R2 z)]false).
Intro z; Elim (H z); Auto.
Save.


(*******************************)
(* Self realizing propositions *)
(*******************************)

Axiom False_rec : (P:Set)False->P.
Definition except = False_rec. (* for compatibility with previous versions *)


Theorem absurd_set : (A:Prop)(C:Set)A->(~A)->C.
Goal.
Intros A C h1 h2.
(*    h2 : ~A
      h1 : A
      C : Prop
      A : Prop
      subgoal  C *)
Apply False_rec.
Apply (h2 h1).
Save.

Theorem and_rec : (A,B:Prop)(C:Set)(A->B->C)->(A/\B)->C.
Goal.
Intros A B C F AB; Apply F; Elim AB; Auto.
Save.

Axiom eq_rec : (A:Set)(a:A)(P:A->Set)(P a)->(b:A)(<A>a=b)->(P b).

(* For compatibility with previous versions *)

Definition eq_spec = [A:Set][a,b:A][H:<A>a=b][P:A->Set][H':(P a)]
                     (eq_rec A a P H' b H).

Hint left right inleft inright.

Provide Specif.
