(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*          Prelude :  Logical connectives, quantifiers, equality            *)
(*                                                                           *)
(*****************************************************************************)

Chapter Prelude.

Section Logic.

Inductive Definition True : Prop = I : True. 

Section Negation.

(* Absurdity *)

Inductive Definition False : Prop = . 

(* Negation *)

Definition not [A:Prop]A->False.
 Syntax not "~_". 

End Negation.

Section Conjunction.

(* Pairing / Introduction *)

 Syntax and "_/\\_". 

Syntax conj "<_,_>{_,_}". 
Inductive Definition and [A,B:Prop] : Prop = conj : A->B->(A/\B).

Section Projections.

Variables A,B : Prop.

Theorem proj1.
Statement (A/\B)->A.
Proof (and_ind A B A [y:A][z:B]y).
    
Theorem proj2.
Statement (A/\B)->B.
Proof (and_ind A B B [y:A][z:B]z).

End Projections.

Syntax proj1 "<_,_>Fst{_}".
Syntax proj2 "<_,_>Snd{_}". 

End Conjunction.

Section Disjunction.

Syntax or "_\\/_". 
Inductive Definition or [A,B:Prop] : Prop
    = or_introl : A -> (A\/B) | or_intror : B -> (A\/B).

End Disjunction.

(* Equivalence *)

Definition iff = [P,Q:Prop](P -> Q) /\ (Q -> P).
Syntax iff "_ <-> _".

Definition IF = [P,Q,R:Prop](P /\ Q) \/ (~P /\ R).
Syntax IF "if _ then _ else _".

(* First-order quantifiers *)

Definition all.
Body [A:Set][P:A->Prop](x:A)(P x). 
Syntax all "<_>All(_)".

Syntax ex "<_>Ex(_)".
Inductive Definition ex [A:Set;P:A->Prop] : Prop 
    = ex_intro : (x:A)(P x)->(<A>Ex(P)).

Syntax ex2 "<_>Ex2(_,_)".
Inductive Definition ex2 [A:Set;P,Q:A->Prop] : Prop
    = ex_intro2 : (x:A)(P x)->(Q x)->(<A>Ex2(P,Q)).

(* Equality *)

Syntax eq "<_>_=_".
Inductive Definition eq [A:Set;x:A] : A->Prop
    = refl_equal : <A>x=x.


End Logic.

(*****************************************************************************)
(*                                                                           *)
(*                     Basic programming with Set                            *)
(*                                                                           *)
(*****************************************************************************)

(************************)
(* Programming Language *)
(************************)

(* Basic sets *)

Inductive Set unit = tt : unit.

Generative Inductive Set bool = true : bool | false : bool.

Generative Inductive Set nat = O : nat | S : nat->nat.

(* Disjoint sum of two sets *)

Syntax sum "_+_".
Inductive Set sum [A,B:Set] 
    = inl : A -> (A+B) | inr : B -> (A+B).

(* Product of Sets *)

Syntax prod  "_*_".
Syntax pair "<_,_>(_,_)".
Inductive Set prod [A,B:Set] = pair : A->B->(A*B).

Section programming.
   Variables A,B:Set.
Theorem fst.
Statement (A*B)->A.
Proof [u:A*B](<A>Match u with (* y,z *) [y:A][z:B]y). 
    
Theorem snd.
Statement (A*B)->B.
Proof [u:A*B](<B>Match u with (* y,z *) [y:A][z:B]z). 
End programming. 

Syntax fst "<_,_>Fst(_)".
Syntax snd "<_,_>Snd(_)".

Section Prelude_lemmas.

Theorem absurd : (A:Prop)(C:Prop)A->(~A)->C.
Goal.
Unfold not; Intros A C h1 h2.
Elim (h2 h1).
Save.

Section equality.
 Variable A,B : Set.
 Variable f   : A->B.
 Variable x,y,z : A.

 Theorem sym_equal : (<A>x=y) -> <A>y=x.
 Goal.
 Intros h; Elim h.
 (*    h : <A>x=y |- <A>x=x *)
 Apply refl_equal.
 Save.

 Theorem trans_equal : (<A>x=y) -> (<A>y=z) -> <A>x=z.
 Goal.
 Intros h1 h2; Elim h2; Apply h1.
 Save.

 Theorem f_equal : (<A>x=y)-><B>(f x)=(f y).
 Goal.
 Intros h; Elim h.
 (*    h : <A>x=y |- <B>(f x)=(f x) *)
 Apply refl_equal.
 Save.

 Theorem sym_not_equal : (~<A>x=y) -> ~<A>y=x.
 Goal.
 Red; Intros h1 h2; Apply h1; Elim h2.
 Apply refl_equal.
 Save.

End equality.

Section Properties_of_Relations.
 Variable A 		: Set.
 Variable R 		: A->A->Prop.

     Definition refl = (x:A)(R x x).
     Definition trans = (x,y,z:A)(R x y) -> (R y z) ->(R x z).
     Definition sym = (x,y:A)(R x y) -> (R y x).
     Definition equiv = refl /\ trans /\ sym.

End Properties_of_Relations.

End Prelude_lemmas.

End Prelude.

Hint I conj or_introl or_intror pair inl inr refl_equal.
Immediate sym_equal sym_not_equal.

Provide Prelude.
