(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*									     *)
(*	    First-order connectives for HOL with objects : A :Type           *)
(*									     *)
(*****************************************************************************)


Section universal_quantification.

Definition allT.
   Type A.
   Variable P : A->Prop.
Body (x:A)(P x). 
 
Syntax allT "<_>AllT(_)". 

Type A.
Variable P : A->Prop.

Theorem inst.
Statement  (x:A)<A>AllT(P)->(P x).
Proof     [x:A][h:<A>AllT(P)](h x).

Theorem gen.
Statement (B:Prop)(f:(y:A)B->(P y))B-><A>AllT(P).
Proof [B:Prop][f:(y:A)B->(P y)][y:B][z:A](f z y).

End universal_quantification.

Section existential_quantification.

Syntax exT "<_>ExT(_)".

Inductive Definition exT [A:Type;P:A->Prop] : Prop
    = exT_intro : (x:A)(P x)->(<A>ExT(P)).

Syntax exT2 "<_>ExT2(_,_)".

Inductive Definition exT2 [A:Type;P,Q:A->Prop] : Prop
    = exT_intro2 : (x:A)(P x)->(Q x)->(<A>ExT2(P,Q)).

End existential_quantification.

Section equality.

(* Leibniz equality : [A:Type][x,y:A] (P:A->Prop)(P x)->(P y) *)

Syntax eqT "<_>_==_".
Inductive Definition eqT [A:Type;x:A] : A -> Prop
                       = refl_eqT : <A>x==x.

End equality.


Section Equality_is_a_congruence.
Variables A,B : Type.
Variable  f : A->B.

 Variable x,y,z : A.
 
 Goal (<A>x==y) -> <A>y==x.
 Intros h.
 (*    h : <A>x==y
       subgoal  <A>y==x *)
 Elim h.
 (*    subgoal  <A>x==x *)
 Apply refl_eqT.
 Save sym_eqT.


 Goal (<A>x==y) -> (<A>y==z) -> <A>x==z.
 Intros h1 h2 ; Elim h2 ; Apply h1.
 Save trans_eqT.

 Goal (<A>x==y)-><B>(f x)==(f y).
 Intros h ; Elim h.
 (*    h : <A>x==y
       subgoal  <B>(f x)==(f x) *)
 Apply refl_eqT.
 Save  congr_eqT.

End Equality_is_a_congruence.

Provide Logic_Type.
