(* Classical Logic *)

Axiom classic: (P:Prop)(P \/ ~(P)).

Lemma NNPP : (p:Prop)~(~(p))->p.
Goal.
Unfold not; Intros; Elim (classic p); Trivial.
Intro NP; Elim (H NP).
Save.

(* de Morgan laws for quantifiers *)

Lemma not_all_ex_not : (P:nat->Prop)(~((n:nat)(P n)) ->
                            <nat>Ex ([n:nat]~(P n))).
Goal.
Unfold not; Intros P notall.
Apply NNPP; Unfold not.
Intro abs.
Cut ((n:nat)(P n)); Trivial.
Intro n; Apply NNPP.
Unfold not; Intros.
Apply abs; Exists n; Trivial.
Save.


Lemma not_ex_all_not : (P:nat->Prop)~(<nat>Ex ([n:nat](P n))) -> 
                                    (n:nat)~(P n).
Goal.
Unfold not; Intros P notex n abs.
Apply notex.
Exists n; Trivial.
Save. 

Lemma ex_not_not_all : (P:nat->Prop)(<nat>Ex ([n:nat]~(P n))) -> 
                                    ~(n:nat)(P n).
Goal.
Unfold not; Intros P exnot allP.
Elim exnot; Auto.
Save.

Lemma all_not_not_ex : (P:nat->Prop)((n:nat)~(P n)) ->
                           ~<nat>Ex ([n:nat](P n)).
Goal.
Unfold not; Intros P allnot exP; Elim exP; Intros n p.
Apply allnot with n; Auto.
Save.

Provide Classical.
