(****************************************************************)
(* 		    Parameterised Streams  		        *)
(*                Christine Paulin-Mohring                      *)
(*			  May 92                                *)
(****************************************************************)

Require Arith.
Require Eqdep.


Chapter Streams.

Variable U : Set.

Inductive Set Streams [A:U->U->Set; m: U]
  = build : (P:U->Set)((p:U)(P p)->{q:U & (A p q) & (P q)})
                                  ->(P m)->(Streams A m).

Variable A : U -> U -> Set.

Local streams = (Streams A).

Definition eq_streams (eq_dep U streams).

Goal (m:U)(X:(streams m))(eq_streams m X m X).
Red; Auto.
Save eq_streams_intro.
Hint eq_streams_intro.

Goal (m,n:U)(X:(streams m))(Y:(streams n))
     (eq_streams m X n Y)->(eq_streams n Y m X).
Exact (eq_dep_sym U streams).
Save eq_streams_sym.
Immediate eq_streams_sym.

Goal (m,n,p:U)(X:(streams m))(Y:(streams n))(Z:(streams p))
     (eq_streams m X n Y)->(eq_streams n Y p Z)->(eq_streams m X p Z).
Exact (eq_dep_trans U streams).
Save eq_streams_trans.

Goal (m:U)(streams m)->{q:U & (A m q) & (streams q)}.
Induction 1; Intros.
Elim (s m); Intros; Trivial.
Exists x; Trivial.
Red; Apply build with P; Auto.
Save out.

Goal (m:U)(streams m)->U.
Intros; Elim (out m H); Intros.
Exact x.
Save hd.

Goal (m:U)(X:(streams m))(streams (hd m X)).
Intros; Unfold hd; Elim (out m X); Auto.
Save tail.

Goal (m:U)(X:(streams m))
 {q:U & (A m q) & {Y:(streams q)| (eq_streams q Y (hd m X) (tail m X))}}.
Intros; Unfold hd tail; Elim (out m X).
Intros x a Y; Exists x; Trivial.
Exists Y; Trivial.
Save out_hd_tail.

Goal nat->(m:U)(streams m)->U.
Induction 1; Intros.
Exact m.
Apply (H0 (hd m H1) (tail m H1)).
Save hd_nth.

Goal (n:nat)(m:U)(X:(streams m))(streams (hd_nth n m X)).
Induction n; Simpl; Intros; Trivial.
Save tail_nth.

Goal (n,k:nat)(m:U)(X:(streams m))
     (eq_streams
            (hd_nth (plus n k) m X) (tail_nth (plus n k) m X)
            (hd_nth k (hd_nth n m X) (tail_nth n m X))
            (tail_nth k (hd_nth n m X) (tail_nth n m X))).
Induction n; Simpl; Trivial.
Save tail_plus.
Hint tail_plus.

Goal (m:U)(X:(streams m))(A m (hd m X)).
Intros; Unfold hd; Elim (out m X); Auto.
Save specif.


(*******************************************************)
(*   Filter                                            *)
(*******************************************************)

Section Filter.

(* Load Between. *)

Variable P,Q : U -> Prop.

(* R is decidable *)
Hypothesis PQ_dec : (x:U){(P x)}+{(Q x)}.
Hypothesis PQ_excl : (x:U)(P x)->~(Q x).

Immediate PQ_excl.

Variable B : U -> U -> Set.
Hypothesis incl : (x,y:U)(A x y)->(B x y).
Hypothesis trans_ARB : (x,y,z:U)(A x y)->(P y)->(B y z)->(B x z).
Hint incl.

Section Stream_X.

Variable x : U.
Variable X : (streams x).
Local hdSX = [k:nat](hd_nth (S k) x X).

Local tlSX : (n:nat)(streams (hdSX n))
          = [n:nat](tail_nth (S n) x X).

Definition P_nth_X : nat -> Prop
                   = [k:nat](P (hdSX k)).

Definition Q_nth_X : nat -> Prop
                   = [k:nat](Q (hdSX k)).


Inductive Definition filter_specif [q:U] : Set =
   filter_intro :
   (B x q)->(Q q)
   ->(Y:(streams q))
     (m:nat)(eq_streams q Y (hdSX m) (tlSX m))->(between P_nth_X O m)
   ->(filter_specif q).

End Stream_X.

Section Properties.

Variable x,q : U.
Variable X : (streams x).
Variable Y : (streams q).
Hypothesis Y_tlX : (eq_streams q Y (hd x X) (tail x X)).

Goal (P q)->(P_nth_X x X O).
Red; Simpl; Elim Y_tlX; Auto.
Save P_nth_X_O.
Hint P_nth_X_O.

Goal (Q_nth_X x X O)->(Q q).
Unfold Q_nth_X; Simpl; Elim Y_tlX; Auto.
Save Q_nth_X_O.
Hint Q_nth_X_O.

Goal (eventually (Q_nth_X x X) O)->(Q q).
Intros; Apply Q_nth_X_O; Apply event_O; Trivial.
Save event_Q_nth_O.

Goal (m:nat)(P_nth_X q Y m)->(P_nth_X x X (S m)).
Red; Simpl; Intros.
Elim Y_tlX; Auto.
Save P_nth_X_S.
Hint P_nth_X_S.

Goal (m:nat)(Q_nth_X x X (S m))->(Q_nth_X q Y m).
Unfold Q_nth_X ; Simpl.
Elim Y_tlX; Auto.
Save Q_nth_X_S.
Hint Q_nth_X_S.

Goal (l:nat)(~(Q q))
     ->(eventually (Q_nth_X x X) (S l))->(eventually (Q_nth_X q Y) l).
Induction 2; Red; Intro k.
Pattern k;  Apply nat_case.
Intros; Absurd (Q q); Auto.
Intros; Exists m; Auto.
Save event_Q_nth_X_tl.

Goal (l:nat)(P q)
     ->(between (P_nth_X q Y) O l)->(between (P_nth_X x X) O (S l)).
Induction 2; Auto.
Save between_P_nth_X_tl.

End Properties.

Goal (n:nat)(x:U)(X:(streams x))
     (eventually (Q_nth_X x X) n)->{q:U & (filter_specif x X q)}.
Induction n; Intros.
(* case n=0 let q::Y = X *)
Elim (out_hd_tail x X); Intros q Axq HY.
Elim HY; Intros Y eqY.
(* the solution is (q,Y,O) because 
   (eventually (Q_nth_X x X) O)->(Q q)  *)
Exists q; Apply filter_intro with Y O; Auto.
Apply event_Q_nth_O with x X Y; Trivial.
(* case n = (S y), let q::Y = X *)
Elim (out_hd_tail x X); Intros q Axq HY.
Elim HY; Intros Y eqY.
(* the solution depends on (P q) or (Q q) *)
Elim (PQ_dec q); Intro.
(* case (P q), apply inductively the result to (q,Y) *)
Elim H with q Y.
(* let q'::Z be the result for Y *)
Intros q' f'.
Elim f'; Intros B notR Z m eqm betm.
(* the solution is (q',Z,(S m)) *)
Exists q'; Apply filter_intro with Z (S m); Trivial.
(* Proof of (B x q') *)
Apply trans_ARB with q; Auto.
(* Proof of 
     (eq_streams q' Z (hd_nth (S (S m)) x X) (tail_nth (S (S m)) x X)) *)
Change (eq_streams q' Z (hd_nth (S m) (hd x X) (tail x X))
                        (tail_nth (S m) (hd x X) (tail x X))).
Elim eqY; Trivial.
Apply between_P_nth_X_tl with q Y; Trivial.
Apply event_Q_nth_X_tl with x X; Auto.
(* case (Q q), the solution is (q,O,Y) *)
Exists q; Apply filter_intro with Y O; Auto.
Save filter_step.

Variable x : U.
Variable X : (streams x).

Local hdX = [k:nat](hd_nth k x X).

Local tlX : (n:nat)(streams (hdX n))
          = [n:nat](tail_nth n x X).

Hypothesis remanent : (n:nat){p:nat|(eventually (Q_nth_X (hdX n) (tlX n)) p)}.

Inductive Set Filter_specif [p,q:U] =
   Filter_intro : 
   (B p q)->(Q q)
   ->(n,m:nat)(<U>(hdX n)=p)->(<U>(hdX (S m))=q)->
              (between (P_nth_X x X) n m)
   ->(Filter_specif p q).

Section Lemmes.
Variable p : U.
Variable Y : (streams p).
Variable n : nat.
Hypothesis eqY : (eq_streams (hdX n) (tlX n) p Y).

Goal (l:nat)<U>(hd_nth (S (plus n l)) x X)=(hd_nth (S l) p Y).
Elim eqY; Intro.
Replace (S (plus n l)) with (plus n (S l)); Auto.
Unfold hdX tlX; Elim (tail_plus n (S l) x X); Auto.
Save Remark hd_nth_tail.

Goal (l:nat)(P_nth_X p Y l)->(P_nth_X x X (plus n l)).
Unfold P_nth_X.
Intro; Elim hd_nth_tail; Auto.
Save Remark P_nth_X_tail.
Hint P_nth_X_tail.

Goal (m:nat)(between (P_nth_X p Y) O m)->(between (P_nth_X x X) n (plus n m)).
Induction 1; Intros; Auto.
Replace (plus n (S l)) with (S (plus n l)); Auto.
Save between_between_tail.
End Lemmes.

Definition Filter_prop = 
  [p:U]{Y:(streams p) & {n:nat|(eq_streams (hdX n) (tlX n) p Y)}}.

Goal (Streams Filter_specif x).
Apply build with Filter_prop.
Induction 1; Intros Y HY.
Elim HY; Intros n HYn.
Elim (remanent n); Intros ln evln.
Elim (filter_step ln p Y).
Intros q fq; Elim fq; Intros Bq Rq Z m eqZm betZm.
Cut (eq_streams (hdX (plus n (S m))) (tlX (plus n (S m))) q Z).
Intro eqZ; Exists q.
Apply Filter_intro with n (plus n m); Trivial.
Elim HYn; Trivial.
Elim eqZ; Replace (S (plus n m)) with (plus n (S m)); Auto.
Apply between_between_tail with p Y; Trivial.
Red; Exists Z; Exists (plus n (S m)); Trivial.
Apply eq_streams_trans with (hd_nth (S m) p Y) (tail_nth (S m) p Y); Auto.
Elim HYn.
Exact (tail_plus n (S m) x X).
Elim HYn; Trivial.
(* Initial state : X *)
Red; Exists X; Exists O; Auto.
Save Filter.

End Filter.

End Streams.

Provide Streams.
