
(****************************************************************************)
(****************************************************************************)
(*									    *)
(*            SPECIFICATION  ET PREUVE DU CRIBLE D'ERATOSTHENE 		    *)
(*                     DANS LE CALCUL DES CONSTRUCTIONS  		    *)
(*            Francois Leclerc - ENS Lyon - Juin 91                         *)
(*									    *)
(****************************************************************************)
(****************************************************************************)

(*******************************************)
(* Arithmetical lemmas, euclidean division *)
(*******************************************)

Require Arith.
Require Peano_dec.
Require Euclid_proof.

Definition div  : nat->nat->Prop
	        = [b,a:nat]<nat>Ex([q:nat]<nat>a=(mult q b)).

(* Proof of decidability of div *)
Goal (a,b,r,q:nat)(<nat>a=(plus (mult q b) r))->(div b a)->(gt b r)-><nat>O=r.
Induction 2; Intros q' Hq'.
Replace r with (mult (minus q' q) b); Intros.
Elim (mult_O_le b (minus q' q)); Intros.
Rewrite H2; Auto.
Absurd (le b (mult (minus q' q) b)); Auto.
Rewrite mult_minus_distr.
Symmetry; Apply plus_minus.
Elim H; Auto.
Save div_mod_O.

Goal (p,q:nat)(lt O p)->{(div p q)}+{~(div p q)}.
Intros; Elim modulo with p q; Intros; Auto.
Elim (eq_nat_dec O x); Intro.
Left; Elim p0; Intros q0 Hq0.
Red; Exists q0.
Elim Hq0; Intros.
Rewrite H0.
Elim a; Auto.
Right; Red; Intro; Absurd <nat>O=x; Trivial.
Elim p0; Induction 1; Intros.
Apply div_mod_O with q p x0; Auto.
Save div_dec.

(***************************************************************************)
(* DEFINITION INDUCTIVE							   *)
(* divinf(p,q): il existe r entier, 1<r<=q, tel que r divise p 		   *)
(***************************************************************************)

Inductive Definition divinf [p,q:nat]:Prop
	  = Bs:(r:nat)(le (S (S O)) r)->(le r q)->(div r p)->(divinf p q).


(***************************************************************************)
(* DEFINITION INDUCTIVE							   *)
(* nondivinf(p,1) :pas de diviseur de p inferieur ou egal a 1		   *)
(* si nondivinf(p,q) et si Sq ne divise pas p alors nondivinf(p,Sq)	   *)
(* si nondivinf(p,q) et si existe 1<r<q, r divise Sq alors nondivinf(p,Sq) *) 	
(***************************************************************************)

Inductive Definition nondivinf [p:nat]: nat->Prop
  = Base:(nondivinf p (S O))
  | Step1:(q:nat)(nondivinf p q)->(~(div (S q) p))->(nondivinf p (S q))
  | Step2:(q:nat)(nondivinf p q)->(divinf (S q) q)->(nondivinf p (S q)).

Hint Base Step1 Step2.

(***************************************************************************)
(* DEFINITION INDUCTIVE "a la CAML" (type concret mais dependant)	   *)
(* natext(p,n) s'il n'existe pas de diviseur de n <= p 			   *)
(* natext(p,n) s'il existe un diviseur de n <= p			   *)
(***************************************************************************)

Inductive Set natext [p,n:nat]
	  = Nondiv:(nondivinf n p)->(natext p n)
	  | Div:(divinf n p)->(natext p n).

Hint Nondiv Div.

(***************************************************************************)
(* DEFINITION 								   *)
(* pour n et p donne, il existe P de type nat->Set telle que 		   *)
(* - on ait une preuve de P(n)						   *)
(* - pour tout q une preuve de P(q) donne une preuve de de P(Sq)	   *)
(* - pour tout q une preuve de P(q) donne une preuve de natext(p,q)	   *)
(*   i.e une preuve de l'existence ou non d'un diviseur de q dans [1...p]  *) 
(***************************************************************************)
Definition Filtre = [p,n:nat](C:Set)((P:nat->Set)((q:nat)(P q)->(natext p q))
		    ->((q:nat)(P q)->(P (S q)))->(P n)->C)->C.

(***************************************************************************)
(* Fitrebuild: construction d'une preuve de Filtre(p,n)  		   *)
(***************************************************************************)
Goal (p,n:nat)(P:nat->Set)
     ((q:nat)(P q)->(natext p q))->((q:nat)(P q)->(P (S q)))
     ->(P n)->(Filtre p n).
Intros.
Red.
Intros.
Apply (H2 P); Trivial.
Save Filtrebuild.

(***************************************************************************)
(* Filtrehd: construction d'une preuve de natext(p,n) a partir d'une 	   *)
(* preuve de Filtre(n,p)						   *)
(***************************************************************************)
Goal (p:nat)(n:nat)(Filtre p n)->(natext p n).
Intros.
Apply H.
Auto.
Save Filtrehd.
Immediate Filtrehd.

(***************************************************************************)
(* Filtre: construction d'une preuve de Filtre(p,Sn)	 a partir d'une	   *)
(* preuve de Filtre(p,n)						   *)
(***************************************************************************)
Goal (p:nat)(n:nat)(Filtre p n)->(Filtre p (S n)).
Intros.
Apply H.
Intros.
Apply Filtrebuild with P; Auto.
Save Filtretl.
Hint Filtretl.


(***************************************************************************)
(* LEMME1: s'il existe r, 1<r<=q tq r divise p				   *)
(*	   alors il existe aussi r', 1<r'<=Sq tq r' divise p (par ex r'=r) *)
(***************************************************************************)
Goal (q,p:nat)(divinf p q)->(divinf p (S q)).
Induction 1; Intros.
Apply Bs with r; Auto.
Save lemme1.
Hint lemme1.


(***************************************************************************)
(* SPECIFICATION DE Sift					   *)
(* Pour tous n et p tels que p>=1, a partir d'une preuve de Filtre(p,n)	   *)
(* on veut construire une preuve de Filtre(Sp,n)			   *)
(***************************************************************************)

Goal (p,n:nat)(le (S O) p)->(Filtre p n)->(Filtre (S p) n).
Intros.
Apply Filtrebuild with (Filtre p); Auto.
Intros; Elim (Filtrehd p q); Intros; Auto.
Elim (div_dec (S p) q); Auto.
Intros; Apply Div.
Apply Bs with (S p);Auto.
Save Sift.


(***************************************************************************)
(* SPECIFICATION DU CRIBLE D'ERATOSTHENE				   *)
(* Il existe une propriete P de type nat->Set telle que:		   *)
(* - on ait une preuve de P(1)						   *)
(* - pour tout q une preuve de P(q) donne une preuve de P(Sq)		   *)
(* - pour tout q une preuve de P(q) donne une preuve de natext(q,Sq) i.e   *)
(*   une preuve de l'existence ou non d'un diviseur de Sq dans [1...q]	   *)
(***************************************************************************)
Definition Eratosthene 
   = (C:Set)((P:nat->Set)((q:nat)(P q)->(natext q (S q)))
            ->((q:nat)(P q)->(P (S q)))->(P (S O))->C)->C.


Goal (P:nat->Set)((q:nat)(P q)->(natext q (S q)))->((q:nat)(P q)->(P (S q)))
     ->(P (S O))->Eratosthene.
Red; Intros.
Apply (H2 P); Auto.
Save Eratobuild.


(***************************************************************************)
(* LEMME2: pour tout q et r, une preuve de l'existence d'un diviseur de Sq *)
(*	   dans [1...q] et une preuve de l'existence ou non d'un diviseur  *)
(*         de r dans [1...q]  donne une preuve de l'existence ou non de r  *)
(*	   dans [1...Sq]  (preuve du lemme par cas)			   *)
(***************************************************************************)

Goal (q,r:nat)(divinf (S q) q)->(natext q r)->(natext (S q) r).
Induction 2; Auto.
Save lemme2.
Hint lemme2.


(***************************************************************************)
(* DEFINITION INDUCTIVE							   *)
(* Pred(q) propriete de tout q>=1 dont on a une preuve de Filtre(q,Sq)	   *)
(***************************************************************************)
Inductive Definition Pred[q:nat]: Set
	  = Predintro: (le (S O) q)->(Filtre q (S q))-> (Pred q).
Hint  Predintro.


(***************************************************************************)
(* PREUVE DE LA SPECIFICATION DU CRIBLE D'ERATOSTHENE			   *)
(* le terme correspondant a la preuve est le terme de F-OMEGA realisant la *)
(* specification							   *)
(***************************************************************************)

Goal Eratosthene.
Apply Eratobuild with Pred.  (* Elimination du "il existe" ds Eratobuild *)
Intros; Apply Filtrehd.
Elim H; Trivial.
Intros; Elim H;Intros.
Apply Predintro; Auto.
Elim (Filtrehd q (S q) f);Intro.
Apply Filtretl.
Apply Sift; Auto.
Apply f; Intros.
Apply Filtrebuild with P;Auto. 
Apply Predintro;Auto.
Apply Filtrebuild with (natext (S O)); Auto.
Save Crible.

Provide Eratosthene.
