(****************************************************************)
(*                Equality on Dependent sets                    *)
(*                Christine Paulin-Mohring                      *)
(*                        May 92                                *)
(****************************************************************)

Section Dependent_Equality.

Variable U : Set.
Variable P : U->Set.

Inductive Definition eq_dep [p:U;x:(P p)] : (q:U)(P q)->Prop =
   eq_dep_intro : (eq_dep p x p x).
Hint eq_dep_intro.

Goal (p,q:U)(x:(P p))(y:(P q))(eq_dep p x q y)->(eq_dep q y p x).
Induction 1; Auto.
Save eq_dep_sym.
Immediate eq_dep_sym.

Goal (p,q,r:U)(x:(P p))(y:(P q))(z:(P r))
     (eq_dep p x q y)->(eq_dep q y r z)->(eq_dep p x r z).
Induction 1; Auto.
Save eq_dep_trans.

Inductive Definition eq_dep1 [p:U;x:(P p);q:U;y:(P q)] : Prop =
   eq_dep1_intro : (h:<U>q=p)
                  (<(P p)>x=(eq_rec U q P y p h))->(eq_dep1 p x q y).

Axiom eq_rec_eq : (p:U)(Q:U->Set)(x:(Q p))(h:<U>p=p)
                  <(Q p)>x=(eq_rec U p Q x p h).

Goal (p:U)(x:(P p))(q:U)(y:(P q))(eq_dep1 p x q y)->(eq_dep p x q y).
Induction 1; Intros eq_qp.
Cut (h:<U>q=p)(y0:(P q))
    (<(P p)>x=(eq_rec U q P y0 p h))->(eq_dep p x q y0).
Intros; Apply H0 with eq_qp; Auto.
Rewrite eq_qp; Intros h y0.
Elim eq_rec_eq.
Induction 1; Auto.
Save eq_dep1_dep.

Goal (p,q:U)(x:(P p))(y:(P q))
     (eq_dep p x q y)->(eq_dep1 p x q y).
Induction 1; Intros.
Apply eq_dep1_intro with (refl_equal U p).
Elim eq_rec_eq; Trivial.
Save eq_dep_dep1.

Goal (p:U)(x,y:(P p))
     (eq_dep1 p x p y)-><(P p)>x=y.
Induction 1; Intro.
Elim eq_rec_eq; Auto.
Save eq_dep1_eq.

End Dependent_Equality.

Hint eq_dep_intro.

Provide Eqdep.
