(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*    Lemmas on sets                                                         *)
(*                                                                           *)
(*****************************************************************************)


(********************************************************************)
(* Definitions and lemmas about sets.                               *)
(* A set is defined as a predicate on a data type.                  *)
(********************************************************************)

(************************************************)
(* Definition of sets on a Set Type V          *)
(************************************************)
Chapter set.

Parameter V : Set.

Axiom eqV : (x,y:V){<V>x=y}+{~<V>x=y}.

Definition set V->Prop.

Definition In.
Body [P:set][x:V](P x).

Definition incl.
Body [P,Q:set](x:V)(In P x)->(In Q x).

Definition empty.
Body [x:V]False : set.

Definition allV.
Body [x:V]True : set.

Section add.

Variable Q : set.
Variables x : V.

Definition add.
Body [y:V](In Q y)\/<V>x=y : set.

Variable y : V.

Goal (In Q y)->(In add y).
Intro.
Unfold In add.
Auto.
Save in_Q_add.

Goal (<V>x=y)->(In add y).
Intro.
Unfold In add.
Auto.
Save eq_add.

End add.

Inductive  Definition enumerate : set -> Set
	=  enu_empty : (enumerate empty)
        |  enu_add : (y:V)(Q:set)(~(In Q y))
		      ->(enumerate Q)->(enumerate (add Q y)).

(****************************)
(* Lemmas about sets        *)
(****************************)

Hint in_Q_add eq_add enu_empty enu_add (*in_Q_moins*).


Goal (x:V)~(In empty x).
Unfold not In empty ; Trivial.
Save in_empty.
Hint in_empty.

Goal (x:V)(In allV x).
Unfold In allV ; Trivial.
Save in_allV.
Hint in_allV.

Goal (W:set)(incl W allV).
Red ; Auto.
Save incl_allV.
Hint incl_allV.

Goal (W:set)(incl empty W).
Red ; Intros W x H.
Elim H.
Save incl_empty.
Hint incl_empty.

Goal (W,X,Y:set)(incl W X)->(incl X Y)->(incl W Y).
Unfold incl ; Auto.
Save incl_trans.

Goal (Q:set)(x:V)(incl Q (add Q x)).
Exact in_Q_add.
Save incl_Q_add.
Hint incl_Q_add.

Goal (Q:set)(x:V)(In (add Q x) x).
Unfold In add ; Auto.
Save in_add_x.
Hint in_add_x.

Goal (Q:set)(x,y:V)(In (add Q x) y)->((In Q y)\/<V>x=y).
Auto.
Save add_in_or_eq.

Goal (Q:set)(x,y:V)(In (add Q y) x)->{<V>y=x}+{(In Q x)}.
Intros Q x y H.
Elim (eqV y x) ; Auto ; Intro b.
Right.
Elim (add_in_or_eq Q y x H) ; Auto ; Intro H0.
Absurd <V>y=x ; Auto.
Save add_null.
Hint add_null.

Provide SetTheory.
