(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                        Schroeder-Bernstein's Theorem                      *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                            Hugo Herbelin                                  *)
(*                                                                           *)
(*****************************************************************************)


(*     If A is of cardinal less than B and conversely, then A and B          *)
(*       are equipollent                                                     *)
(*     In other words, if there is an injective map from A to B and          *)
(*   an injective map from B to A then there exists a map from A onto B.     *)

(*                (d'apres une demonstration de Fraenkel)                    *)

Require Logic_Type.
Require Sch_Set.

Section Schroeder_Bernstein.


(*****************************************************************************)
(*  The axiom of excluded-middle is assumed                                  *)
(*  On suppose l'axiome du tiers_exclu                                       *)


Hypothesis tiers_exclu : (U:Type)(x:U)(A:U->Prop)(not (A x))\/(A x).


(*****************************************************************************)
(*  The context : A is a set of elements in the univers U and B a set        *)
(*  over the univers U'                                                      *)
(*  On introduit le contexte :                                               *)
(*      A est un ensemble d'elements pris dans l'univers U                   *)
(*      B est un ensemble d'elements pris dans l'univers U'                  *)


Variables U,U':Type.

Local SU  (set U).
Local SU' (set U').

Variable A:SU.  (* A est un ensemble d'elements de l'univers U  *)
Variable B:SU'. (* B est un ensemble d'elements de l'univers U' *)


  Section Bijection.

  (**************************************************************************)
  (* On montre dans ce paragraphe que si f et g sont des injections resp    *)
  (* de A dans B et de B dans A alors on peut trouver un sous-ensemble J de *)
  (* A tq h qui est f sur J et g sur A\J est une bijection de A dans B      *)

  Variable f:(Relation U U').  (* f et g sont des relations *)
  Variable g:(Relation U' U).

  Hypothesis f_inj:(injection U U' A B f). (* f et g sont des injections *)
  Hypothesis g_inj:(injection U' U B A g).

  Local Imf (Im U U' f).
  Local Img (Im U' U g).


  (* Construction de J tq g(B\f(J))=A\J *)

    (* diff U A C designe la difference A\C           *)
    (* inclus U A C signifie que A est inclus dans C  *)

    Local F [C:SU](diff U A (Img (diff U' B (Imf C)))).


    Local D [C:SU](inclus U C (F C)).

    Local J (somme U D).


  (*  On va montrer que J correspond a ce que l'on cherche *)

    (* J correspond exactement au point fixe de Tarski pour F, *)
    (* fonction croissante relativement a l'inclusion          *)

    (* Lemma F est croissante *)

      Goal (C,C':SU)(inclus U C C')->(inclus U (F C) (F C')).
        Intros; Unfold F.
        Apply diff_culbute.
        Unfold Img.
        Apply Im_stable_par_incl.
        Apply diff_culbute.
        Unfold Imf.
        Apply Im_stable_par_incl.
        Assumption.
      Save Remark F_croissante.

    (* On va montrer que F(J)=A\Img(B\Imf(J))=J *)

       (* D'abord l'inclusion dans un sens *)

         (*  Lemma J_dans_FJ (inclus U J (F J))  *)

         Goal (inclus U J (F J)).
           Unfold J.
           Apply somme_inclus1.
           Intros C C_in_D.
           Apply trans_inclus with (F C).
           (* Que C est inclus dans (F C) *)
             Assumption.
           (* Que (F C) inclus dans (F (somme U D)) *)
             Apply F_croissante.
             Apply somme_inclus2.
             Assumption.
         Save Remark J_dans_FJ.

       (* Puis dans l'autre sens *)

         (*  Lemma FJ_dans_J (inclus U (F J) J)  *)

         Goal (inclus U (F J) J).
           Unfold J.
           Apply somme_inclus2.
           Red.
           Apply F_croissante.
           Exact J_dans_FJ.
         Save Remark FJ_dans_J.


  (* On montre que h qui est f sur J et g ailleurs est une bijection *)

    Inductive Definition h [x:U;y:U'] : Prop =
       hl_intro : (J x)->(f x y)->(h x y)
     | hr_intro : (diff U' B (Imf J) y)->(g y x)->(h x y).


  (*  Theorem h_bij (bijection U U' A B h)     *)

  Theorem h_bij.

  Statement (bijection U U' A B h).


    (* h est de A dans B *)
    Goal (Rel U U' A B h).

        Apply Rel_intro; Do 2 Intro; Intro h_x_y.
        (* h est sur A *) 
          Elim h_x_y.
          (* sur J : f est de A dans B *)
            Elim f_inj.
            Intro f_Rel; Intros.
            Elim f_Rel.
            Intros f_sur_A f_sur_B.
            Apply f_sur_A with y; Assumption.

        (* sur A\J: g est de B dans A *)
          Elim g_inj.
          Intro g_Rel; Intros.
          Elim g_Rel.
          Intros g_sur_B g_sur_A.
          Apply g_sur_A with y; Assumption.

      (* h est sur B *) 
        Elim h_x_y.
        (* sur J : f est de A dans B *)
          Elim f_inj.
          Intro f_Rel; Intros.
          Elim f_Rel.
          Intros f_sur_A f_sur_B.
          Apply f_sur_B with x; Assumption.

        (* sur A\J: g est de B dans A *)
        Elim g_inj.
        Intro g_Rel; Intros.
        Elim g_Rel.
        Intros g_sur_B g_sur_A.
        Apply g_sur_B with x; Assumption.

    Save Remark h1.


    (* h verifie au_plus_une_im *)
    Goal (au_plus_une_im U U' h).

      Red; Intros x y z h_x_y h_x_z.
      Elim h_x_y.

      (* sur J *)
        Elim h_x_z.
        (* cas ou (h x y) et (h x z) se comporte comme f : correct *)
          Elim f_inj.
          Unfold au_plus_une_im; Intros f_Rel f_au_plus_1_im; Intros.
          Apply f_au_plus_1_im with x; Assumption.

        (* Cas ou (h x y) se comporte comme f et
                  (h x z) comme g : contradiction *)
          Do 2 Intro; Intro x_in_J; Intro.
          Cut (inclus U J (F J)).
            Unfold inclus; Unfold F; Unfold diff; Intro Hyp.
            Elim (Hyp x x_in_J).
            Intros x_in_A x_in_non_Img.
            Elim x_in_non_Img.
            Red.
            Apply Im_intro with z; Assumption.
          Exact J_dans_FJ.

      (* sur A\J *)
        Elim h_x_z.
        (* Cas ou (h x y) se comporte comme g et
                  (h x z) comme f : contradiction *)
          Intro x_in_J; Intros.
          Cut (inclus U J (F J)).
            Unfold inclus; Unfold F; Unfold diff; Intro Hyp.
            Elim (Hyp x x_in_J).
            Intros x_in_A x_in_non_Img.
            Elim x_in_non_Img.
            Red.
            Apply Im_intro with y; Assumption.
          Exact J_dans_FJ.


        (* cas ou (h x y) et (h x z) se comporte comme g : correct *) 
          Elim g_inj.
          Unfold au_plus_un_ant; Do 3 Intro; Intro g_au_plus_1_ant; Intros.
          Apply g_au_plus_1_ant with x; Assumption.

    Save Remark h2.


    (* h verifie au_moins_une_im *)
    Goal (au_moins_une_im U U' A h).

      Red.
      Intros.
      Elim (tiers_exclu U x (Img (diff U' B (Imf J)))).

      (* sur J *)
      Intros.
        (* De f fonction, on deduit f verifie au_moins_une_im *)
        Elim f_inj.
        Unfold au_moins_une_im; Do 2 Intro; Intro f_au_moins_1_im; Intro.
        Elim (f_au_moins_1_im x H).
        Intros y f_x_y.
        Exists y.
        Apply hl_intro.
          Apply FJ_dans_J.
          Unfold F; Unfold diff.
          Split; Assumption.
        Assumption.

      (* sur A\J *)
      Unfold Img; Intro x_in_Img.
      Elim x_in_Img.
      Intros y g_y_x H1.
      Exists y.
      Apply hr_intro; Assumption.

    Save Remark h3.


    (* h verifie au_plus_un_ant *)
    Goal (au_plus_un_ant U U' h).

      Red; Do 3 Intro; Intros h_x_z h_y_z.
      Elim h_x_z.

      (* sur J *)
        Elim h_y_z.
        (* cas ou (h x y) et (h x z) se comporte comme f : correct *)
          Elim f_inj.
          Intros.
          Cut (x,y:U)(z:U')(f x z)->(f y z)-><U>x==y.
          Intro Hyp; Apply Hyp with z; Assumption.
          Assumption.

        (* Montrer qu'on ne peut avoir (f x z) et (g z y) avec x dans J et
            z hors de (Imf J) sans contradiction *)
          Unfold diff; Intro z_in_diff_B_Imf_J; Intros.
          Elim z_in_diff_B_Imf_J.
          Intros z_in_B z_in_non_Imf_J.
          Elim z_in_non_Imf_J.
          Red.
          Apply Im_intro with x; Assumption.

      (* sur A\J *)
        Elim h_y_z.
        (* Montrer qu'on ne peut avoir (f y z) et (g z x) avec x dans J et
            z hors de (Imf J) sans contradiction *)
          Unfold diff; Do 2 Intro; Intro z_in_diff_B_Imf_J; Intros.
          Elim z_in_diff_B_Imf_J.
          Intros z_in_B z_in_non_Imf_J.
          Elim z_in_non_Imf_J.
          Red.
          Apply Im_intro with y; Assumption.

        (* De g fonction on deduit g verifie au_plus_une_im c'est-a-dire
                                              au_plus_un_ant pour h *)
          Elim g_inj.
          Intros.
          Cut (z:U')(x,y:U)(g z x)->(g z y)-><U>x==y.
          Intro Hyp; Apply Hyp with z; Assumption.
          Assumption.

    Save Remark h4.


    (* h verifie au_moins_un_ant *)
    Goal (au_moins_un_ant U U' B h).

      Red.
      Intros.
      Elim (tiers_exclu U' y (Imf J)).

      (* sur A\J *)
        Intros.
        (* De g injective on deduit g verifie au_moins_une_im c'est-a-dire
                                              au_moins_un_ant pour h *)
          Elim g_inj.
          Unfold au_moins_une_im; Do 2 Intro; Intro g_au_moins_1_im; Intro.
          Elim (g_au_moins_1_im y H).
          Intros x g_y_x.
          Exists x.
          Apply hr_intro.
          Red.
          Split; Assumption.
          Assumption.

      (* sur J *)
      Unfold Imf; Intro y_in_Imf.
        (* De f injective on deduit f verifie au_moins_un_ant *)
          Elim y_in_Imf.
          Intros x f_x_y; Intro.
          Exists x.
          Apply hl_intro; Assumption.

    Save Remark h5.


    Proof (bijection_intro U U' A B h h1 h2 h3 h4 h5).

  End Bijection.


(*    Le theoreme de Schroeder-Bernstein-Cantor     *)

Goal (inf_card U U' A B)->(inf_card U' U B A)->(equipollence U U' A B).

  Intros A_inf_B B_inf_A.
  Elim A_inf_B.
  Intros.
  Elim B_inf_A.
  Intros.
  Apply equipollence_intro with (h f f0).
  Apply h_bij; Assumption.

Save Theorem Schroeder.


End Schroeder_Bernstein.


                           (* The end *)
Provide Schroeder.
