(*****************************************************************************)
(*          Projet Formel - Calculus of Inductive Constructions V5.8         *)
(*****************************************************************************)
(*                                                                           *)
(*                  Elementary notions of set theory                         *)
(*                                                                           *)
(*****************************************************************************)
(*                                                                           *)
(*                             Hugo Herbelin                                 *)
(*                                                                           *)
(*****************************************************************************)

(*      Embedding of elementary notions of set theory in the                 *)
(*      Calculus of Constructions in order to prove the                      *)
(*      Theorem of Schroeder-Bernstein                                       *)

(*****************************************************************************)
(*  The objects of the theory of sets (individuals and sets) are             *)
(* considered as elements of universes. This is expressed in the Calculus    *)
(* by taking universes as terms of type Type and individiduals and sets as   *)
(* terms of type a universe                                                  *)
(*                                                                           *)
(* Les objets ensemblistes (individuels et ensembles sont consideres         *)
(* comme appartenant a des univers, On traduit cela dans le Calcul en        *)
(* considerant les univers comme des termes de type Type et les objets       *)
(* ensemblistes comme des termes de type un univers                          *)

(* Load Logic_Type *)

Section Base_des_ens.

Variable U:Type.


(*****************************************************************************)
(* sets over individuals of the universe U are seen as their characteristic  *)
(* function.                                                                 *)
(* Notion de base : l'ensemble vu comme sa fonction caracteristique          *)

Definition set U->Prop.


(*****************************************************************************)
(* Some fundamental notions and their properties                             *)
(* Quelques notions de base et leurs proprietes                              *)


Section Inclusion.

Definition inclus [A,B:set](x:U)(A x)->(B x).

Variables A,B,C:set.

Theorem refl_inclus (inclus A A)
 Proof [x:U][h:(A x)]h.

Theorem trans_inclus (inclus A B)->(inclus B C)->(inclus A C)
 Proof [h1:(inclus A B)][h2:(inclus B C)][x:U][p:(A x)]
      (h2 x (h1 x p)).

End Inclusion.

(* Difference *)

Definition diff:set->set->set = [A,B:set][x:U](A x)/\(~(B x)).

Goal (A,B,B':set)
       (inclus B' B)->(inclus (diff A B) (diff A B')).
Intros A B B' B'_inclus_B; Unfold diff.
Red; Intros x x_in_B.
Elim x_in_B; Intros x_in_A x_in_nonB.
Split.
  Assumption.
Red; Intro x_in_B'.
Apply x_in_nonB.
Apply B'_inclus_B.
Assumption.
Save diff_culbute.

End Base_des_ens.


(* Sum of a set of sets *)

Section Somme.

Variable U:Type.

Inductive Definition somme [D:(set (set U));x:U] : Prop =
  somme_intro : (B:(set U))(D B)->(B x)->(somme D x).

Goal (D:(set (set U)))(A:(set U))
          ((C:(set U))(D C)->(inclus U C A))
          ->(inclus U (somme D) A).
Intros; Red; Intros x x_in_somme_D.
Elim x_in_somme_D.
Intros B B_in_D x_in_B.
Apply (H B B_in_D x x_in_B).
Save somme_inclus1.

Goal (D:(set (set U)))(A:(set U))(D A)->(inclus U A (somme D)).
Do 2 Intro; Red; Intros A_in_D x x_in_A.
Apply somme_intro with A; Assumption.
Save somme_inclus2.

End Somme.


(************************************************************************)
(*                              Relations                               *)
(************************************************************************)
(* A relation is seen as a characteristic function over a product of    *)
(* universes                                                            *)
(* L'objet relation : vu comme une fonction caracteristique             *)
(* sur un produit d'univers                                             *)

Definition Relation [U,U':Type]U->U'->Prop.


(************************************************************************)
(* Characterization of a relation over two sets                         *)
(* Caracterisation d'une relation d'un ensemble donne dans un autre     *)

Inductive Definition
   Rel [U,U':Type;A:(set U);B:(set U');R:(Relation U U')] : Prop =
   Rel_intro : ((x:U)(y:U')(R x y)->(A x))
             ->((x:U)(y:U')(R x y)->(B y))->(Rel U U' A B R).
 

(************************************************************************)
(*              Image of a set through a relation                       *)

Section Image.

Variables U,U':Type.

Inductive Definition Im [R:(Relation U U');A:(set U);y:U'] : Prop  =
     Im_intro : (x:U)(R x y)->(A x)->(Im R A y).

Goal (R:(Relation U U'))(A1,A2:(set U))
        (inclus U A1 A2)->(inclus U' (Im R A1) (Im R A2)).
Do 3 Intro; Intros A1_inclus_A2; Red; Intros x x_in_Im_A1.
Elim x_in_Im_A1.
Intros.
Apply Im_intro with x0; Try Assumption.
Apply A1_inclus_A2; Assumption.
Save Im_stable_par_incl.

End Image.


(************************************************************************)
(*                               Functions                              *)

Section Fonctions.

Variables U,U':Type.
Variable A:(set U).
Variable B:(set U').
Variable f:(Relation U U').


Definition au_plus_une_im (x:U)(y,z:U')(f x y)->(f x z)->(<U'>y==z).

Definition au_moins_une_im ((x:U)(A x)->(<U'>ExT(f x))).

Definition au_plus_un_ant (x,y:U)(z:U')(f x z)->(f y z)->(<U>x==y).

Definition au_moins_un_ant ((y:U')(B y)->(<U>ExT([x:U](f x y)))).


Inductive Definition fonction : Prop =          (* fun_in *)
   fonction_intro : (Rel U U' A B f)
                  ->au_plus_une_im
                  ->au_moins_une_im   ->fonction.

Inductive Definition surjection : Prop =        (* fun_on *)
   surjection_intro :   (Rel U U' A B f)
                  ->au_plus_une_im
                  ->au_moins_une_im
                  ->au_moins_un_ant   ->surjection.

Inductive Definition injection : Prop =         (* map_in *)
   injection_intro :   (Rel U U' A B f)
                  ->au_plus_une_im
                  ->au_moins_une_im
                  ->au_plus_un_ant  ->injection.

Inductive Definition bijection : Prop =         (* map_on *)
   bijection_intro : (Rel U U' A B f)
                  ->au_plus_une_im
                  ->au_moins_une_im
                  ->au_plus_un_ant
                  ->au_moins_un_ant  ->bijection.

End Fonctions.


(************************************************************************)
(*         Equipollence and relation "is of cardinal less than"         *)

Section Equipollence.

Variables U,U':Type.
Variable A:(set U).
Variable B:(set U').
Local Rela = (Relation U U').

Inductive Definition equipollence : Prop =
    equipollence_intro :  (f:Rela)(bijection U U' A B f)->equipollence.

Inductive Definition inf_card : Prop =
    inf_card_intro : (f:Rela)(injection U U' A B f)->inf_card.

End Equipollence.
Provide Sch_Set.
